/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adl14.ADL14ConversionMessageCode;
import com.nedap.archie.adl14.ADL14ConversionUtil;
import com.nedap.archie.adl14.ADL14NodeIDConverter;
import com.nedap.archie.adl14.ADL14TermConstraintConverter;
import com.nedap.archie.adl14.log.ADL2ConversionLog;
import com.nedap.archie.adl14.log.CreatedCode;
import com.nedap.archie.adl14.log.ReasonForCodeCreation;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openehr.utils.message.MessageCode;

public class PreviousConversionApplier {
    private ADL14NodeIDConverter converter;
    private final Archetype archetype;
    private final ADL2ConversionLog conversionLog;

    public PreviousConversionApplier(ADL14NodeIDConverter converter, Archetype archetype, ADL2ConversionLog conversionLog) {
        this.converter = converter;
        this.archetype = archetype;
        this.conversionLog = conversionLog;
    }

    public void addCreatedCodes() {
        if (this.conversionLog == null) {
            return;
        }
        if (this.conversionLog.getCreatedCodes() != null) {
            for (CreatedCode createdCode : this.conversionLog.getCreatedCodes().values()) {
                switch (createdCode.getReasonForCreation()) {
                    case C_OBJECT_WITHOUT_NODE_ID: {
                        this.applyPreviousSynthesizedCode(createdCode);
                        break;
                    }
                    case CREATED_VALUE_SET: {
                        break;
                    }
                    case CREATED_VALUE_FOR_EXTERNAL_TERM: {
                        this.applyPreviousTermCodeCreation(createdCode);
                    }
                }
            }
        }
    }

    public void addValueSets() {
        if (this.conversionLog == null) {
            return;
        }
        if (this.conversionLog.getCreatedValueSets() != null && !this.conversionLog.getCreatedValueSets().isEmpty()) {
            if (this.archetype.getTerminology().getValueSets() == null) {
                this.archetype.getTerminology().setValueSets(new LinkedHashMap<String, ValueSet>());
            }
            Map<String, ValueSet> valueSets = this.archetype.getTerminology().getValueSets();
            valueSets.putAll(this.conversionLog.getCreatedValueSets());
            for (Map.Entry<String, ValueSet> entry : this.conversionLog.getCreatedValueSets().entrySet()) {
                this.converter.addCreatedValueSet(entry.getKey(), entry.getValue());
            }
        }
    }

    private void applyPreviousTermCodeCreation(CreatedCode createdCode) {
        try {
            String existingTermBinding;
            Map<String, URI> termBindingsMap = this.archetype.getTerminology().getTermBindings().get(createdCode.getOriginalTerm().getTerminologyId());
            URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(createdCode.getOriginalTerm());
            if (termBindingsMap == null) {
                termBindingsMap = new LinkedHashMap<String, URI>();
                this.archetype.getTerminology().getTermBindings().put(createdCode.getOriginalTerm().getTerminologyId(), termBindingsMap);
            }
            if ((existingTermBinding = ADL14ConversionUtil.findExistingTermBinding(createdCode.getOriginalTerm().getTerminologyId(), this.archetype, null, uri, termBindingsMap)) == null) {
                String valueCode = createdCode.getGeneratedCode();
                termBindingsMap.put(valueCode, uri);
                CreatedCode newCreatedCode = new CreatedCode(valueCode, ReasonForCodeCreation.CREATED_VALUE_FOR_EXTERNAL_TERM);
                newCreatedCode.setOriginalTerm(createdCode.getOriginalTerm());
                this.converter.addCreatedCode(createdCode.getOriginalTerm().toString(), createdCode);
                ADL14TermConstraintConverter.addTermBindingCode(this.archetype, createdCode.getGeneratedCode(), uri, valueCode);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void applyPreviousSynthesizedCode(CreatedCode createdCode) {
        Object object = this.archetype.itemAtPath(createdCode.getPathCreated());
        if (object == null) {
            this.converter.getConversionResult().getLog().addInfoWithLocation((MessageCode)ADL14ConversionMessageCode.INFO_PREVIOUSLY_CONVERTED_CODE_DELETED, createdCode.getPathCreated(), new Object[0]);
        } else {
            if (!(object instanceof CAttribute)) {
                throw new IllegalArgumentException("path in previously converted node id points to a CObject, must be a CAttribute");
            }
            if (createdCode.getRmTypeName() == null) {
                throw new IllegalArgumentException("When applying a previously synthesized node id, the rm type name field must be present");
            }
            CAttribute attribute = (CAttribute)object;
            int index = attribute.getIndexOfChildWithMatchingRmTypeName(createdCode.getRmTypeName());
            if (index >= 0) {
                CObject cObject = attribute.getChildren().get(index);
                if (cObject.getNodeId() == null) {
                    cObject.setNodeId(createdCode.getGeneratedCode());
                    this.converter.addCreatedCode(createdCode.getGeneratedCode(), createdCode);
                } else {
                    this.converter.getConversionResult().getLog().addInfoWithLocation((MessageCode)ADL14ConversionMessageCode.INFO_PREVIOUSLY_CONVERTED_CODE_RENAMED, createdCode.getPathCreated(), new Object[0]);
                }
            } else {
                this.converter.getConversionResult().getLog().addInfoWithLocation((MessageCode)ADL14ConversionMessageCode.INFO_PREVIOUSLY_CONVERTED_CODE_DELETED, createdCode.getPathCreated(), new Object[0]);
            }
        }
    }

    public boolean isConvertedNode(String code) {
        return false;
    }

    public void removeCreatedUnusedTermCodesAndValueSets() {
        if (this.conversionLog == null) {
            return;
        }
        this.removeUnusedValuesets();
        this.removeUnusedValues();
    }

    private void removeUnusedValuesets() {
        Set<String> usedValueSets = this.gatherUsedValueSets(this.archetype.getDefinition());
        for (Map.Entry<String, ValueSet> valueSetEntry : this.conversionLog.getCreatedValueSets().entrySet()) {
            if (usedValueSets.contains(valueSetEntry.getKey())) continue;
            this.archetype.getTerminology().getValueSets().remove(valueSetEntry.getKey());
            this.removeTerminologyEntry(valueSetEntry.getKey());
        }
    }

    private void removeUnusedValues() {
        Set<String> usedCodes = this.archetype.getAllUsedCodes();
        for (Map.Entry<String, CreatedCode> valueEntry : this.conversionLog.getCreatedCodes().entrySet()) {
            if (valueEntry.getValue().getReasonForCreation() != ReasonForCodeCreation.CREATED_VALUE_FOR_EXTERNAL_TERM || usedCodes.contains(valueEntry.getValue().getGeneratedCode())) continue;
            this.removeTerminologyEntry(valueEntry.getValue().getGeneratedCode());
        }
    }

    private void removeTerminologyEntry(String code) {
        this.archetype.getTerminology().getTermDefinitions().values().forEach(map -> {
            ArchetypeTerm cfr_ignored_0 = (ArchetypeTerm)map.remove(code);
        });
        if (this.archetype.getTerminology().getTermBindings() != null) {
            ArrayList<String> termCodeBindingsToRemove = new ArrayList<String>();
            for (String terminologyId : this.archetype.getTerminology().getTermBindings().keySet()) {
                Map<String, URI> termBindings = this.archetype.getTerminology().getTermBindings().get(terminologyId);
                termBindings.remove(code);
                if (!termBindings.isEmpty()) continue;
                termCodeBindingsToRemove.add(terminologyId);
            }
            for (String terminologyId : termCodeBindingsToRemove) {
                this.archetype.getTerminology().getTermBindings().remove(terminologyId);
            }
        }
    }

    private Set<String> gatherUsedValueSets(CObject cObject) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (CAttribute attribute : cObject.getAttributes()) {
            result.addAll(this.gatherUsedValueSets(attribute));
        }
        return result;
    }

    private Set<String> gatherUsedValueSets(CAttribute attribute) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (CObject child : attribute.getChildren()) {
            if (child instanceof CTerminologyCode) {
                for (String constraint : ((CTerminologyCode)child).getConstraint()) {
                    if (!constraint.startsWith("ac")) continue;
                    result.add(constraint);
                }
            }
            if (child.getRmTypeName().equalsIgnoreCase("DV_ORDINAL")) {
                CComplexObject complexObject = (CComplexObject)child;
                for (CAttributeTuple tuple : complexObject.getAttributeTuples()) {
                    int symbolIndex = tuple.getMemberIndex("symbol");
                    HashSet<String> atCodes = new HashSet<String>();
                    if (symbolIndex >= 0) {
                        for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
                            CTerminologyCode cTermCode = (CTerminologyCode)primitiveTuple.getMember(symbolIndex);
                            if (cTermCode == null) continue;
                            atCodes.addAll(cTermCode.getConstraint());
                        }
                    }
                    ValueSet set = this.findLocalValueSet(atCodes);
                    result.add(set.getId());
                }
            }
            result.addAll(this.gatherUsedValueSets(child));
        }
        return result;
    }

    private ValueSet findLocalValueSet(Set<String> localCodes) {
        return this.archetype.getTerminology().getValueSets().values().stream().filter(v -> v.getMembers().equals(localCodes)).findFirst().orElse(null);
    }
}

