/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.google.common.collect.Lists;
import com.nedap.archie.adl14.ADL14ConversionUtil;
import com.nedap.archie.adl14.ADL14NodeIDConverter;
import com.nedap.archie.adl14.log.CreatedCode;
import com.nedap.archie.adl14.log.ReasonForCodeCreation;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.terminology.OpenEHRTerminologyAccess;
import com.nedap.archie.terminology.TermCode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADL14TermConstraintConverter {
    private static final Logger logger = LoggerFactory.getLogger(ADL14TermConstraintConverter.class);
    private final Archetype flatParentArchetype;
    private Archetype archetype;
    private ADL14NodeIDConverter converter;

    public ADL14TermConstraintConverter(ADL14NodeIDConverter converter, Archetype archetype, Archetype flatParentArchetype) {
        this.converter = converter;
        this.archetype = archetype;
        this.flatParentArchetype = flatParentArchetype;
    }

    public void convert() {
        this.convert(this.archetype.getDefinition());
    }

    private void convert(CObject cObject) {
        if (cObject instanceof CTerminologyCode) {
            this.convertCTerminologyCode((CTerminologyCode)cObject);
        }
        for (CAttribute attribute : cObject.getAttributes()) {
            this.convert(attribute);
        }
        if (cObject instanceof CComplexObject) {
            for (CAttributeTuple tuple : ((CComplexObject)cObject).getAttributeTuples()) {
                Set<Integer> tupleTermCodeIndices = this.getCTerminologyCodeIndices(tuple);
                for (Integer index : tupleTermCodeIndices) {
                    List termCodes = tuple.getTuples().stream().map(p -> (CPrimitiveObject)p.getMember(index)).collect(Collectors.toList());
                    LinkedHashSet<String> atCodes = new LinkedHashSet<String>();
                    for (CPrimitiveObject cPrimitiveObject : termCodes) {
                        String constraint;
                        CTerminologyCode cTerminologyCode = (CTerminologyCode)cPrimitiveObject;
                        this.convertCTerminologyCode(cTerminologyCode);
                        if (cTerminologyCode.getConstraint().size() != 1 || !AOMUtils.isValueCode(constraint = cTerminologyCode.getConstraint().get(0))) continue;
                        atCodes.add(constraint);
                    }
                    if (atCodes.isEmpty()) continue;
                    this.findOrCreateValueSet(this.archetype, atCodes, cObject);
                }
            }
        }
    }

    private Set<Integer> getCTerminologyCodeIndices(CAttributeTuple tuple) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
            int i = 0;
            for (CPrimitiveObject cPrimitiveObject : primitiveTuple.getMembers()) {
                if (cPrimitiveObject instanceof CTerminologyCode) {
                    result.add(i);
                }
                ++i;
            }
        }
        return result;
    }

    private void convert(CAttribute attribute) {
        for (CObject object : attribute.getChildren()) {
            this.convert(object);
        }
    }

    private void convertCTerminologyCode(CTerminologyCode cTerminologyCode) {
        if (cTerminologyCode.getConstraint() != null && !cTerminologyCode.getConstraint().isEmpty()) {
            Map<String, URI> termBindingsMap;
            TerminologyCode assumedValue;
            boolean isLocalCode;
            String firstConstraint = cTerminologyCode.getConstraint().get(0);
            TerminologyCode termCode = TerminologyCode.createFromString((String)firstConstraint);
            boolean bl = isLocalCode = termCode.getTerminologyId() == null || termCode.getTerminologyId().equalsIgnoreCase("local");
            if (isLocalCode && AOMUtils.isValueCode(firstConstraint)) {
                if (cTerminologyCode.getConstraint().size() == 1) {
                    String newCode = this.converter.convertValueCode(firstConstraint);
                    this.converter.addConvertedCode(firstConstraint, newCode);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{newCode}));
                } else {
                    LinkedHashSet<String> localCodes = new LinkedHashSet<String>();
                    for (String code : cTerminologyCode.getConstraint()) {
                        String newCode = this.converter.convertValueCode(code);
                        this.converter.addConvertedCode(code, newCode);
                        localCodes.add(newCode);
                    }
                    ValueSet valueSet = this.findOrCreateValueSet(cTerminologyCode.getArchetype(), localCodes, cTerminologyCode);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{valueSet.getId()}));
                }
                if (cTerminologyCode.getAssumedValue() != null) {
                    assumedValue = cTerminologyCode.getAssumedValue();
                    String oldCode = assumedValue.getCodeString();
                    String newCode = this.converter.convertValueCode(oldCode);
                    assumedValue.setCodeString(newCode);
                }
            } else if (isLocalCode && AOMUtils.isValueSetCode(termCode.getCodeString())) {
                ArrayList<String> newConstraint = new ArrayList<String>();
                for (String constraint : cTerminologyCode.getConstraint()) {
                    TerminologyCode code = TerminologyCode.createFromString((String)constraint);
                    String newCode = this.converter.convertValueSetCode(code.getCodeString());
                    this.converter.addConvertedCode(termCode.getCodeString(), newCode);
                    newConstraint.add(newCode);
                }
                cTerminologyCode.setConstraint((List<String>)newConstraint);
            } else if (cTerminologyCode.getConstraint().size() == 1) {
                try {
                    URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(termCode);
                    termBindingsMap = this.findOrCreateTermBindings(termCode);
                    String termBinding = this.findOrAddTermBindingAndCode(termCode, uri, termBindingsMap);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{termBinding}));
                }
                catch (URISyntaxException e) {
                    logger.error("error converting term", (Throwable)e);
                }
            } else {
                String terminologyId = cTerminologyCode.getConstraint().get(0);
                termCode = TerminologyCode.createFromString((String)terminologyId, null, (String)cTerminologyCode.getConstraint().get(1));
                termBindingsMap = this.findOrCreateTermBindings(termCode);
                ArrayList<String> atCodes = new ArrayList<String>();
                ArrayList<String> constraints = new ArrayList<String>(cTerminologyCode.getConstraint());
                cTerminologyCode.setConstraint((List<String>)atCodes);
                for (int i = 1; i < constraints.size(); ++i) {
                    String constraint = (String)constraints.get(i);
                    try {
                        URI uri;
                        TerminologyCode constraintCode;
                        if (constraint.startsWith("[") && constraint.endsWith("]")) {
                            constraintCode = TerminologyCode.createFromString((String)constraint);
                            uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(constraintCode);
                            atCodes.add(this.findOrAddTermBindingAndCode(constraintCode, uri, termBindingsMap));
                            continue;
                        }
                        constraintCode = new TerminologyCode();
                        constraintCode.setTerminologyId(terminologyId);
                        constraintCode.setCodeString(constraint);
                        uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(constraintCode);
                        atCodes.add(this.findOrAddTermBindingAndCode(constraintCode, uri, termBindingsMap));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                ValueSet valueSet = this.findOrCreateValueSet(cTerminologyCode.getArchetype(), new LinkedHashSet<String>(atCodes), cTerminologyCode);
                cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{valueSet.getId()}));
            }
            if (cTerminologyCode.getAssumedValue() != null) {
                assumedValue = cTerminologyCode.getAssumedValue();
                if (isLocalCode) {
                    String newCode = this.converter.convertValueCode(assumedValue.getCodeString());
                    assumedValue.setCodeString(newCode);
                    assumedValue.setTerminologyId(null);
                } else {
                    try {
                        termBindingsMap = this.findOrCreateTermBindings(assumedValue);
                        URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(assumedValue);
                        assumedValue.setCodeString(this.findOrAddTermBindingAndCode(assumedValue, uri, termBindingsMap));
                        assumedValue.setTerminologyId(null);
                        assumedValue.setTerminologyVersion(null);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Map<String, URI> findOrCreateTermBindings(TerminologyCode termCode) {
        Map<String, URI> termBindings = this.archetype.getTerminology().getTermBindings().get(termCode.getTerminologyId());
        if (termBindings == null) {
            termBindings = new LinkedHashMap<String, URI>();
            this.archetype.getTerminology().getTermBindings().put(termCode.getTerminologyId(), termBindings);
        }
        return termBindings;
    }

    private String findOrAddTermBindingAndCode(TerminologyCode termCode, URI uri, Map<String, URI> termBindingsMap) {
        String existingTermBinding = ADL14ConversionUtil.findExistingTermBinding(termCode.getTerminologyId(), this.archetype, this.flatParentArchetype, uri, termBindingsMap);
        if (existingTermBinding != null) {
            return existingTermBinding;
        }
        String valueCode = this.converter.getIdCodeGenerator().generateNextValueCode();
        termBindingsMap.put(valueCode, uri);
        CreatedCode createdCode = new CreatedCode(valueCode, ReasonForCodeCreation.CREATED_VALUE_FOR_EXTERNAL_TERM);
        createdCode.setOriginalTerm(termCode);
        this.converter.addCreatedCode(termCode.toString(), createdCode);
        ADL14TermConstraintConverter.addTermBindingCode(this.archetype, termCode.toString(), uri, valueCode);
        return valueCode;
    }

    protected static void addTermBindingCode(Archetype archetype, String termCode, URI uri, String valueCode) {
        for (String language : archetype.getTerminology().getTermDefinitions().keySet()) {
            TermCode termFromTerminology = OpenEHRTerminologyAccess.getInstance().getTermByTerminologyURI(uri.toString(), language);
            TermCode fallbackCode = OpenEHRTerminologyAccess.getInstance().getTermByTerminologyURI(uri.toString(), "en");
            ArchetypeTerm term = new ArchetypeTerm();
            term.setCode(valueCode);
            if (termFromTerminology != null) {
                term.setText(termFromTerminology.getDescription());
            } else if (fallbackCode != null) {
                term.setText("* " + fallbackCode.getDescription() + " (en)");
            } else {
                term.setText("Term binding for " + termCode + ", translation not known in ADL 1.4 -> ADL 2 converter");
            }
            term.setDescription(term.getText());
            archetype.getTerminology().getTermDefinitions().get(language).put(valueCode, term);
        }
    }

    private ValueSet findOrCreateValueSet(Archetype archetype, Set<String> localCodes, CObject owningConstraint) {
        ValueSet valueSet;
        String idInparent = null;
        if (this.flatParentArchetype != null) {
            CTerminologyCode termCodeInParent;
            CObject cObject;
            CAttribute cAttributeInParent;
            String parentPath;
            Object inParent;
            valueSet = this.findValueSet(this.flatParentArchetype, localCodes);
            if (valueSet != null) {
                return valueSet;
            }
            if (this.flatParentArchetype != null && (inParent = this.flatParentArchetype.itemAtPath(parentPath = AOMUtils.pathAtSpecializationLevel(owningConstraint.getPathSegments(), archetype.specializationDepth() - 1))) instanceof CAttribute && !(cAttributeInParent = (CAttribute)inParent).getChildren().isEmpty() && (cObject = cAttributeInParent.getChildren().get(0)) instanceof CTerminologyCode && (termCodeInParent = (CTerminologyCode)cObject).getConstraint() != null && !termCodeInParent.getConstraint().isEmpty() && termCodeInParent.getConstraint().get(0).startsWith("ac")) {
                idInparent = termCodeInParent.getConstraint().get(0);
            }
        }
        if ((valueSet = this.findValueSet(archetype, localCodes)) != null) {
            this.addTermForValueSet(archetype, owningConstraint, valueSet);
            return valueSet;
        }
        valueSet = new ValueSet();
        valueSet.setMembers(localCodes);
        if (idInparent == null) {
            valueSet.setId(this.converter.getIdCodeGenerator().generateNextValueSetCode());
        } else {
            valueSet.setId(this.converter.getIdCodeGenerator().generateNextSpecializedIdCode(idInparent));
        }
        this.converter.addCreatedCode(valueSet.getId(), new CreatedCode(valueSet.getId(), ReasonForCodeCreation.CREATED_VALUE_SET));
        this.converter.addCreatedValueSet(valueSet.getId(), valueSet);
        archetype.getTerminology().getValueSets().put(valueSet.getId(), valueSet);
        this.addTermForValueSet(archetype, owningConstraint, valueSet);
        return valueSet;
    }

    private void addTermForValueSet(Archetype archetype, CObject owningConstraint, ValueSet valueSet) {
        for (String language : archetype.getTerminology().getTermDefinitions().keySet()) {
            ArchetypeTerm term = this.getTerm(language, owningConstraint);
            if (term == null || archetype.getTerminology().getTermDefinitions().get(language).get(valueSet.getId()) != null) continue;
            ArchetypeTerm newTerm = new ArchetypeTerm();
            newTerm.setCode(valueSet.getId());
            newTerm.setText(term.getText() + " (synthesised)");
            newTerm.setDescription(term.getDescription() + " (synthesised)");
            archetype.getTerminology().getTermDefinitions().get(language).put(newTerm.getCode(), newTerm);
        }
    }

    private ValueSet findValueSet(Archetype archetype, Set<String> localCodes) {
        for (ValueSet valueSet : archetype.getTerminology().getValueSets().values()) {
            if (!valueSet.getMembers().equals(localCodes)) continue;
            return valueSet;
        }
        return null;
    }

    protected ArchetypeTerm getTerm(String language, CObject owningConstraint) {
        CObject cObject = owningConstraint;
        while (cObject != null) {
            ArchetypeTerm term;
            String oldCode;
            if (cObject.getNodeId() != null && (oldCode = this.converter.getOldCodeForNewCode(cObject.getNodeId())) != null && this.archetype.getTerminology().getTermDefinition(language, oldCode) != null && (term = this.archetype.getTerminology().getTermDefinition(language, oldCode)) != null) {
                return term;
            }
            cObject = cObject.getParent() == null ? null : cObject.getParent().getParent();
        }
        return null;
    }
}

