/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adl14.treewalkers.ADL14Listener;
import com.nedap.archie.adlparser.antlr.Adl14Lexer;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.modelconstraints.BMMConstraintImposer;
import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.antlr.errors.ArchieErrorListener;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.utils.ArchetypeParsePostProcesser;
import com.nedap.archie.rminfo.MetaModels;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.io.input.BOMInputStream;

public class ADL14Parser {
    private final MetaModels metaModels;
    private ANTLRParserErrors errors;
    private Lexer lexer;
    private Adl14Parser parser;
    private ADL14Listener listener;
    private ParseTreeWalker walker;
    private Adl14Parser.AdlContext tree;
    public ArchieErrorListener errorListener;
    private boolean logEnabled = true;

    public ADL14Parser(MetaModels models) {
        this.metaModels = models;
    }

    public Archetype parse(String adl, ADL14ConversionConfiguration conversionConfiguration) {
        return this.parse((CharStream)CharStreams.fromString((String)adl), conversionConfiguration);
    }

    public Archetype parse(InputStream stream, ADL14ConversionConfiguration conversionConfiguration) throws IOException {
        return this.parse(CharStreams.fromStream((InputStream)new BOMInputStream(stream), (Charset)((Charset)Charset.availableCharsets().get("UTF-8"))), conversionConfiguration);
    }

    public Archetype parse(CharStream stream, ADL14ConversionConfiguration conversionConfiguration) {
        this.errors = new ANTLRParserErrors();
        this.errorListener = new ArchieErrorListener(this.errors);
        this.errorListener.setLogEnabled(this.logEnabled);
        this.lexer = new Adl14Lexer(stream);
        this.lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
        this.parser = new Adl14Parser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        this.parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        this.tree = this.parser.adl();
        ADL14Listener listener = new ADL14Listener(this.errors, conversionConfiguration);
        this.walker = new ParseTreeWalker();
        this.walker.walk((ParseTreeListener)listener, (ParseTree)this.tree);
        Archetype result = listener.getArchetype();
        ArchetypeParsePostProcesser.fixArchetype(result);
        if (this.metaModels != null) {
            this.metaModels.selectModel(result);
            if (this.metaModels.getSelectedBmmModel() != null) {
                BMMConstraintImposer imposer = new BMMConstraintImposer(this.metaModels.getSelectedBmmModel());
                imposer.setSingleOrMultiple(result.getDefinition());
            } else if (this.metaModels.getSelectedModelInfoLookup() != null) {
                ReflectionConstraintImposer imposer = new ReflectionConstraintImposer(this.metaModels.getSelectedModelInfoLookup());
                imposer.setSingleOrMultiple(result.getDefinition());
            }
        }
        return result;
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public Adl14Parser getParser() {
        return this.parser;
    }

    public void setParser(Adl14Parser parser) {
        this.parser = parser;
    }

    public ADL14Listener getListener() {
        return this.listener;
    }

    public void setListener(ADL14Listener listener) {
        this.listener = listener;
    }

    public ParseTreeWalker getWalker() {
        return this.walker;
    }

    public void setWalker(ParseTreeWalker walker) {
        this.walker = walker;
    }

    public Adl14Parser.AdlContext getTree() {
        return this.tree;
    }

    public void setTree(Adl14Parser.AdlContext tree) {
        this.tree = tree;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }
}

