/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.AuthoredResource;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.serializer.adl.ADLAuthoredArchetypeSerializer;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.ADLOperationalTemplateSerializer;
import com.nedap.archie.serializer.adl.ADLRulesSerializer;
import com.nedap.archie.serializer.adl.ADLStringBuilder;
import com.nedap.archie.serializer.adl.ADLTemplateOverlaySerializer;
import com.nedap.archie.serializer.adl.ADLTemplateSerializer;

public abstract class ADLArchetypeSerializer<T extends Archetype> {
    protected final T archetype;
    protected final ADLStringBuilder builder = new ADLStringBuilder();
    private final ADLDefinitionSerializer definitionSerializer;
    private final ADLRulesSerializer rulesSerializer;

    protected ADLArchetypeSerializer(T archetype) {
        this.archetype = archetype;
        this.definitionSerializer = new ADLDefinitionSerializer(this.builder);
        this.rulesSerializer = new ADLRulesSerializer(this.builder, this.definitionSerializer);
    }

    public static String serialize(Archetype archetype) {
        if (archetype instanceof Template) {
            return new ADLTemplateSerializer((Template)archetype).serialize();
        }
        if (archetype instanceof OperationalTemplate) {
            return new ADLOperationalTemplateSerializer((OperationalTemplate)archetype).serialize();
        }
        if (archetype instanceof TemplateOverlay) {
            return new ADLTemplateOverlaySerializer((TemplateOverlay)archetype).serialize();
        }
        if (archetype instanceof AuthoredArchetype) {
            return new ADLAuthoredArchetypeSerializer<AuthoredArchetype>((AuthoredArchetype)archetype).serialize();
        }
        throw new AssertionError((Object)("Could not serialize archetype of class " + (archetype == null ? null : archetype.getClass().getName())));
    }

    protected String serialize() {
        this.appendHead();
        this.appendSpecialize();
        this.appendLanguage();
        this.appendDescription();
        this.appendDefinition();
        this.appendRules();
        this.appendTerminology();
        this.appendAnnotations();
        return this.builder.toString();
    }

    protected void appendAnnotations() {
        if (((AuthoredResource)this.archetype).getAnnotations() == null) {
            return;
        }
        this.builder.newline().append("annotations").newIndentedLine().odin(((AuthoredResource)this.archetype).getAnnotations()).unindent();
    }

    protected void appendRules() {
        if (((Archetype)this.archetype).getRules() == null) {
            return;
        }
        if (((Archetype)this.archetype).getRules().getRules().isEmpty()) {
            return;
        }
        this.builder.newline().append("rules").newIndentedLine();
        this.rulesSerializer.appendRules(((Archetype)this.archetype).getRules());
        this.builder.newUnindentedLine();
    }

    protected void appendTerminology() {
        if (((Archetype)this.archetype).getTerminology() == null) {
            return;
        }
        this.builder.newline().append("terminology").newIndentedLine().odin(((Archetype)this.archetype).getTerminology()).unindent();
    }

    protected void appendDefinition() {
        if (((Archetype)this.archetype).getDefinition() == null) {
            return;
        }
        this.builder.newline().append("definition");
        this.definitionSerializer.appendCObject(((Archetype)this.archetype).getDefinition());
        this.builder.tryNewLine();
    }

    protected abstract void appendLanguage();

    protected abstract void appendDescription();

    private void appendSpecialize() {
        if (((Archetype)this.archetype).getParentArchetypeId() == null) {
            return;
        }
        this.builder.newline().append("specialize").newIndentedLine().append(((Archetype)this.archetype).getParentArchetypeId()).newUnindentedLine();
    }

    protected abstract String headTag();

    private void appendHead() {
        this.builder.append(this.headTag());
        this.appendHeaderAttributes();
        this.builder.newIndentedLine().append(((Archetype)this.archetype).getArchetypeId().getFullId()).newUnindentedLine();
    }

    protected abstract void appendHeaderAttributes();

    public ADLStringBuilder getBuilder() {
        return this.builder;
    }

    public T getArchetype() {
        return this.archetype;
    }
}

