/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.profile.AomProfile;
import com.nedap.archie.aom.profile.AomTypeMapping;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModelInterface;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmEnumeration;
import org.openehr.bmm.core.BmmEnumerationInteger;
import org.openehr.bmm.core.BmmEnumerationString;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class MetaModel
implements MetaModelInterface {
    private ModelInfoLookup selectedModel;
    private BmmModel selectedBmmModel;
    private AomProfile selectedAomProfile;

    public MetaModel(ModelInfoLookup selectedModel, BmmModel selectedBmmModel) {
        this(selectedModel, selectedBmmModel, null);
    }

    public MetaModel(ModelInfoLookup selectedModel, BmmModel selectedBmmModel, AomProfile selectedAomProfile) {
        this.selectedModel = selectedModel;
        this.selectedBmmModel = selectedBmmModel;
        this.selectedAomProfile = selectedAomProfile;
    }

    public ModelInfoLookup getSelectedModel() {
        return this.selectedModel;
    }

    public BmmModel getSelectedBmmModel() {
        return this.selectedBmmModel;
    }

    public AomProfile getSelectedAomProfile() {
        return this.selectedAomProfile;
    }

    @Override
    public boolean isMultiple(String typeName, String attributeNameOrPath) {
        MultiplicityInterval multiplicityInterval = this.referenceModelPropMultiplicity(typeName, attributeNameOrPath);
        if (multiplicityInterval == null) {
            return false;
        }
        return multiplicityInterval.isUpperUnbounded() || (Integer)multiplicityInterval.getUpper() > 1;
    }

    private boolean isMultiple(BmmProperty bmmProperty) {
        if (bmmProperty == null) {
            return false;
        }
        if (bmmProperty instanceof BmmContainerProperty) {
            return bmmProperty != null && ((BmmContainerProperty)bmmProperty).getCardinality().has((Object)2);
        }
        return false;
    }

    @Override
    public boolean rmTypesConformant(String childTypeName, String parentTypeName) {
        if (this.getSelectedBmmModel() != null) {
            BmmModel selectedBmmModel = this.getSelectedBmmModel();
            String parentClassName = BmmDefinitions.typeNameToClassKey((String)parentTypeName);
            String childClassName = BmmDefinitions.typeNameToClassKey((String)childTypeName);
            BmmClass childClass = selectedBmmModel.getClassDefinition(childClassName);
            if (childClass == null) {
                return true;
            }
            List allAncestors = childClass.findAllAncestors();
            allAncestors = allAncestors.stream().map(s -> s.toUpperCase()).collect(Collectors.toList());
            return parentClassName.equalsIgnoreCase(childClassName) || allAncestors.contains(parentClassName);
        }
        return this.selectedModel.rmTypesConformant(childTypeName, parentTypeName);
    }

    @Override
    public boolean typeNameExists(String typeName) {
        if (this.getSelectedBmmModel() != null) {
            return this.selectedBmmModel.getClassDefinition(BmmDefinitions.typeNameToClassKey((String)typeName)) != null;
        }
        return this.selectedModel.getTypeInfo(typeName) != null;
    }

    @Override
    public boolean attributeExists(String rmTypeName, String propertyName) {
        if (this.selectedBmmModel != null) {
            String className = BmmDefinitions.typeNameToClassKey((String)rmTypeName);
            BmmClass classDefinition = this.selectedBmmModel.getClassDefinition(className);
            if (classDefinition == null) {
                return false;
            }
            return classDefinition.flattenBmmClass().hasPropertyWithName(propertyName);
        }
        return this.selectedModel.getAttributeInfo(rmTypeName, propertyName) != null;
    }

    @Override
    public boolean isNullable(String typeId, String attributeName) {
        if (this.selectedBmmModel != null) {
            String className = BmmDefinitions.typeNameToClassKey((String)typeId);
            BmmClass classDefinition = this.selectedBmmModel.getClassDefinition(className);
            if (classDefinition == null) {
                return false;
            }
            if (!classDefinition.hasPropertyWithName(attributeName).booleanValue()) {
                return false;
            }
            BmmClass bmmClass = classDefinition.flattenBmmClass();
            BmmProperty bmmProperty = (BmmProperty)bmmClass.getProperties().get(attributeName);
            return bmmProperty.getMandatory() == false || bmmProperty.getExistence() != null && !bmmProperty.getExistence().isMandatory();
        }
        return this.selectedModel.getAttributeInfo(typeId, attributeName).isNullable();
    }

    @Override
    public boolean typeConformant(String rmTypeName, String rmAttributeName, String childConstraintTypeName) {
        Class typeInCollection;
        if (this.getSelectedBmmModel() != null) {
            BmmClass flatParentClass;
            BmmProperty property;
            String propertyType = this.selectedBmmModel.effectivePropertyType(rmTypeName, rmAttributeName);
            BmmClass parentClass = this.selectedBmmModel.getClassDefinition(BmmDefinitions.typeNameToClassKey((String)rmTypeName));
            BmmClass childClass = this.selectedBmmModel.getClassDefinition(BmmDefinitions.typeNameToClassKey((String)childConstraintTypeName));
            if (childClass != null && parentClass != null && (property = (BmmProperty)(flatParentClass = parentClass.flattenBmmClass()).getProperties().get(rmAttributeName)) != null) {
                String propertyConfTypeName = property.getType().getBaseClass().getTypeName();
                return this.rmTypesConformant(childConstraintTypeName, propertyConfTypeName);
            }
            return false;
        }
        RMTypeInfo typeInfo = this.selectedModel.getTypeInfo(childConstraintTypeName);
        RMAttributeInfo owningAttributeInfo = this.selectedModel.getAttributeInfo(rmTypeName, rmAttributeName);
        return owningAttributeInfo == null || (typeInCollection = owningAttributeInfo.getTypeInCollection()).isAssignableFrom(typeInfo.getJavaClass());
    }

    @Override
    public boolean hasReferenceModelPath(String rmTypeName, String path) {
        if (!path.startsWith("/")) {
            return false;
        }
        if (this.selectedBmmModel != null) {
            return AOMUtils.getPropertyAtPath(this.selectedBmmModel, rmTypeName, path) != null;
        }
        return AOMUtils.getAttributeInfoAtPath(this.selectedModel, rmTypeName, path) != null;
    }

    @Override
    public MultiplicityInterval referenceModelPropMultiplicity(String rmTypeName, String rmAttributeNameOrPath) {
        if (this.selectedBmmModel != null) {
            BmmProperty bmmProperty = AOMUtils.getPropertyAtPath(this.selectedBmmModel, rmTypeName, rmAttributeNameOrPath);
            if (bmmProperty == null) {
                return null;
            }
            if (this.isMultiple(bmmProperty)) {
                return MultiplicityInterval.createUpperUnbounded((Integer)0);
            }
            if (!bmmProperty.getMandatory().booleanValue()) {
                return MultiplicityInterval.createBounded((int)0, (int)1);
            }
            return MultiplicityInterval.createBounded((int)1, (int)1);
        }
        RMAttributeInfo attributeInfo = AOMUtils.getAttributeInfoAtPath(this.selectedModel, rmTypeName, rmAttributeNameOrPath);
        if (attributeInfo == null) {
            return null;
        }
        if (attributeInfo.isMultipleValued()) {
            return MultiplicityInterval.createUpperUnbounded((Integer)0);
        }
        if (attributeInfo.isNullable()) {
            return MultiplicityInterval.createBounded((int)0, (int)1);
        }
        return MultiplicityInterval.createBounded((int)1, (int)1);
    }

    @Override
    public boolean validatePrimitiveType(String rmTypeName, String rmAttributeName, CPrimitiveObject cObject) {
        BmmClass propertyClass;
        BmmProperty bmmProperty;
        if (this.selectedAomProfile == null && this.selectedModel == null) {
            throw new IllegalStateException("no AOM profile and no selected ModelInfoLookup, cannot validate primitive type");
        }
        if (this.selectedAomProfile == null) {
            return this.selectedModel.validatePrimitiveType(rmTypeName, rmAttributeName, cObject);
        }
        String cRmTypeName = cObject.getRmTypeName();
        AomTypeMapping aomTypeMapping = this.selectedAomProfile.getAomRmTypeMappings().get(cRmTypeName.toUpperCase());
        if (aomTypeMapping != null) {
            cRmTypeName = aomTypeMapping.getTargetClassName();
        }
        String modelTypeName = this.selectedBmmModel.effectivePropertyType(rmTypeName, rmAttributeName);
        BmmClass bmmClass = this.selectedBmmModel.getClassDefinition(BmmDefinitions.typeNameToClassKey((String)rmTypeName));
        if (bmmClass != null && (bmmProperty = (BmmProperty)bmmClass.flattenBmmClass().getProperties().get(rmAttributeName)) != null && (propertyClass = bmmProperty.getType().getBaseClass()) instanceof BmmEnumeration) {
            modelTypeName = ((BmmEnumeration)propertyClass).getUnderlyingTypeName();
            if (!modelTypeName.equalsIgnoreCase(cRmTypeName)) {
                return false;
            }
            if (cObject instanceof CString && propertyClass instanceof BmmEnumerationString) {
                BmmEnumerationString enumerationString = (BmmEnumerationString)propertyClass;
                CString cString = (CString)cObject;
                if (!cString.getConstraint().stream().allMatch(item -> enumerationString.getItemValues().contains(item))) {
                    return false;
                }
            } else if (cObject instanceof CInteger && propertyClass instanceof BmmEnumerationInteger) {
                BmmEnumerationInteger enumerationInteger = (BmmEnumerationInteger)propertyClass;
                CInteger cInteger = (CInteger)cObject;
                if (!cInteger.getConstraintValues().stream().allMatch(item -> enumerationInteger.getItemValues().contains(item.intValue()))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (modelTypeName.equalsIgnoreCase(cRmTypeName)) {
            return true;
        }
        String equivalentType = this.selectedAomProfile.getRmPrimitiveTypeEquivalences().get(modelTypeName);
        if (equivalentType != null && equivalentType.equalsIgnoreCase(cRmTypeName)) {
            return true;
        }
        String substitutedType = this.selectedAomProfile.getAomRmTypeSubstitutions().get(cRmTypeName.toUpperCase());
        return substitutedType != null && substitutedType.equalsIgnoreCase(modelTypeName);
    }

    @Override
    public boolean isOrdered(String typeName, String attributeName) {
        if (this.getSelectedBmmModel() != null) {
            BmmClass classDefinition = this.getSelectedBmmModel().getClassDefinition(BmmDefinitions.typeNameToClassKey((String)typeName));
            if (classDefinition != null) {
                BmmClass flatClassDefinition = classDefinition.flattenBmmClass();
                BmmProperty bmmProperty = (BmmProperty)flatClassDefinition.getProperties().get(attributeName);
                return this.isOrdered(bmmProperty);
            }
        } else {
            RMAttributeInfo attributeInfo = this.selectedModel.getAttributeInfo(typeName, attributeName);
            return attributeInfo != null && List.class.isAssignableFrom(attributeInfo.getType());
        }
        return true;
    }

    private boolean isOrdered(BmmProperty bmmProperty) {
        if (bmmProperty == null) {
            return false;
        }
        if (bmmProperty instanceof BmmContainerProperty) {
            String baseType = BmmDefinitions.typeNameToClassKey((String)((BmmContainerType)((BmmContainerProperty)bmmProperty).getType()).getContainerType().toString());
            return baseType.equalsIgnoreCase("list") || baseType.equalsIgnoreCase("array");
        }
        return false;
    }
}

