/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.ArchieLanguageConfiguration;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.TerminologyCodeWithArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.terminology.TerminologyCode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="C_TERMINOLOGY_CODE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CTerminologyCode
extends CPrimitiveObject<String, TerminologyCode> {
    @XmlElement(name="assumed_value")
    private TerminologyCode assumedValue;
    private List<String> constraint = new ArrayList<String>();

    @Override
    public TerminologyCode getAssumedValue() {
        return this.assumedValue;
    }

    @Override
    public void setAssumedValue(TerminologyCode assumedValue) {
        this.assumedValue = assumedValue;
    }

    @Override
    public List<String> getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(List<String> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addConstraint(String constraint) {
        this.constraint.add(constraint);
    }

    @Override
    public boolean isValidValue(TerminologyCode value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        for (String constraint : this.getConstraint()) {
            if (!(constraint.startsWith("at") ? value.getCodeString() != null && value.getCodeString().equals(constraint) : constraint.startsWith("ac") && value.getTerminologyId() != null && value.getTerminologyId().equals(constraint))) continue;
            return true;
        }
        return false;
    }

    public List<TerminologyCodeWithArchetypeTerm> getTerms() {
        ArrayList<TerminologyCodeWithArchetypeTerm> result = new ArrayList<TerminologyCodeWithArchetypeTerm>();
        Archetype archetype = this.getArchetype();
        if (archetype == null) {
            return result;
        }
        ArchetypeTerminology terminology = archetype.getTerminology(this);
        String language = ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage();
        String defaultLanguage = ArchieLanguageConfiguration.getDefaultMeaningAndDescriptionLanguage();
        for (String constraint : this.getConstraint()) {
            ValueSet acValueSet;
            if (constraint.startsWith("at")) {
                ArchetypeTerm termDefinition = terminology.getTermDefinition(language, constraint);
                if (termDefinition == null) {
                    termDefinition = terminology.getTermDefinition(defaultLanguage, constraint);
                }
                if (termDefinition == null) continue;
                result.add(new TerminologyCodeWithArchetypeTerm(constraint, termDefinition));
                continue;
            }
            if (!constraint.startsWith("ac") || (acValueSet = terminology.getValueSets().get(constraint)) == null) continue;
            for (String atCode : acValueSet.getMembers()) {
                ArchetypeTerm termDefinition = terminology.getTermDefinition(language, atCode);
                if (termDefinition == null) {
                    termDefinition = terminology.getTermDefinition(defaultLanguage, atCode);
                }
                if (termDefinition == null) continue;
                result.add(new TerminologyCodeWithArchetypeTerm(atCode, termDefinition));
            }
        }
        return result;
    }

    private void setTerms(List<TerminologyCodeWithArchetypeTerm> terms) {
    }

    @JsonIgnore
    public List<String> getValueSetExpanded() {
        ArrayList<String> result = new ArrayList<String>();
        Archetype archetype = this.getArchetype();
        if (archetype == null) {
            return result;
        }
        ArchetypeTerminology terminology = archetype.getTerminology(this);
        for (String constraint : this.getConstraint()) {
            ValueSet acValueSet;
            if (constraint.startsWith("at")) {
                result.add(constraint);
                continue;
            }
            if (!constraint.startsWith("ac") || (acValueSet = terminology.getValueSets().get(constraint)) == null) continue;
            result.addAll(acValueSet.getMembers());
        }
        return result;
    }

    @Override
    public boolean cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (!super.cConformsTo(other, rmTypesConformant)) {
            return false;
        }
        CTerminologyCode otherCode = (CTerminologyCode)other;
        List<String> valueSet = this.getValueSetExpanded();
        List<String> otherValueSet = otherCode.getValueSetExpanded();
        if (this.constraint.size() != 1 || otherCode.constraint.size() != 1) {
            return false;
        }
        String thisConstraint = this.constraint.get(0);
        String otherConstraint = otherCode.constraint.get(0);
        if (AOMUtils.isValidValueSetCode(thisConstraint) && AOMUtils.isValidValueSetCode(otherConstraint)) {
            if (otherValueSet.isEmpty()) {
                return true;
            }
            if (!AOMUtils.codesConformant(thisConstraint, otherConstraint)) {
                return false;
            }
            for (String value : valueSet) {
                if (otherValueSet.contains(value)) continue;
                return false;
            }
            return true;
        }
        return AOMUtils.codesConformant(thisConstraint, otherConstraint);
    }
}

