/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.CSecondOrder;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="C_ATTRIBUTE_TUPLE", propOrder={"tuples"})
public class CAttributeTuple
extends CSecondOrder<CAttribute> {
    private List<CPrimitiveTuple> tuples = new ArrayList<CPrimitiveTuple>();

    public List<CPrimitiveTuple> getTuples() {
        return this.tuples;
    }

    public void setTuples(List<CPrimitiveTuple> tuples) {
        this.tuples = tuples;
    }

    public void addTuple(CPrimitiveTuple tuple) {
        this.tuples.add(tuple);
    }

    public boolean isValid(ModelInfoLookup lookup, HashMap<String, Object> values) {
        for (CAttribute attribute : this.getMembers()) {
            if (values.containsKey(attribute.getRmAttributeName())) continue;
            return false;
        }
        for (CPrimitiveTuple tuple : this.tuples) {
            if (!this.isValid(lookup, tuple, values)) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(ModelInfoLookup lookup, CPrimitiveTuple tuple, HashMap<String, Object> values) {
        int index = 0;
        for (CAttribute attribute : this.getMembers()) {
            String attributeName = attribute.getRmAttributeName();
            CPrimitiveObject cPrimitiveObject = (CPrimitiveObject)tuple.getMembers().get(index);
            Object value = values.get(attributeName);
            if (value == null) {
                return false;
            }
            if (!cPrimitiveObject.isValidValue(lookup, value)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean isValid(ModelInfoLookup lookup, Object value) {
        HashMap<String, Object> members = new HashMap<String, Object>();
        for (CAttribute attribute : this.getMembers()) {
            RMAttributeInfo attributeInfo = lookup.getAttributeInfo(value.getClass(), attribute.getRmAttributeName());
            try {
                if (attributeInfo == null || attributeInfo.getGetMethod() == null) continue;
                members.put(attribute.getRmAttributeName(), attributeInfo.getGetMethod().invoke(value, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.isValid(lookup, members);
    }

    public CAttribute getMember(String attributeName) {
        for (CAttribute member : this.getMembers()) {
            if (!member.getRmAttributeName().equals(attributeName)) continue;
            return member;
        }
        return null;
    }

    public int getMemberIndex(String attributeName) {
        int i = 0;
        for (CAttribute member : this.getMembers()) {
            if (member.getRmAttributeName().equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        boolean first = true;
        for (CAttribute member : this.getMembers()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(member.getRmAttributeName());
        }
        result.append("] \u2208 {\n");
        first = true;
        for (CPrimitiveTuple tuple : this.tuples) {
            if (!first) {
                result.append(",\n");
            }
            first = false;
            result.append("\t");
            result.append(tuple.toString());
        }
        result.append("\n}");
        return result.toString();
    }

    public List<String> getMemberNames() {
        return this.getMembers().stream().map(attr -> attr.getRmAttributeName()).collect(Collectors.toList());
    }

    public boolean cConformsTo(CAttributeTuple otherTuple, BiFunction<String, String, Boolean> rmTypesConformant) {
        return this.allTuplesConform(otherTuple, rmTypesConformant) || this.isSubset(otherTuple);
    }

    private boolean isSubset(CAttributeTuple otherTuple) {
        return this.getTuples().size() < otherTuple.getTuples().size() && this.getTuples().stream().allMatch(primitiveTuple -> otherTuple.getTuples().stream().anyMatch(otherPrimitiveTuple -> otherPrimitiveTuple.cCongruentTo((CPrimitiveTuple)primitiveTuple)));
    }

    private boolean allTuplesConform(CAttributeTuple otherTuple, BiFunction<String, String, Boolean> rmTypesConformant) {
        return this.getTuples().stream().allMatch(primitiveTuple -> otherTuple.getTuples().stream().anyMatch(otherPrimitiveTuple -> otherPrimitiveTuple.cConformsTo((CPrimitiveTuple)primitiveTuple, rmTypesConformant)));
    }
}

