/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nedap.archie.adlparser.antlr.AdlBaseListener;
import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.treewalkers.CComplexObjectParser;
import com.nedap.archie.adlparser.treewalkers.ComponentTerminologiesHelper;
import com.nedap.archie.adlparser.treewalkers.TerminologyParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.LanguageSection;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.ResourceAnnotations;
import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.serializer.odin.AdlOdinToJsonConverter;
import com.nedap.archie.serializer.odin.OdinObjectParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ADLListener
extends AdlBaseListener {
    private ANTLRParserErrors errors;
    private Archetype rootArchetype;
    private Archetype archetype;
    private CComplexObjectParser subTreeWalker;
    private TerminologyParser terminologyParser;

    public ADLListener(ANTLRParserErrors errors, MetaModels metaModels) {
        this.errors = errors;
        this.subTreeWalker = new CComplexObjectParser(errors, metaModels);
        this.terminologyParser = new TerminologyParser(errors);
    }

    public void enterArchetype(AdlParser.ArchetypeContext ctx) {
        this.archetype = this.rootArchetype = new AuthoredArchetype();
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void exitArchetype(AdlParser.ArchetypeContext ctx) {
        this.rootArchetype.setDifferential(true);
    }

    public void enterTemplate(AdlParser.TemplateContext ctx) {
        this.archetype = this.rootArchetype = new Template();
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void exitTemplate(AdlParser.TemplateContext ctx) {
        this.rootArchetype.setDifferential(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enterTemplate_overlay(AdlParser.Template_overlayContext ctx) {
        TemplateOverlay overlay = new TemplateOverlay();
        overlay.setDifferential(true);
        if (this.rootArchetype != null) {
            if (!(this.rootArchetype instanceof Template)) throw new IllegalArgumentException("Template overlay in a non-template archetype is not allowed. This sounds like a grammar problem.");
            Template owningTemplate = (Template)this.rootArchetype;
            owningTemplate.addTemplateOverlay(overlay);
            overlay.setOwningTemplate(owningTemplate);
        } else {
            this.rootArchetype = overlay;
        }
        this.archetype = overlay;
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void enterOperational_template(AdlParser.Operational_templateContext ctx) {
        this.rootArchetype = new OperationalTemplate();
        this.rootArchetype.setDifferential(false);
        this.archetype = this.rootArchetype;
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    private void parseArchetypeHRID(TerminalNode hrId) {
        if (hrId != null) {
            ArchetypeHRID archetypeID = new ArchetypeHRID(hrId.getText());
            this.archetype.setArchetypeId(archetypeID);
        }
    }

    public void enterMeta_data_item(AdlParser.Meta_data_itemContext ctx) {
        if (this.archetype instanceof AuthoredArchetype) {
            AuthoredArchetype authoredArchetype = (AuthoredArchetype)this.archetype;
            if (ctx.meta_data_tag_adl_version() != null) {
                authoredArchetype.setAdlVersion(ctx.VERSION_ID().getText());
            }
            if (ctx.meta_data_tag_build_uid() != null) {
                authoredArchetype.setBuildUid(ctx.GUID().getText());
            }
            if (ctx.meta_data_tag_rm_release() != null) {
                authoredArchetype.setRmRelease(ctx.VERSION_ID().getText());
            }
            if (ctx.meta_data_tag_is_controlled() != null) {
                authoredArchetype.setControlled(true);
            }
            if (ctx.meta_data_tag_is_generated() != null) {
                authoredArchetype.setGenerated(true);
            }
            if (ctx.meta_data_tag_uid() != null) {
                authoredArchetype.setUid(ctx.GUID().getText());
            } else if (ctx.identifier() != null) {
                authoredArchetype.addOtherMetadata(ctx.identifier().getText(), ctx.meta_data_value() == null ? null : ctx.meta_data_value().getText());
            }
        }
    }

    public void enterDefinition_section(AdlParser.Definition_sectionContext ctx) {
        CComplexObject definition = this.subTreeWalker.parseComplexObject(ctx.c_complex_object());
        this.archetype.setDefinition(definition);
    }

    public void enterLanguage_section(AdlParser.Language_sectionContext ctx) {
        this.archetype.setAuthoredResourceContent((LanguageSection)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), LanguageSection.class));
    }

    public void enterTerminology_section(AdlParser.Terminology_sectionContext ctx) {
        this.archetype.setTerminology(this.terminologyParser.parseTerminology(ctx));
    }

    public void enterDescription_section(AdlParser.Description_sectionContext ctx) {
        this.archetype.setDescription((ResourceDescription)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ResourceDescription.class));
    }

    public void enterSpecialization_section(AdlParser.Specialization_sectionContext ctx) {
        if (ctx != null && ctx.archetype_ref() != null) {
            this.archetype.setParentArchetypeId(ctx.archetype_ref().getText());
        }
    }

    public void enterRules_section(AdlParser.Rules_sectionContext ctx) {
        this.archetype.setRules(this.subTreeWalker.parseRules(ctx));
    }

    public void enterAnnotations_section(AdlParser.Annotations_sectionContext ctx) {
        this.archetype.setAnnotations((ResourceAnnotations)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ResourceAnnotations.class));
    }

    public void enterComponent_terminologies_section(AdlParser.Component_terminologies_sectionContext ctx) {
        if (!(this.archetype instanceof OperationalTemplate)) {
            throw new IllegalArgumentException("cannot add component terminologies to anything but an operational template");
        }
        if (ctx.odin_text().attr_vals() != null) {
            OperationalTemplate template = (OperationalTemplate)this.archetype;
            ComponentTerminologiesHelper helper = (ComponentTerminologiesHelper)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ComponentTerminologiesHelper.class);
            template.setComponentTerminologies(helper.getComponentTerminologies());
        } else {
            OperationalTemplate template = (OperationalTemplate)this.archetype;
            TypeFactory typeFactory = AdlOdinToJsonConverter.getObjectMapper().getTypeFactory();
            MapType mapType = typeFactory.constructMapType(ConcurrentHashMap.class, String.class, ArchetypeTerminology.class);
            template.setComponentTerminologies((Map)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), (JavaType)mapType));
        }
    }

    public Archetype getArchetype() {
        return this.rootArchetype;
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }
}

