/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.modelconstraints;

import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ModelConstraintImposer {
    public static final Logger logger = LoggerFactory.getLogger(ModelConstraintImposer.class);

    public CAttribute getDefaultAttribute(String var1, String var2);

    default public void setSingleOrMultiple(CComplexObject rootNode) {
        if (rootNode == null) {
            return;
        }
        Stack<CObject> workList = new Stack<CObject>();
        workList.add(rootNode);
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                if (attribute.getDifferentialPath() == null) {
                    CAttribute defaultAttribute = this.getDefaultAttribute(object.getRmTypeName(), attribute.getRmAttributeName());
                    if (defaultAttribute == null) {
                        if (!object.getRmTypeName().equals("DV_QUANTITY") || !attribute.getRmAttributeName().equals("property")) {
                            logger.info("could not find attribute for " + object.getRmTypeName() + "." + attribute.getRmAttributeName());
                        }
                    } else {
                        attribute.setMultiple(defaultAttribute.isMultiple());
                    }
                }
                for (CObject child : attribute.getChildren()) {
                    workList.push(child);
                }
            }
        }
    }

    default public void imposeConstraints(CComplexObject rootNode) {
        if (rootNode == null) {
            return;
        }
        Stack<CObject> workList = new Stack<CObject>();
        workList.add(rootNode);
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                if (attribute.getDifferentialPath() == null) {
                    CAttribute defaultAttribute = this.getDefaultAttribute(object.getRmTypeName(), attribute.getRmAttributeName());
                    if (defaultAttribute == null) {
                        if (!object.getRmTypeName().equals("DV_QUANTITY") || !attribute.getRmAttributeName().equals("property")) {
                            logger.info("could not find attribute for " + object.getRmTypeName() + "." + attribute.getRmAttributeName());
                        }
                    } else {
                        attribute.setMultiple(defaultAttribute.isMultiple());
                        if (attribute.getCardinality() == null) {
                            attribute.setCardinality(defaultAttribute.getCardinality());
                        }
                        if (attribute.getExistence() == null) {
                            attribute.setExistence(defaultAttribute.getExistence());
                        }
                    }
                }
                for (CObject child : attribute.getChildren()) {
                    workList.push(child);
                }
            }
        }
    }
}

