/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.base.Interval;
import java.util.Iterator;

public class Adl14NumberConstraintParser
extends BaseTreeWalker {
    public Adl14NumberConstraintParser(ANTLRParserErrors errors) {
        super(errors);
    }

    public CInteger parseCInteger(Adl14Parser.C_integerContext integerContext) {
        Adl14Parser.Integer_interval_valueContext intervalContext;
        Adl14Parser.Integer_list_valueContext integerListValueContext;
        Adl14Parser.Integer_valueContext integerValueContext;
        CInteger result = new CInteger();
        if (integerContext.assumed_integer_value() != null) {
            result.setAssumedValue(Long.parseLong(integerContext.assumed_integer_value().integer_value().getText()));
        }
        if ((integerValueContext = integerContext.integer_value()) != null) {
            this.parseIntegerConstraint(result, integerValueContext);
        }
        if ((integerListValueContext = integerContext.integer_list_value()) != null) {
            for (Adl14Parser.Integer_valueContext integerValueContext1 : integerListValueContext.integer_value()) {
                this.parseIntegerConstraint(result, integerValueContext1);
            }
        }
        if ((intervalContext = integerContext.integer_interval_value()) != null) {
            result.addConstraint(this.parseIntegerInterval(intervalContext));
        }
        if (integerContext.integer_interval_list_value() != null) {
            for (Adl14Parser.Integer_interval_valueContext intervalListContext : integerContext.integer_interval_list_value().integer_interval_value()) {
                result.addConstraint(this.parseIntegerInterval(intervalListContext));
            }
        }
        if (result.getConstraint().size() == 1) {
            Iterator iterator = result.getConstraint().get(0);
        }
        return result;
    }

    private void parseIntegerConstraint(CInteger cInteger, Adl14Parser.Integer_valueContext integerValueContext) {
        long integer = Long.parseLong(integerValueContext.getText());
        Interval interval = new Interval();
        interval.setLower((Object)integer);
        interval.setUpper((Object)integer);
        cInteger.addConstraint((Interval<Long>)interval);
    }

    private Interval<Long> parseIntegerInterval(Adl14Parser.Integer_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpIntegerInterval(context);
        } else {
            interval = new Interval();
            if (context.integer_value().size() == 1) {
                interval.setLower((Object)Long.parseLong(context.integer_value(0).getText()));
                interval.setUpper(interval.getLower());
            } else {
                interval.setLower((Object)Long.parseLong(context.integer_value(0).getText()));
                interval.setUpper((Object)Long.parseLong(context.integer_value(1).getText()));
            }
            if (context.SYM_GT() != null) {
                interval.setLowerIncluded(false);
            }
            if (context.SYM_LT() != null) {
                interval.setUpperIncluded(false);
            }
        }
        return interval;
    }

    private Interval<Long> parseRelOpIntegerInterval(Adl14Parser.Integer_interval_valueContext intervalContext) {
        Interval interval = new Interval();
        long integer = Long.parseLong(((Adl14Parser.Integer_valueContext)intervalContext.integer_value().get(0)).getText());
        switch (intervalContext.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)integer);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)integer);
            }
        }
        return interval;
    }

    public CReal parseCReal(Adl14Parser.C_realContext realContext) {
        Adl14Parser.Real_interval_valueContext intervalContext;
        Adl14Parser.Real_list_valueContext realListValueContext;
        Adl14Parser.Real_valueContext realValueContext;
        CReal result = new CReal();
        if (realContext.assumed_real_value() != null) {
            result.setAssumedValue(Double.parseDouble(realContext.assumed_real_value().real_value().getText()));
        }
        if ((realValueContext = realContext.real_value()) != null) {
            this.parseRealConstraint(result, realValueContext);
        }
        if ((realListValueContext = realContext.real_list_value()) != null) {
            for (Adl14Parser.Real_valueContext realValueContext1 : realListValueContext.real_value()) {
                this.parseRealConstraint(result, realValueContext1);
            }
        }
        if ((intervalContext = realContext.real_interval_value()) != null) {
            result.addConstraint(this.parseRealInterval(intervalContext));
        }
        if (realContext.real_interval_list_value() != null) {
            for (Adl14Parser.Real_interval_valueContext intervalListContext : realContext.real_interval_list_value().real_interval_value()) {
                result.addConstraint(this.parseRealInterval(intervalListContext));
            }
        }
        if (result.getConstraint().size() == 1) {
            Iterator iterator = result.getConstraint().get(0);
        }
        return result;
    }

    private void parseRealConstraint(CReal cReal, Adl14Parser.Real_valueContext realValueContext) {
        double real = Double.parseDouble(realValueContext.getText());
        Interval interval = new Interval();
        interval.setLower((Object)real);
        interval.setUpper((Object)real);
        cReal.addConstraint((Interval<Double>)interval);
    }

    private Interval<Double> parseRealInterval(Adl14Parser.Real_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpRealInterval(context);
        } else {
            interval = new Interval();
            interval.setLower((Object)Double.parseDouble(context.real_value(0).getText()));
            if (context.real_value().size() > 1) {
                interval.setUpper((Object)Double.parseDouble(context.real_value(1).getText()));
            } else {
                interval.setUpper(interval.getLower());
            }
        }
        if (context.SYM_GT() != null) {
            interval.setLowerIncluded(false);
        }
        if (context.SYM_LT() != null) {
            interval.setUpperIncluded(false);
        }
        return interval;
    }

    private Interval<Double> parseRelOpRealInterval(Adl14Parser.Real_interval_valueContext intervalContext) {
        Interval interval = new Interval();
        double real = Double.parseDouble(((Adl14Parser.Real_valueContext)intervalContext.real_value().get(0)).getText());
        switch (intervalContext.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)real);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)real);
            }
        }
        return interval;
    }
}

