/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adl14.aom14.CDVOrdinal;
import com.nedap.archie.adl14.aom14.CDVOrdinalItem;
import com.nedap.archie.adl14.aom14.CDVQuantity;
import com.nedap.archie.adl14.aom14.CDVQuantityItem;
import com.nedap.archie.adl14.treewalkers.Adl14PrimitivesConstraintParser;
import com.nedap.archie.adl14.treewalkers.Adl14RulesParser;
import com.nedap.archie.adl14.treewalkers.Odin14ValueParser;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.RulesSection;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.rules.Assertion;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Adl14CComplexObjectParser
extends BaseTreeWalker {
    private final Adl14PrimitivesConstraintParser primitivesConstraintParser;
    private Odin14ValueParser odinParser;

    public Adl14CComplexObjectParser(ANTLRParserErrors errors, Odin14ValueParser odinParser) {
        super(errors);
        this.primitivesConstraintParser = new Adl14PrimitivesConstraintParser(errors);
        this.odinParser = odinParser;
    }

    public RulesSection parseRules(Adl14Parser.Rules_sectionContext context) {
        RulesSection result = new RulesSection();
        result.setContent(context.getText());
        Adl14RulesParser rulesParser = new Adl14RulesParser(this.getErrors());
        for (Adl14Parser.AssertionContext assertion : context.assertion_list().assertion()) {
            result.addRule(rulesParser.parse(assertion));
        }
        return result;
    }

    public CComplexObject parseComplexObject(Adl14Parser.C_complex_objectContext context) {
        CComplexObject object = new CComplexObject();
        if (context.type_id() != null) {
            object.setRmTypeName(context.type_id().getText());
        }
        if (context.atTypeId() != null) {
            object.setNodeId(context.atTypeId().AT_CODE().getText());
        }
        if (context.c_occurrences() != null) {
            object.setOccurrences(this.parseMultiplicityInterval(context.c_occurrences()));
        }
        for (Adl14Parser.C_attribute_defContext attribute : context.c_attribute_def()) {
            this.parseCAttribute(object, attribute);
        }
        return object;
    }

    private void parseCAttribute(CComplexObject parent, Adl14Parser.C_attribute_defContext attributeDefContext) {
        if (attributeDefContext.c_attribute() != null) {
            CAttribute attribute = new CAttribute();
            Adl14Parser.C_attributeContext attributeContext = attributeDefContext.c_attribute();
            if (attributeContext.attribute_id() != null) {
                attribute.setRmAttributeName(attributeContext.attribute_id().getText());
            } else {
                attribute.setDifferentialPath(attributeContext.ADL_PATH().getText());
                attribute.setRmAttributeName(Adl14CComplexObjectParser.getLastAttributeFromPath(attribute.getDifferentialPath()));
            }
            if (attributeContext.c_existence() != null) {
                attribute.setExistence(this.parseMultiplicityInterval(attributeContext.c_existence()));
            }
            if (attributeContext.c_cardinality() != null) {
                attribute.setCardinality(this.parseCardinalityInterval(attributeContext.c_cardinality()));
            }
            if (attributeContext.c_objects() != null) {
                attribute.setChildren(this.parseCObjects(attributeContext.c_objects()));
            } else if (attributeContext.CONTAINED_REGEXP() != null) {
                attribute.addChild(this.primitivesConstraintParser.parseRegex(attributeContext.CONTAINED_REGEXP()));
            }
            parent.addAttribute(attribute);
            if (attribute.getCardinality() != null) {
                attribute.setMultiple(true);
            }
        }
    }

    public static String getFirstAttributeOfPath(String path) {
        return path.substring(0, path.indexOf(47));
    }

    public static String getPathMinusFirstAttribute(String path) {
        return path.substring(path.indexOf(47));
    }

    public static String getLastAttributeFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private List<CObject> parseCObjects(Adl14Parser.C_objectsContext objectsContext) {
        ArrayList<CObject> result = new ArrayList<CObject>();
        if (objectsContext.c_primitive_object() != null) {
            result.add(this.primitivesConstraintParser.parsePrimitiveObject(objectsContext.c_primitive_object()));
        } else {
            List nonPrimitiveObjectOrderedContext = objectsContext.c_non_primitive_object_ordered();
            if (nonPrimitiveObjectOrderedContext != null) {
                for (Adl14Parser.C_non_primitive_object_orderedContext object : nonPrimitiveObjectOrderedContext) {
                    CObject cobject = this.parseNonPrimitiveObject(object.c_non_primitive_object());
                    Adl14Parser.Sibling_orderContext siblingOrderContext = object.sibling_order();
                    if (siblingOrderContext != null) {
                        SiblingOrder siblingOrder = new SiblingOrder();
                        if (siblingOrderContext.SYM_AFTER() != null) {
                            siblingOrder.setBefore(false);
                        } else if (siblingOrderContext.SYM_BEFORE() != null) {
                            siblingOrder.setBefore(true);
                        }
                        siblingOrder.setSiblingNodeId(siblingOrderContext.AT_CODE().getText());
                        cobject.setSiblingOrder(siblingOrder);
                    }
                    result.add(cobject);
                }
            }
        }
        return result;
    }

    private CObject parseNonPrimitiveObject(Adl14Parser.C_non_primitive_objectContext objectContext) {
        if (objectContext.c_complex_object() != null) {
            return this.parseComplexObject(objectContext.c_complex_object());
        }
        if (objectContext.c_archetype_root() != null) {
            return this.parseArchetypeRoot(objectContext.c_archetype_root());
        }
        if (objectContext.c_complex_object_proxy() != null) {
            return this.parseCComplexObjectProxy(objectContext.c_complex_object_proxy());
        }
        if (objectContext.archetype_slot() != null) {
            return this.parseArchetypeSlot(objectContext.archetype_slot());
        }
        if (objectContext.domainSpecificExtension() != null) {
            CComplexObject result = new CComplexObject();
            String type = objectContext.domainSpecificExtension().type_id().getText();
            if (type.equalsIgnoreCase("C_DV_QUANTITY")) {
                this.parseCDVQuantity(objectContext, result);
            } else if (type.equalsIgnoreCase("C_DV_ORDINAL")) {
                this.parseCDVOrdinal(objectContext, result);
            } else {
                throw new IllegalArgumentException("unknown domain specific type: " + type);
            }
            return result;
        }
        if (objectContext.c_ordinal() != null) {
            Adl14Parser.C_ordinalContext ordinalContext = objectContext.c_ordinal();
            CComplexObject ordinal = new CComplexObject();
            ordinal.setRmTypeName("DV_ORDINAL");
            CAttributeTuple tuple = new CAttributeTuple();
            ArrayList<CAttribute> members = new ArrayList<CAttribute>();
            members.add(new CAttribute("value"));
            members.add(new CAttribute("symbol"));
            tuple.setMembers(members);
            for (Adl14Parser.Ordinal_termContext ordinal_termContext : ordinalContext.ordinal_term()) {
                long value = Integer.parseInt(ordinal_termContext.integer_value().getText());
                CPrimitiveTuple primitiveTuple = new CPrimitiveTuple();
                CInteger cValue = new CInteger();
                cValue.addConstraint((Interval<Long>)new Interval((Object)value));
                CTerminologyCode cCode = new CTerminologyCode();
                TerminologyCode code = TerminologyCode.createFromString((String)ordinal_termContext.c_terminology_code().getText());
                cCode.addConstraint(code.getCodeString());
                primitiveTuple.addMember(cValue);
                primitiveTuple.addMember(cCode);
                tuple.addTuple(primitiveTuple);
            }
            ordinal.addAttributeTuple(tuple);
            return ordinal;
        }
        throw new IllegalArgumentException("unknown non-primitive object: " + objectContext.getText());
    }

    private void parseCDVOrdinal(Adl14Parser.C_non_primitive_objectContext objectContext, CComplexObject result) {
        CDVOrdinal cdvOrdinal;
        result.setRmTypeName("DV_ORDINAL");
        if (objectContext.domainSpecificExtension().odin_text() != null && (cdvOrdinal = this.odinParser.convert(objectContext.domainSpecificExtension().odin_text().getText(), CDVOrdinal.class)).getList() != null && !cdvOrdinal.getList().isEmpty()) {
            CAttributeTuple tuple = new CAttributeTuple();
            boolean hasValue = cdvOrdinal.getList().values().stream().anyMatch(i -> i.getValue() != null);
            boolean hasSymbol = cdvOrdinal.getList().values().stream().anyMatch(i -> i.getSymbol() != null);
            if (hasValue) {
                tuple.addMember(new CAttribute("value"));
            }
            if (hasSymbol) {
                tuple.addMember(new CAttribute("symbol"));
            }
            for (CDVOrdinalItem item : cdvOrdinal.getList().values()) {
                CPrimitiveTuple primitiveTuple = new CPrimitiveTuple();
                if (item.getValue() != null) {
                    primitiveTuple.addMember(item.getValueAdl2());
                } else if (hasValue) {
                    CInteger integer = new CInteger();
                    integer.addConstraint((Interval<Long>)Interval.upperUnbounded((Object)0L, (boolean)true));
                    primitiveTuple.addMember(integer);
                }
                if (item.getSymbol() != null) {
                    primitiveTuple.addMember(item.getSymbolAdl2());
                } else if (hasSymbol) {
                    CTerminologyCode code = new CTerminologyCode();
                    primitiveTuple.addMember(code);
                }
                tuple.addTuple(primitiveTuple);
            }
            result.addAttributeTuple(tuple);
        }
    }

    private void parseCDVQuantity(Adl14Parser.C_non_primitive_objectContext objectContext, CComplexObject result) {
        result.setRmTypeName("DV_QUANTITY");
        if (objectContext.domainSpecificExtension().odin_text() != null) {
            CDVQuantity cdvQuantity = this.odinParser.convert(objectContext.domainSpecificExtension().odin_text().getText(), CDVQuantity.class);
            if (cdvQuantity.getProperty() != null) {
                CAttribute property = new CAttribute("property");
                CTerminologyCode code = new CTerminologyCode();
                code.addConstraint(cdvQuantity.getProperty().toString());
                property.addChild(code);
                result.addAttribute(property);
            }
            if (cdvQuantity.getList() != null && !cdvQuantity.getList().isEmpty()) {
                if (cdvQuantity.getList().size() == 1) {
                    CDVQuantityItem item = cdvQuantity.getList().values().iterator().next();
                    if (item.getMagnitude() != null) {
                        CAttribute magnitude = new CAttribute("magnitude");
                        CReal magnitudeAdl2 = item.getMagnitudeAdl2();
                        magnitude.addChild(magnitudeAdl2);
                        result.addAttribute(magnitude);
                        if (cdvQuantity.getAssumedValue() != null && cdvQuantity.getAssumedValue().getMagnitude() != null) {
                            Double assumedMagnitude = cdvQuantity.getAssumedValue().getMagnitude();
                            magnitudeAdl2.setAssumedValue(assumedMagnitude);
                        }
                    }
                    if (item.getUnits() != null) {
                        CAttribute units = new CAttribute("units");
                        CString unitsAdl2 = item.getUnitsAdl2();
                        units.addChild(unitsAdl2);
                        result.addAttribute(units);
                        if (cdvQuantity.getAssumedValue() != null && cdvQuantity.getAssumedValue().getUnits() != null) {
                            String assumedUnits = cdvQuantity.getAssumedValue().getUnits();
                            unitsAdl2.setAssumedValue(assumedUnits);
                        }
                    }
                    if (item.getPrecision() != null) {
                        CAttribute precision = new CAttribute("precision");
                        CInteger precisionAdl2 = item.getPrecisionAdl2();
                        precision.addChild(precisionAdl2);
                        result.addAttribute(precision);
                        if (cdvQuantity.getAssumedValue() != null && cdvQuantity.getAssumedValue().getPrecision() != null) {
                            Long assumedPrecision = cdvQuantity.getAssumedValue().getPrecision();
                            precisionAdl2.setAssumedValue(assumedPrecision);
                        }
                    }
                } else {
                    CAttributeTuple tuple = new CAttributeTuple();
                    boolean hasMagnitude = cdvQuantity.getList().values().stream().anyMatch(i -> i.getMagnitude() != null);
                    boolean hasUnits = cdvQuantity.getList().values().stream().anyMatch(i -> i.getUnits() != null);
                    boolean hasPrecision = cdvQuantity.getList().values().stream().anyMatch(i -> i.getPrecision() != null);
                    if (hasMagnitude) {
                        tuple.addMember(new CAttribute("magnitude"));
                    }
                    if (hasUnits) {
                        tuple.addMember(new CAttribute("units"));
                    }
                    if (hasPrecision) {
                        tuple.addMember(new CAttribute("precision"));
                    }
                    for (CDVQuantityItem item : cdvQuantity.getList().values()) {
                        CPrimitiveTuple primitiveTuple = new CPrimitiveTuple();
                        if (item.getMagnitude() != null) {
                            primitiveTuple.addMember(item.getMagnitudeAdl2());
                        } else if (hasMagnitude) {
                            CReal cReal = new CReal();
                            cReal.addConstraint((Interval<Double>)Interval.upperUnbounded((Object)0.0, (boolean)true));
                            primitiveTuple.addMember(cReal);
                        }
                        if (item.getUnits() != null) {
                            primitiveTuple.addMember(item.getUnitsAdl2());
                        } else if (hasUnits) {
                            primitiveTuple.addMember(new CString("/.*/"));
                        }
                        if (item.getPrecision() != null) {
                            primitiveTuple.addMember(item.getPrecisionAdl2());
                        } else if (hasPrecision) {
                            CInteger cInteger = new CInteger();
                            cInteger.addConstraint((Interval<Long>)Interval.upperUnbounded((Object)0L, (boolean)true));
                            primitiveTuple.addMember(cInteger);
                        }
                        tuple.addTuple(primitiveTuple);
                    }
                    result.addAttributeTuple(tuple);
                }
            }
        }
    }

    private CComplexObjectProxy parseCComplexObjectProxy(Adl14Parser.C_complex_object_proxyContext proxyContext) {
        CComplexObjectProxy proxy = new CComplexObjectProxy();
        proxy.setOccurrences(this.parseMultiplicityInterval(proxyContext.c_occurrences()));
        proxy.setTargetPath(proxyContext.adl_path().getText());
        proxy.setRmTypeName(proxyContext.type_id().getText());
        if (proxyContext.AT_CODE() != null) {
            proxy.setNodeId(proxyContext.AT_CODE().getText());
        }
        return proxy;
    }

    private CArchetypeRoot parseArchetypeRoot(Adl14Parser.C_archetype_rootContext archetypeRootContext) {
        CArchetypeRoot root = new CArchetypeRoot();
        root.setRmTypeName(archetypeRootContext.type_id().getText());
        root.setNodeId(archetypeRootContext.AT_CODE().getText());
        if (archetypeRootContext.archetype_ref() != null) {
            root.setArchetypeRef(archetypeRootContext.archetype_ref().getText());
        }
        root.setOccurrences(this.parseMultiplicityInterval(archetypeRootContext.c_occurrences()));
        for (Adl14Parser.C_attribute_defContext attributeContext : archetypeRootContext.c_attribute_def()) {
            this.parseCAttribute(root, attributeContext);
        }
        return root;
    }

    private ArchetypeSlot parseArchetypeSlot(Adl14Parser.Archetype_slotContext slotContext) {
        ArchetypeSlot slot = new ArchetypeSlot();
        Adl14Parser.C_archetype_slot_headContext headContext = slotContext.c_archetype_slot_head();
        if (headContext.c_archetype_slot_id().AT_CODE() != null) {
            slot.setNodeId(headContext.c_archetype_slot_id().AT_CODE().getText());
        }
        slot.setRmTypeName(headContext.c_archetype_slot_id().type_id().getText());
        if (headContext.c_archetype_slot_id().SYM_CLOSED() != null) {
            slot.setClosed(true);
        }
        if (headContext.c_occurrences() != null) {
            slot.setOccurrences(this.parseMultiplicityInterval(headContext.c_occurrences()));
        }
        Adl14RulesParser assertionParser = new Adl14RulesParser(this.getErrors());
        if (slotContext.c_excludes() != null) {
            for (Adl14Parser.AssertionContext assertionContext : slotContext.c_excludes().assertion()) {
                slot.getExcludes().add((Assertion)assertionParser.parse(assertionContext));
            }
        }
        if (slotContext.c_includes() != null) {
            for (Adl14Parser.AssertionContext assertionContext : slotContext.c_includes().assertion()) {
                slot.getIncludes().add((Assertion)assertionParser.parse(assertionContext));
            }
        }
        return slot;
    }

    private Cardinality parseCardinalityInterval(Adl14Parser.C_cardinalityContext context) {
        Cardinality cardinality = new Cardinality();
        MultiplicityInterval interval = this.parseMultiplicity(context.cardinality().multiplicity());
        cardinality.setInterval(interval);
        List modContexts = context.cardinality().multiplicity_mod();
        for (Adl14Parser.Multiplicity_modContext modContext : modContexts) {
            if (modContext.ordering_mod() != null) {
                cardinality.setOrdered(modContext.ordering_mod().SYM_ORDERED() != null);
            } else {
                cardinality.setOrdered(true);
            }
            if (modContext.unique_mod() == null) continue;
            cardinality.setUnique(true);
        }
        return cardinality;
    }

    private MultiplicityInterval parseMultiplicityInterval(Adl14Parser.C_existenceContext existenceContext) {
        MultiplicityInterval interval = new MultiplicityInterval();
        List integers = existenceContext.existence().INTEGER();
        if (integers.size() == 1) {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper(interval.getLower());
        } else if (integers.size() == 2) {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper((Object)Integer.parseInt(((TerminalNode)integers.get(1)).getText()));
        }
        return interval;
    }

    private MultiplicityInterval parseMultiplicityInterval(Adl14Parser.C_occurrencesContext occurrencesContext) {
        if (occurrencesContext == null) {
            return null;
        }
        return this.parseMultiplicity(occurrencesContext.multiplicity());
    }

    private MultiplicityInterval parseMultiplicity(Adl14Parser.MultiplicityContext multiplicity) {
        if (multiplicity == null) {
            return null;
        }
        MultiplicityInterval interval = new MultiplicityInterval();
        List integers = multiplicity.INTEGER();
        if (multiplicity.SYM_INTERVAL_SEP() != null) {
            if (multiplicity.getText().contains("*")) {
                interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
                interval.setUpperUnbounded(true);
            } else {
                interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
                interval.setUpper((Object)Integer.parseInt(((TerminalNode)integers.get(1)).getText()));
            }
        } else if (multiplicity.getText().contains("*")) {
            interval.setLowerUnbounded(false);
            interval.setLower((Object)0);
            interval.setUpperUnbounded(true);
        } else {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper(interval.getLower());
        }
        return interval;
    }
}

