/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.log;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConvertedCodeResult {
    private String originalCode;
    private List<String> convertedCodes = new ArrayList<String>();
    private Map<String, ArchetypeTerm> terms = new LinkedHashMap<String, ArchetypeTerm>();

    public ConvertedCodeResult(String oldCode, String newCode) {
        this.originalCode = oldCode;
        this.convertedCodes.add(newCode);
    }

    @JsonIgnore
    public boolean isSingleReplacement() {
        return this.convertedCodes.size() == 1;
    }

    public String getOriginalCode() {
        return this.originalCode;
    }

    public List<String> getConvertedCodes() {
        return this.convertedCodes;
    }

    public void addNewCode(String newCode) {
        this.convertedCodes.add(newCode);
    }

    @JsonIgnore
    public String getIdCode() {
        for (String code : this.convertedCodes) {
            if (!AOMUtils.isIdCode(code)) continue;
            return code;
        }
        return null;
    }

    @JsonIgnore
    public boolean hasIdCode() {
        return this.getIdCode() != null;
    }

    @JsonIgnore
    public String getValueCode() {
        for (String code : this.convertedCodes) {
            if (!AOMUtils.isValueCode(code)) continue;
            return code;
        }
        return null;
    }

    @JsonIgnore
    public boolean hasValueCode() {
        return this.getValueCode() != null;
    }

    public Map<String, ArchetypeTerm> getTerms() {
        return this.terms;
    }

    public void setTerms(Map<String, ArchetypeTerm> terms) {
        this.terms = terms;
    }

    public void addTerm(String language, ArchetypeTerm term) {
        this.terms.put(language, term);
    }
}

