/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.google.common.collect.Lists;
import com.nedap.archie.adl14.ADL14ConversionUtil;
import com.nedap.archie.adl14.ADL14NodeIDConverter;
import com.nedap.archie.adl14.log.CreatedCode;
import com.nedap.archie.adl14.log.ReasonForCodeCreation;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.terminology.TerminologyCode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ADL14TermConstraintConverter {
    private final Archetype flatParentArchetype;
    private Archetype archetype;
    private ADL14NodeIDConverter converter;

    public ADL14TermConstraintConverter(ADL14NodeIDConverter converter, Archetype archetype, Archetype flatParentArchetype) {
        this.converter = converter;
        this.archetype = archetype;
        this.flatParentArchetype = flatParentArchetype;
    }

    public void convert() {
        this.convert(this.archetype.getDefinition());
    }

    private void convert(CObject cObject) {
        if (cObject instanceof CTerminologyCode) {
            this.convertCTerminologyCode((CTerminologyCode)cObject);
        }
        for (CAttribute attribute : cObject.getAttributes()) {
            this.convert(attribute);
        }
        if (cObject instanceof CComplexObject) {
            for (CAttributeTuple tuple : ((CComplexObject)cObject).getAttributeTuples()) {
                Set<Integer> tupleTermCodeIndices = this.getCTerminologyCodeIndices(tuple);
                for (Integer index : tupleTermCodeIndices) {
                    List termCodes = tuple.getTuples().stream().map(p -> (CPrimitiveObject)p.getMember(index)).collect(Collectors.toList());
                    LinkedHashSet<String> atCodes = new LinkedHashSet<String>();
                    for (CPrimitiveObject cPrimitiveObject : termCodes) {
                        String constraint;
                        CTerminologyCode cTerminologyCode = (CTerminologyCode)cPrimitiveObject;
                        this.convertCTerminologyCode(cTerminologyCode);
                        if (cTerminologyCode.getConstraint().size() != 1 || !AOMUtils.isValueCode(constraint = cTerminologyCode.getConstraint().get(0))) continue;
                        atCodes.add(constraint);
                    }
                    if (atCodes.isEmpty()) continue;
                    this.findOrCreateValueSet(this.archetype, atCodes, cObject);
                }
            }
        }
    }

    private Set<Integer> getCTerminologyCodeIndices(CAttributeTuple tuple) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
            int i = 0;
            for (CPrimitiveObject cPrimitiveObject : primitiveTuple.getMembers()) {
                if (cPrimitiveObject instanceof CTerminologyCode) {
                    result.add(i);
                }
                ++i;
            }
        }
        return result;
    }

    private void convert(CAttribute attribute) {
        for (CObject object : attribute.getChildren()) {
            this.convert(object);
        }
    }

    private void convertCTerminologyCode(CTerminologyCode cTerminologyCode) {
        if (cTerminologyCode.getConstraint() != null && !cTerminologyCode.getConstraint().isEmpty()) {
            Map<String, URI> termBindingsMap;
            TerminologyCode assumedValue;
            boolean isLocalCode;
            String firstConstraint = cTerminologyCode.getConstraint().get(0);
            TerminologyCode termCode = TerminologyCode.createFromString((String)firstConstraint);
            boolean bl = isLocalCode = termCode.getTerminologyId() == null || termCode.getTerminologyId().equalsIgnoreCase("local");
            if (isLocalCode && AOMUtils.isValueCode(firstConstraint)) {
                if (cTerminologyCode.getConstraint().size() == 1) {
                    String newCode = this.converter.convertValueCode(firstConstraint);
                    this.converter.addConvertedCode(firstConstraint, newCode);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{newCode}));
                } else {
                    LinkedHashSet<String> localCodes = new LinkedHashSet<String>();
                    for (String code : cTerminologyCode.getConstraint()) {
                        String newCode = this.converter.convertValueCode(code);
                        this.converter.addConvertedCode(code, newCode);
                        localCodes.add(newCode);
                    }
                    ValueSet valueSet = this.findOrCreateValueSet(cTerminologyCode.getArchetype(), localCodes, cTerminologyCode);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{valueSet.getId()}));
                }
                if (cTerminologyCode.getAssumedValue() != null) {
                    assumedValue = cTerminologyCode.getAssumedValue();
                    String oldCode = assumedValue.getCodeString();
                    String newCode = this.converter.convertValueCode(oldCode);
                    assumedValue.setCodeString(newCode);
                }
            } else if (isLocalCode && AOMUtils.isValueSetCode(termCode.getCodeString())) {
                ArrayList<String> newConstraint = new ArrayList<String>();
                for (String constraint : cTerminologyCode.getConstraint()) {
                    TerminologyCode code = TerminologyCode.createFromString((String)constraint);
                    String newCode = this.converter.convertValueSetCode(termCode.getCodeString());
                    this.converter.addConvertedCode(termCode.getCodeString(), newCode);
                    newConstraint.add(newCode);
                }
                cTerminologyCode.setConstraint((List<String>)newConstraint);
            } else if (cTerminologyCode.getConstraint().size() == 1) {
                try {
                    URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(termCode);
                    termBindingsMap = this.archetype.getTerminology().getTermBindings().get(termCode.getTerminologyId());
                    if (termBindingsMap == null) {
                        termBindingsMap = new LinkedHashMap<String, URI>();
                        this.archetype.getTerminology().getTermBindings().put(termCode.getTerminologyId(), termBindingsMap);
                    }
                    String termBinding = this.findOrAddTermBindingAndCode(termCode, uri, termBindingsMap);
                    cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{termBinding}));
                }
                catch (URISyntaxException uri) {}
            } else {
                String terminologyId = termCode.getTerminologyId();
                termBindingsMap = this.archetype.getTerminology().getTermBindings().get(termCode.getTerminologyId());
                ArrayList<String> atCodes = new ArrayList<String>();
                ArrayList<String> constraints = new ArrayList<String>(cTerminologyCode.getConstraint());
                cTerminologyCode.setConstraint((List<String>)atCodes);
                for (String constraint : constraints) {
                    try {
                        TerminologyCode constraintCode = new TerminologyCode();
                        constraintCode.setTerminologyId(terminologyId);
                        constraintCode.setCodeString(constraint);
                        URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(constraintCode);
                        atCodes.add(this.findOrAddTermBindingAndCode(termCode, uri, termBindingsMap));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                ValueSet valueSet = this.findOrCreateValueSet(cTerminologyCode.getArchetype(), new LinkedHashSet<String>(atCodes), cTerminologyCode);
                cTerminologyCode.setConstraint(Lists.newArrayList((Object[])new String[]{valueSet.getId()}));
            }
            if (cTerminologyCode.getAssumedValue() != null) {
                assumedValue = cTerminologyCode.getAssumedValue();
                if (isLocalCode) {
                    String newCode = this.converter.convertValueCode(assumedValue.getCodeString());
                    assumedValue.setCodeString(newCode);
                    assumedValue.setTerminologyId(null);
                } else {
                    try {
                        termBindingsMap = this.archetype.getTerminology().getTermBindings().get(assumedValue.getTerminologyId());
                        URI uri = new ADL14ConversionUtil(this.converter.getConversionConfiguration()).convertToUri(assumedValue);
                        assumedValue.setCodeString(this.findOrAddTermBindingAndCode(assumedValue, uri, termBindingsMap));
                        assumedValue.setTerminologyId(null);
                        assumedValue.setTerminologyVersion(null);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String findOrAddTermBindingAndCode(TerminologyCode termCode, URI uri, Map<String, URI> termBindingsMap) {
        String existingTermBinding = ADL14ConversionUtil.findExistingTermBinding(termCode.getTerminologyId(), this.archetype, this.flatParentArchetype, uri, termBindingsMap);
        if (existingTermBinding != null) {
            return existingTermBinding;
        }
        String valueCode = this.converter.getIdCodeGenerator().generateNextValueCode();
        termBindingsMap.put(valueCode, uri);
        CreatedCode createdCode = new CreatedCode(valueCode, ReasonForCodeCreation.CREATED_VALUE_FOR_EXTERNAL_TERM);
        createdCode.setOriginalTerm(termCode);
        this.converter.addCreatedCode(termCode.toString(), createdCode);
        for (String language : this.archetype.getTerminology().getTermDefinitions().keySet()) {
            ArchetypeTerm term = new ArchetypeTerm();
            term.setCode(valueCode);
            term.setText("Term binding for " + termCode.toString() + ", translation not known in ADL 1.4 -> ADL 2 converter");
            term.setDescription(term.getText());
            this.archetype.getTerminology().getTermDefinitions().get(language).put(valueCode, term);
        }
        return valueCode;
    }

    private ValueSet findOrCreateValueSet(Archetype archetype, Set<String> localCodes, CObject owningConstraint) {
        ValueSet valueSet;
        if (this.flatParentArchetype != null && (valueSet = this.findValueSet(this.flatParentArchetype, localCodes)) != null) {
            return valueSet;
        }
        valueSet = this.findValueSet(archetype, localCodes);
        if (valueSet != null) {
            return valueSet;
        }
        valueSet = new ValueSet();
        valueSet.setMembers(localCodes);
        valueSet.setId(this.converter.getIdCodeGenerator().generateNextValueSetCode());
        this.converter.addCreatedCode(valueSet.getId(), new CreatedCode(valueSet.getId(), ReasonForCodeCreation.CREATED_VALUE_SET));
        this.converter.addCreatedValueSet(valueSet.getId(), valueSet);
        archetype.getTerminology().getValueSets().put(valueSet.getId(), valueSet);
        for (String language : archetype.getTerminology().getTermDefinitions().keySet()) {
            ArchetypeTerm term = this.getTerm(language, owningConstraint);
            if (term == null) continue;
            ArchetypeTerm newTerm = new ArchetypeTerm();
            newTerm.setCode(valueSet.getId());
            newTerm.setText(term.getText() + " (synthesised)");
            newTerm.setDescription(term.getDescription() + " (synthesised)");
            archetype.getTerminology().getTermDefinitions().get(language).put(newTerm.getCode(), newTerm);
        }
        return valueSet;
    }

    private ValueSet findValueSet(Archetype archetype, Set<String> localCodes) {
        for (ValueSet valueSet : archetype.getTerminology().getValueSets().values()) {
            if (!valueSet.getMembers().equals(localCodes)) continue;
            return valueSet;
        }
        return null;
    }

    protected ArchetypeTerm getTerm(String language, CObject owningConstraint) {
        CObject cObject = owningConstraint;
        while (cObject != null) {
            ArchetypeTerm term;
            String oldCode;
            if (cObject.getNodeId() != null && (oldCode = this.converter.getOldCodeForNewCode(cObject.getNodeId())) != null && this.archetype.getTerminology().getTermDefinition(language, oldCode) != null && (term = this.archetype.getTerminology().getTermDefinition(language, oldCode)) != null) {
                return term;
            }
            cObject = cObject.getParent() == null ? null : cObject.getParent().getParent();
        }
        return null;
    }
}

