/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.adl14.ADL14ConversionConfiguration;
import com.nedap.archie.adl14.ADL14ConversionMessageCode;
import com.nedap.archie.adl14.ADL14TermConstraintConverter;
import com.nedap.archie.adl14.ADL2ConversionResult;
import com.nedap.archie.adl14.IdCodeGenerator;
import com.nedap.archie.adl14.OutsideRangeIdCodeGenerator;
import com.nedap.archie.adl14.PreviousConversionApplier;
import com.nedap.archie.adl14.log.ADL2ConversionLog;
import com.nedap.archie.adl14.log.ConvertedCodeResult;
import com.nedap.archie.adl14.log.CreatedCode;
import com.nedap.archie.adl14.log.ReasonForCodeCreation;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.NodeIdUtil;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.rminfo.MetaModels;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.utils.message.MessageCode;

public class ADL14NodeIDConverter {
    private final Archetype archetype;
    private final Archetype flatParentArchetype;
    private final ADL14ConversionConfiguration conversionConfiguration;
    private final ADL14TermConstraintConverter termConstraintConverter;
    private final PreviousConversionApplier previousConversionApplier;
    private final ADL2ConversionResult conversionResult;
    private final MetaModels metaModels;
    private IdCodeGenerator idCodeGenerator;
    private Map<String, ConvertedCodeResult> convertedCodes = new LinkedHashMap<String, ConvertedCodeResult>();
    private Map<String, CreatedCode> createdCodes = new LinkedHashMap<String, CreatedCode>();
    private Map<String, ValueSet> createdValueSets = new LinkedHashMap<String, ValueSet>();
    private Map<String, String> newCodeToOldCodeMap = new LinkedHashMap<String, String>();

    public ADL14NodeIDConverter(MetaModels metaModels, Archetype archetype, Archetype flatParentArchetype, ADL14ConversionConfiguration configuration, ADL2ConversionLog oldLog, ADL2ConversionResult conversionResult) {
        this.metaModels = metaModels;
        this.conversionConfiguration = configuration;
        this.archetype = archetype;
        this.flatParentArchetype = flatParentArchetype;
        this.termConstraintConverter = new ADL14TermConstraintConverter(this, archetype, flatParentArchetype);
        this.previousConversionApplier = new PreviousConversionApplier(this, archetype, oldLog);
        this.conversionResult = conversionResult;
    }

    public ADL14ConversionConfiguration getConversionConfiguration() {
        return this.conversionConfiguration;
    }

    public ADL2ConversionLog convert() {
        this.metaModels.selectModel(this.archetype);
        this.correctItemsCardinality(this.archetype.getDefinition());
        this.convert(this.archetype.getDefinition());
        if (this.previousConversionApplier != null) {
            this.previousConversionApplier.addCreatedCodes();
            this.previousConversionApplier.addValueSets();
        }
        this.idCodeGenerator = new OutsideRangeIdCodeGenerator(this.archetype);
        this.termConstraintConverter.convert();
        this.convertTermBindings(this.archetype);
        this.generateMissingNodeIds(this.archetype.getDefinition());
        this.convertTermDefinitions();
        this.previousConversionApplier.removeCreatedUnusedTermCodesAndValueSets();
        return new ADL2ConversionLog(null, this.createdCodes, this.createdValueSets);
    }

    private void correctItemsCardinality(CObject cObject) {
        for (CAttribute attribute : cObject.getAttributes()) {
            Cardinality cardinality;
            if (attribute.getRmAttributeName().equalsIgnoreCase("items") && cObject.getRmTypeName().equalsIgnoreCase("CLUSTER") && attribute.getCardinality() != null && (cardinality = attribute.getCardinality()).getInterval().isUpperUnbounded() && (Integer)cardinality.getInterval().getLower() == 0 && cardinality.getInterval().isLowerIncluded()) {
                cardinality.getInterval().setLower((Object)1);
            }
            for (CObject child : attribute.getChildren()) {
                this.correctItemsCardinality(child);
            }
        }
    }

    private void convertTermDefinitions() {
        ArrayList<ConvertedCodeResult> sortedCodes = new ArrayList<ConvertedCodeResult>(this.convertedCodes.values());
        Comparator<ConvertedCodeResult> comparator = Comparator.comparing(r -> r.getOriginalCode());
        sortedCodes.sort(comparator.reversed());
        for (ConvertedCodeResult convertedCode : sortedCodes) {
            for (String language : this.archetype.getTerminology().getTermDefinitions().keySet()) {
                Map<String, ArchetypeTerm> terms = this.archetype.getTerminology().getTermDefinitions().get(language);
                ArchetypeTerm term = terms.remove(convertedCode.getOriginalCode());
                if (term == null) continue;
                for (String newCode : convertedCode.getConvertedCodes()) {
                    ArchetypeTerm newTerm = new ArchetypeTerm();
                    newTerm.setCode(newCode);
                    newTerm.setText(term.getText());
                    newTerm.setDescription(term.getDescription());
                    newTerm.putAll((Map<? extends String, ? extends String>)term.getOtherItems());
                    terms.put(newCode, term);
                }
            }
        }
    }

    private void convertTermBindings(Archetype archetype) {
        if (archetype.getTerminology().getTermBindings() != null) {
            LinkedHashMap<String, Map<String, URI>> newTermBindings = new LinkedHashMap<String, Map<String, URI>>();
            for (String terminologyid : archetype.getTerminology().getTermBindings().keySet()) {
                Map<String, URI> termbindingMap = archetype.getTerminology().getTermBindings().get(terminologyid);
                LinkedHashMap<String, URI> newTermbindingsMap = new LinkedHashMap<String, URI>();
                newTermBindings.put(terminologyid, newTermbindingsMap);
                for (String valueOrPath : termbindingMap.keySet()) {
                    if (valueOrPath.startsWith("/")) {
                        String newPath = this.convertPath(valueOrPath);
                        newTermbindingsMap.put(newPath, termbindingMap.get(valueOrPath));
                        continue;
                    }
                    if (AOMUtils.isValueCode(valueOrPath)) {
                        if (this.convertedCodes.containsKey(valueOrPath)) {
                            for (String newCode : this.convertedCodes.get(valueOrPath).getConvertedCodes()) {
                                newTermbindingsMap.put(newCode, termbindingMap.get(valueOrPath));
                            }
                            continue;
                        }
                        newTermbindingsMap.put(valueOrPath, termbindingMap.get(valueOrPath));
                        this.conversionResult.getLog().addWarningWithLocation((MessageCode)ADL14ConversionMessageCode.WARNING_UNKNOWN_CODE_TYPE_IN_TERMBINDING, valueOrPath, new Object[]{valueOrPath});
                        continue;
                    }
                    if (AOMUtils.isValueSetCode(valueOrPath)) {
                        if (this.convertedCodes.containsKey(valueOrPath)) {
                            for (String newCode : this.convertedCodes.get(valueOrPath).getConvertedCodes()) {
                                newTermbindingsMap.put(newCode, termbindingMap.get(valueOrPath));
                            }
                            continue;
                        }
                        newTermbindingsMap.put(this.convertCode(valueOrPath, "ac"), termbindingMap.get(valueOrPath));
                        continue;
                    }
                    if (AOMUtils.isIdCode(valueOrPath)) {
                        if (this.convertedCodes.containsKey(valueOrPath)) {
                            for (String newCode : this.convertedCodes.get(valueOrPath).getConvertedCodes()) {
                                newTermbindingsMap.put(newCode, termbindingMap.get(valueOrPath));
                            }
                            continue;
                        }
                        newTermbindingsMap.put(valueOrPath, termbindingMap.get(valueOrPath));
                        this.conversionResult.getLog().addWarningWithLocation((MessageCode)ADL14ConversionMessageCode.WARNING_UNKNOWN_CODE_TYPE_IN_TERMBINDING, valueOrPath, new Object[]{valueOrPath});
                        continue;
                    }
                    newTermbindingsMap.put(valueOrPath, termbindingMap.get(valueOrPath));
                    this.conversionResult.getLog().addWarningWithLocation((MessageCode)ADL14ConversionMessageCode.WARNING_UNKNOWN_CODE_TYPE_IN_TERMBINDING, valueOrPath, new Object[]{valueOrPath});
                }
            }
            archetype.getTerminology().setTermBindings(newTermBindings);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateMissingNodeIds(CObject cObject) {
        if (!(cObject instanceof CPrimitiveObject) && cObject.getNodeId() == null) {
            String path = cObject.getPath();
            if (this.archetype.getParentArchetypeId() != null && this.flatParentArchetype != null) {
                String parentPath = AOMUtils.pathAtSpecializationLevel(cObject.getPathSegments(), this.archetype.specializationDepth() - 1);
                CAttribute cAttributeInParent = (CAttribute)this.flatParentArchetype.itemAtPath(parentPath);
                if (cAttributeInParent != null) {
                    List<CObject> childrenWithSameRmTypeName = cAttributeInParent.getChildrenByRmTypeName(cObject.getRmTypeName());
                    if (childrenWithSameRmTypeName.size() == 1) {
                        cObject.setNodeId(childrenWithSameRmTypeName.get(0).getNodeId());
                    } else if (childrenWithSameRmTypeName.size() > 1) {
                        this.synthesizeNodeId(cObject, path);
                        this.conversionResult.getLog().addWarningWithLocation((MessageCode)ADL14ConversionMessageCode.WARNING_SPECIALIZED_FIRST_MATCHING_CHILD, cObject.path(), new Object[0]);
                    } else {
                        if (cAttributeInParent.getChildren().size() != 1) throw new RuntimeException("cannot convert node id at path " + path);
                        if (this.metaModels.rmTypesConformant(cObject.getRmTypeName(), cAttributeInParent.getChildren().get(0).getRmTypeName())) {
                            this.createSpecialisedNodeId(cObject, path, Arrays.asList(cAttributeInParent.getChildren().get(0)));
                        } else {
                            this.synthesizeNodeId(cObject, path);
                        }
                    }
                } else {
                    this.synthesizeNodeId(cObject, path);
                }
            } else {
                this.synthesizeNodeId(cObject, path);
            }
        }
        for (CAttribute attribute : cObject.getAttributes()) {
            this.generateMissingNodeIds(attribute);
        }
    }

    private void createSpecialisedNodeId(CObject cObject, String path, List<CObject> childrenWithSameRmTypeName) {
        cObject.setNodeId(this.idCodeGenerator.generateNextSpecializedIdCode(childrenWithSameRmTypeName.get(0).getNodeId()));
        CreatedCode createdCode = new CreatedCode(cObject.getNodeId(), ReasonForCodeCreation.C_OBJECT_WITHOUT_NODE_ID);
        createdCode.setRmTypeName(cObject.getRmTypeName());
        createdCode.setPathCreated(path);
        this.addCreatedCode(cObject.getNodeId(), createdCode);
        this.createTermForNewCode(cObject);
    }

    private void synthesizeNodeId(CObject cObject, String path) {
        cObject.setNodeId(this.idCodeGenerator.generateNextIdCode());
        CreatedCode createdCode = new CreatedCode(cObject.getNodeId(), ReasonForCodeCreation.C_OBJECT_WITHOUT_NODE_ID);
        createdCode.setRmTypeName(cObject.getRmTypeName());
        createdCode.setPathCreated(path);
        this.addCreatedCode(cObject.getNodeId(), createdCode);
        this.createTermForNewCode(cObject);
    }

    private void createTermForNewCode(CObject cObject) {
        if (cObject.getParent().isMultiple()) {
            for (String language : this.archetype.getTerminology().getTermDefinitions().keySet()) {
                ArchetypeTerm term = this.termConstraintConverter.getTerm(language, cObject);
                if (term == null) continue;
                ArchetypeTerm newTerm = new ArchetypeTerm();
                newTerm.setCode(cObject.getNodeId());
                newTerm.setText(term.getText() + " (synthesised)");
                newTerm.setDescription(term.getDescription() + " (synthesised)");
                this.archetype.getTerminology().getTermDefinitions().get(language).put(newTerm.getCode(), newTerm);
            }
        }
    }

    protected void addCreatedCode(String code, CreatedCode createdCode) {
        this.createdCodes.put(code, createdCode);
    }

    protected void addCreatedValueSet(String nodeId, ValueSet valueSet) {
        this.createdValueSets.put(nodeId, valueSet);
    }

    private void generateMissingNodeIds(CAttribute attribute) {
        for (CObject cObject : attribute.getChildren()) {
            this.generateMissingNodeIds(cObject);
        }
    }

    private void convert(CObject cObject) {
        if (cObject instanceof CComplexObject) {
            if (cObject instanceof CArchetypeRoot) {
                // empty if block
            }
            this.calculateNewNodeId(cObject);
        } else if (cObject instanceof ArchetypeSlot) {
            this.calculateNewNodeId(cObject);
        } else if (cObject instanceof CComplexObjectProxy) {
            CComplexObjectProxy proxy = (CComplexObjectProxy)cObject;
            this.calculateNewNodeId(cObject);
            proxy.setTargetPath(this.convertPath(proxy.getTargetPath()));
        }
        for (CAttribute attribute : cObject.getAttributes()) {
            this.convert(attribute);
        }
    }

    private void calculateNewNodeId(CObject cObject) {
        if (cObject.getNodeId() == null) {
            if (!(cObject instanceof CComplexObject) && !(cObject instanceof CArchetypeRoot) && !(cObject instanceof ArchetypeSlot) && cObject instanceof CPrimitiveObject) {
                // empty if block
            }
        } else {
            String oldNodeId = cObject.getNodeId();
            String newNodeId = this.convertNodeId(oldNodeId);
            this.addConvertedCode(oldNodeId, newNodeId);
            cObject.setNodeId(newNodeId);
        }
    }

    protected void addConvertedCode(String oldNodeId, String newNodeId) {
        if (this.convertedCodes.containsKey(oldNodeId)) {
            this.convertedCodes.get(oldNodeId).addNewCode(newNodeId);
        } else {
            this.convertedCodes.put(oldNodeId, new ConvertedCodeResult(oldNodeId, newNodeId));
        }
        this.newCodeToOldCodeMap.put(newNodeId, oldNodeId);
    }

    public String convertNodeId(String oldNodeId) {
        ConvertedCodeResult convertedCodeResult = this.convertedCodes.get(oldNodeId);
        if (convertedCodeResult != null && convertedCodeResult.hasIdCode()) {
            return convertedCodeResult.getIdCode();
        }
        return this.convertCode(oldNodeId, "id");
    }

    protected String convertValueCode(String oldCode) {
        ConvertedCodeResult convertedCodeResult = this.convertedCodes.get(oldCode);
        if (convertedCodeResult != null && convertedCodeResult.hasValueCode()) {
            return convertedCodeResult.getValueCode();
        }
        return this.convertCode(oldCode, "at");
    }

    public String convertValueSetCode(String oldCode) {
        ConvertedCodeResult convertedCodeResult = this.convertedCodes.get(oldCode);
        if (convertedCodeResult != null && convertedCodeResult.hasValueCode()) {
            return convertedCodeResult.getValueCode();
        }
        return this.convertCode(oldCode, "ac");
    }

    private String convertCode(String oldCode, String newCodePrefix) {
        NodeIdUtil nodeIdUtil = new NodeIdUtil(oldCode);
        if (nodeIdUtil.getCodes().isEmpty()) {
            return oldCode;
        }
        nodeIdUtil.setPrefix(newCodePrefix);
        if (!oldCode.startsWith("at0.")) {
            nodeIdUtil.getCodes().set(0, nodeIdUtil.getCodes().get(0) + 1);
        }
        return nodeIdUtil.toString();
    }

    private void convert(CAttribute attribute) {
        for (CObject object : attribute.getChildren()) {
            this.convert(object);
        }
    }

    public String convertPath(String key) {
        APathQuery aPathQuery = new APathQuery(key);
        for (PathSegment segment : aPathQuery.getPathSegments()) {
            if (segment.getNodeId() == null) continue;
            segment.setNodeId(this.convertNodeId(segment.getNodeId()));
        }
        return aPathQuery.toString();
    }

    public String getOldCodeForNewCode(String nodeId) {
        return this.newCodeToOldCodeMap.get(nodeId);
    }

    protected Archetype getFlatParentArchetype() {
        return this.flatParentArchetype;
    }

    public ADL2ConversionResult getConversionResult() {
        return this.conversionResult;
    }

    protected IdCodeGenerator getIdCodeGenerator() {
        return this.idCodeGenerator;
    }
}

