/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ResourceDescription;
import java.util.LinkedHashMap;

public class ADL14DescriptionConverter {
    public void convert(Archetype archetype) {
        String revision;
        String ipAcknowledgements;
        ResourceDescription description = archetype.getDescription();
        description.setLicence(description.getOtherDetails().remove("licence"));
        description.setOriginalNamespace(description.getOtherDetails().remove("original_namespace"));
        description.setOriginalPublisher(description.getOtherDetails().remove("original_publisher"));
        description.setCustodianNamespace(description.getOtherDetails().remove("custodian_namespace"));
        description.setCustodianOrganisation(description.getOtherDetails().remove("custodian_organisation"));
        archetype.setBuildUid(description.getOtherDetails().remove("build_uid"));
        String references = description.getOtherDetails().remove("references");
        if (references != null) {
            LinkedHashMap<String, String> newReferences = new LinkedHashMap<String, String>();
            String[] lines = references.split("\r?\n");
            int i = 1;
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                newReferences.put(Integer.toString(i), line);
                ++i;
            }
            description.setReferences(newReferences);
        }
        if ((ipAcknowledgements = description.getOtherDetails().remove("ip_acknowledgements")) != null) {
            LinkedHashMap<String, String> acknowledgements = new LinkedHashMap<String, String>();
            String[] lines = ipAcknowledgements.split("\r?\n");
            int i = 1;
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                acknowledgements.put(Integer.toString(i), line);
                ++i;
            }
            description.setIpAcknowledgements(acknowledgements);
        }
        if ((revision = description.getOtherDetails().remove("revision")) != null) {
            archetype.getArchetypeId().setReleaseVersion(revision);
        }
        archetype.setGenerated(true);
    }
}

