/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.willy.ratingbar.PartialView;
import com.willy.ratingbar.R;
import com.willy.ratingbar.SavedState;
import com.willy.ratingbar.SimpleRatingBar;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class BaseRatingBar
extends LinearLayout
implements SimpleRatingBar {
    public static final String TAG = "SimpleRatingBar";
    private static final int MAX_CLICK_DISTANCE = 5;
    private static final int MAX_CLICK_DURATION = 200;
    private final DecimalFormat mDecimalFormat;
    private int mNumStars;
    private int mPadding = 0;
    private int mStarWidth;
    private int mStarHeight;
    private float mRating = -1.0f;
    private float mStepSize = 1.0f;
    private float mPreviousRating = 0.0f;
    private boolean mIsTouchable = true;
    private boolean mClearRatingEnabled = true;
    private float mStartX;
    private float mStartY;
    private Drawable mEmptyDrawable;
    private Drawable mFilledDrawable;
    private OnRatingChangeListener mOnRatingChangeListener;
    protected List<PartialView> mPartialViews;

    public BaseRatingBar(Context context) {
        this(context, null);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBarAttributes);
        float rating = typedArray.getFloat(R.styleable.RatingBarAttributes_rating, this.mRating);
        this.mNumStars = typedArray.getInt(R.styleable.RatingBarAttributes_numStars, this.mNumStars);
        this.mPadding = typedArray.getDimensionPixelSize(R.styleable.RatingBarAttributes_starPadding, this.mPadding);
        this.mStarWidth = typedArray.getDimensionPixelSize(R.styleable.RatingBarAttributes_starWidth, 0);
        this.mStarHeight = typedArray.getDimensionPixelSize(R.styleable.RatingBarAttributes_starHeight, 0);
        this.mStepSize = typedArray.getFloat(R.styleable.RatingBarAttributes_stepSize, this.mStepSize);
        this.mEmptyDrawable = typedArray.hasValue(R.styleable.RatingBarAttributes_drawableEmpty) ? ContextCompat.getDrawable((Context)context, (int)typedArray.getResourceId(R.styleable.RatingBarAttributes_drawableEmpty, -1)) : null;
        this.mFilledDrawable = typedArray.hasValue(R.styleable.RatingBarAttributes_drawableFilled) ? ContextCompat.getDrawable((Context)context, (int)typedArray.getResourceId(R.styleable.RatingBarAttributes_drawableFilled, -1)) : null;
        this.mIsTouchable = typedArray.getBoolean(R.styleable.RatingBarAttributes_touchable, this.mIsTouchable);
        this.mClearRatingEnabled = typedArray.getBoolean(R.styleable.RatingBarAttributes_clearRatingEnabled, this.mClearRatingEnabled);
        typedArray.recycle();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.mDecimalFormat = new DecimalFormat("#.##", symbols);
        this.verifyParamsValue();
        this.initRatingView();
        this.setRating(rating);
    }

    private void verifyParamsValue() {
        if (this.mNumStars <= 0) {
            this.mNumStars = 5;
        }
        if (this.mPadding < 0) {
            this.mPadding = 0;
        }
        if (this.mEmptyDrawable == null) {
            this.mEmptyDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.empty);
        }
        if (this.mFilledDrawable == null) {
            this.mFilledDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.filled);
        }
        if (this.mStepSize > 1.0f) {
            this.mStepSize = 1.0f;
        } else if (this.mStepSize < 0.1f) {
            this.mStepSize = 0.1f;
        }
    }

    private void initRatingView() {
        this.mPartialViews = new ArrayList<PartialView>();
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(this.mStarWidth == 0 ? -2 : this.mStarWidth, this.mStarHeight == 0 ? -2 : this.mStarHeight);
        for (int i = 1; i <= this.mNumStars; ++i) {
            PartialView partialView = this.getPartialView(i, this.mFilledDrawable, this.mEmptyDrawable);
            this.mPartialViews.add(partialView);
            this.addView((View)partialView, params);
        }
    }

    private PartialView getPartialView(int ratingViewId, Drawable filledDrawable, Drawable emptyDrawable) {
        PartialView partialView = new PartialView(this.getContext());
        partialView.setTag(ratingViewId);
        partialView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        partialView.setFilledDrawable(filledDrawable);
        partialView.setEmptyDrawable(emptyDrawable);
        return partialView;
    }

    protected void emptyRatingBar() {
        this.fillRatingBar(0.0f);
    }

    protected void fillRatingBar(float rating) {
        for (PartialView partialView : this.mPartialViews) {
            double maxIntOfRating;
            int ratingViewId = (Integer)partialView.getTag();
            if ((double)ratingViewId > (maxIntOfRating = Math.ceil(rating))) {
                partialView.setEmpty();
                continue;
            }
            if ((double)ratingViewId == maxIntOfRating) {
                partialView.setPartialFilled(rating);
                continue;
            }
            partialView.setFilled();
        }
    }

    @Override
    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mPartialViews.clear();
        this.removeAllViews();
        this.mNumStars = numStars;
        this.initRatingView();
    }

    @Override
    public int getNumStars() {
        return this.mNumStars;
    }

    @Override
    public void setRating(float rating) {
        if (rating > (float)this.mNumStars) {
            rating = this.mNumStars;
        }
        if (rating < 0.0f) {
            rating = 0.0f;
        }
        if (this.mRating == rating) {
            return;
        }
        this.mRating = rating;
        if (this.mOnRatingChangeListener != null) {
            this.mOnRatingChangeListener.onRatingChange(this, this.mRating);
        }
        this.fillRatingBar(rating);
    }

    @Override
    public float getRating() {
        return this.mRating;
    }

    @Override
    public void setStarPadding(int ratingPadding) {
        if (ratingPadding < 0) {
            return;
        }
        this.mPadding = ratingPadding;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        }
    }

    @Override
    public int getStarPadding() {
        return this.mPadding;
    }

    @Override
    public void setEmptyDrawableRes(@DrawableRes int res) {
        this.setEmptyDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setFilledDrawableRes(@DrawableRes int res) {
        this.setFilledDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setEmptyDrawable(Drawable drawable2) {
        this.mEmptyDrawable = drawable2;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setEmptyDrawable(drawable2);
        }
    }

    @Override
    public void setFilledDrawable(Drawable drawable2) {
        this.mFilledDrawable = drawable2;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setFilledDrawable(drawable2);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isTouchable()) {
            return false;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mStartX = eventX;
                this.mStartY = eventY;
                this.mPreviousRating = this.mRating;
                break;
            }
            case 2: {
                this.handleMoveEvent(eventX);
                break;
            }
            case 1: {
                if (!this.isClickEvent(this.mStartX, this.mStartY, event)) {
                    return false;
                }
                this.handleClickEvent(eventX);
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return true;
    }

    private void handleMoveEvent(float eventX) {
        for (PartialView partialView : this.mPartialViews) {
            float rating;
            if (eventX < (float)partialView.getWidth() / 10.0f) {
                this.setRating(0.0f);
                return;
            }
            if (!this.isPositionInRatingView(eventX, (View)partialView) || this.mRating == (rating = this.calculateRating(eventX, partialView))) continue;
            this.setRating(rating);
        }
    }

    private float calculateRating(float eventX, PartialView partialView) {
        float ratioOfView = Float.parseFloat(this.mDecimalFormat.format((eventX - (float)partialView.getLeft()) / (float)partialView.getWidth()));
        float steps = (float)Math.round(ratioOfView / this.mStepSize) * this.mStepSize;
        return Float.parseFloat(this.mDecimalFormat.format((float)((Integer)partialView.getTag()).intValue() - (1.0f - steps)));
    }

    private void handleClickEvent(float eventX) {
        for (PartialView partialView : this.mPartialViews) {
            float rating;
            if (!this.isPositionInRatingView(eventX, (View)partialView)) continue;
            float f = rating = this.mStepSize == 1.0f ? (float)((Integer)partialView.getTag()).intValue() : this.calculateRating(eventX, partialView);
            if (this.mPreviousRating == rating && this.isClearRatingEnabled()) {
                this.setRating(0.0f);
                break;
            }
            this.setRating(rating);
            break;
        }
    }

    private boolean isPositionInRatingView(float eventX, View ratingView) {
        return eventX > (float)ratingView.getLeft() && eventX < (float)ratingView.getRight();
    }

    private boolean isClickEvent(float startX, float startY, MotionEvent event) {
        float duration = event.getEventTime() - event.getDownTime();
        if (duration > 200.0f) {
            return false;
        }
        float differenceX = Math.abs(startX - event.getX());
        float differenceY = Math.abs(startY - event.getY());
        return !(differenceX > 5.0f) && !(differenceY > 5.0f);
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.mOnRatingChangeListener = onRatingChangeListener;
    }

    public boolean isTouchable() {
        return this.mIsTouchable;
    }

    public void setTouchable(boolean touchable) {
        this.mIsTouchable = touchable;
    }

    public void setClearRatingEnabled(boolean enabled) {
        this.mClearRatingEnabled = enabled;
    }

    public boolean isClearRatingEnabled() {
        return this.mClearRatingEnabled;
    }

    public float getStepSize() {
        return this.mStepSize;
    }

    public void setStepSize(@FloatRange(from=0.1, to=1.0) float stepSize) {
        this.mStepSize = stepSize;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.setRating(this.mRating);
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setRating(ss.getRating());
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(BaseRatingBar var1, float var2);
    }
}

