/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.logging;

import com.ok2c.hc.android.logging.AndroidLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public final class AndroidLoggerFactory
implements ILoggerFactory {
    public static final AndroidLoggerFactory INSTANCE = new AndroidLoggerFactory();
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    private static String loggerNameToTag(String loggerName) {
        if (loggerName == null) {
            return "null";
        }
        int length = loggerName.length();
        if (length <= 23) {
            return loggerName;
        }
        int lastPeriod = loggerName.lastIndexOf(".");
        return length - (lastPeriod + 1) <= 23 ? loggerName.substring(lastPeriod + 1) : loggerName.substring(loggerName.length() - 23);
    }

    public Logger getLogger(String name) {
        AndroidLogger newLogger;
        String tag = name.equals("org.apache.hc.client5.http.wire") ? "HttpClientWire" : (name.equals("org.apache.hc.client5.http.headers") ? "HttpClientHeader" : (name.startsWith("org.apache.hc.") ? "HttpClient" : AndroidLoggerFactory.loggerNameToTag(name)));
        Object logger = (Logger)this.loggerMap.get(tag);
        if (logger == null && (logger = this.loggerMap.putIfAbsent(name, (Logger)(newLogger = new AndroidLogger(tag)))) == null) {
            logger = newLogger;
        }
        return logger;
    }
}

