/*
 * Decompiled with CFR 0.152.
 */
package com.github.odiszapc.nginxparser;

import com.github.odiszapc.nginxparser.NgxAbstractEntry;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxEntryType;
import com.github.odiszapc.nginxparser.NgxParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NgxBlock
extends NgxAbstractEntry
implements Iterable<NgxEntry> {
    private Collection<NgxEntry> entries = new ArrayList<NgxEntry>();

    public NgxBlock() {
        super(new String[0]);
    }

    public Collection<NgxEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(NgxEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public String toString() {
        return super.toString() + " {";
    }

    @Override
    public Iterator<NgxEntry> iterator() {
        return this.getEntries().iterator();
    }

    public void remove(NgxEntry itemToRemove) {
        if (null == itemToRemove) {
            throw new NullPointerException("Item can not be null");
        }
        Iterator<NgxEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            NgxEntry entry = it.next();
            switch (NgxEntryType.fromClass(entry.getClass())) {
                case PARAM: {
                    if (!entry.equals(itemToRemove)) break;
                    it.remove();
                    break;
                }
                case BLOCK: {
                    if (entry.equals(itemToRemove)) {
                        it.remove();
                        break;
                    }
                    NgxBlock block = (NgxBlock)entry;
                    block.remove(itemToRemove);
                }
            }
        }
    }

    public void removeAll(Iterable<NgxEntry> itemsToRemove) {
        if (null == itemsToRemove) {
            throw new NullPointerException("Items can not be null");
        }
        for (NgxEntry itemToRemove : itemsToRemove) {
            this.remove(itemToRemove);
        }
    }

    public <T extends NgxEntry> T find(Class<T> clazz, String ... params) {
        List<NgxEntry> all = this.findAll(clazz, new ArrayList<NgxEntry>(), params);
        if (all.isEmpty()) {
            return null;
        }
        return (T)all.get(0);
    }

    public NgxBlock findBlock(String ... params) {
        NgxEntry entry = this.find(NgxConfig.BLOCK, params);
        if (null == entry) {
            return null;
        }
        return (NgxBlock)entry;
    }

    public NgxParam findParam(String ... params) {
        NgxEntry entry = this.find(NgxConfig.PARAM, params);
        if (null == entry) {
            return null;
        }
        return (NgxParam)entry;
    }

    public <T extends NgxEntry> List<NgxEntry> findAll(Class<T> clazz, String ... params) {
        return this.findAll(clazz, new ArrayList<NgxEntry>(), params);
    }

    public <T extends NgxEntry> List<NgxEntry> findAll(Class<T> clazz, List<NgxEntry> result, String ... params) {
        ArrayList<NgxEntry> res = new ArrayList<NgxEntry>();
        if (0 == params.length) {
            return res;
        }
        String head = params[0];
        String[] tail = params.length > 1 ? Arrays.copyOfRange(params, 1, params.length) : new String[]{};
        for (NgxEntry entry : this.getEntries()) {
            switch (NgxEntryType.fromClass(entry.getClass())) {
                case PARAM: {
                    NgxParam param = (NgxParam)entry;
                    if (!param.getName().equals(head) || param.getClass() != clazz) break;
                    res.add(param);
                    break;
                }
                case BLOCK: {
                    NgxBlock block = (NgxBlock)entry;
                    if (tail.length > 0) {
                        if (!block.getName().equals(head)) break;
                        res.addAll(block.findAll(clazz, result, tail));
                        break;
                    }
                    if (!block.getName().equals(head) || !clazz.equals(NgxBlock.class)) break;
                    res.add(block);
                }
            }
        }
        return res;
    }
}

