/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.ArtifactFetcher;
import com.github.odavid.maven.plugins.Mixin;
import com.github.odavid.maven.plugins.MixinModelCache;
import com.github.odavid.maven.plugins.MixinModelMerger;
import com.github.odavid.maven.plugins.MixinModelProblemCollector;
import com.github.odavid.maven.plugins.Mixins;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.DefaultBeanConfigurationRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="MixinMavenLifecycleParticipant")
public class MixinMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_GROUPID = "com.github.odavid.maven.plugins";
    private static final String PLUGIN_ARTIFACTID = "mixin-maven-plugin";
    private final MavenXpp3Reader mavenXpp3reader = new MavenXpp3Reader();
    private final MixinModelMerger mixinModelMerger = new MixinModelMerger();
    @Requirement
    protected Logger logger;
    @Requirement
    private BeanConfigurator beanConfigurator;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Requirement
    private ProfileInjector profileInjector;
    @Requirement
    private ProfileSelector profileSelector;
    @Requirement
    private ArtifactFetcher artifactFetcher;
    private MixinModelCache mixinModelCache = new MixinModelCache();
    private DefaultModelBuildingRequest modelBuildingRequest;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        this.logger.info(String.format("%s: Merging Mixins", PLUGIN_ARTIFACTID));
        ProjectBuildingRequest projectBuildingRequest = mavenSession.getProjectBuildingRequest();
        this.modelBuildingRequest = new DefaultModelBuildingRequest();
        this.modelBuildingRequest.setActiveProfileIds(projectBuildingRequest.getActiveProfileIds());
        this.modelBuildingRequest.setInactiveProfileIds(projectBuildingRequest.getInactiveProfileIds());
        this.modelBuildingRequest.setBuildStartTime(projectBuildingRequest.getBuildStartTime());
        List projects = mavenSession.getProjects();
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>();
        HashMap<String, Mixin> mixinMap = new HashMap<String, Mixin>();
        for (MavenProject module : projects) {
            mixinList.clear();
            mixinMap.clear();
            this.mergeMixins(mixinList, mixinMap, module, mavenSession);
        }
        mavenSession.setProjects(projects);
        this.logger.info(String.format("%s: Mixins were merged", PLUGIN_ARTIFACTID));
    }

    private void fillMixins(List<Mixin> mixinList, Map<String, Mixin> mixinMap, Model model, MavenProject currentProject, MavenSession mavenSession) throws MavenExecutionException {
        Properties origProperties = (model = model.clone()).getProperties() != null ? model.getProperties() : new Properties();
        origProperties.putAll((Map<?, ?>)currentProject.getProperties());
        model.setProperties(origProperties);
        MixinModelProblemCollector problems = new MixinModelProblemCollector();
        this.modelInterpolator.interpolateModel(model, currentProject.getBasedir(), (ModelBuildingRequest)this.modelBuildingRequest, (ModelProblemCollector)problems);
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        List plugins = model.getBuild().getPlugins();
        for (Plugin plugin : plugins) {
            if (!plugin.getGroupId().equals(PLUGIN_GROUPID) || !plugin.getArtifactId().equals(PLUGIN_ARTIFACTID)) continue;
            Mixins mixins = this.loadConfiguration(plugin.getConfiguration());
            for (Mixin mixin : mixins.getMixins()) {
                if (mixinMap.containsKey(mixin.getKey())) continue;
                this.logger.debug(String.format("Adding mixin: %s to cache", mixin.getKey()));
                this.mixinModelCache.getModel(mixin, currentProject, mavenSession, this.mavenXpp3reader, this.artifactFetcher);
                mixinMap.put(mixin.getKey(), mixin);
                mixinList.add(mixin);
            }
            for (Mixin mixin : mixins.getMixins()) {
                if (!mixin.isRecurse()) continue;
                Model mixinModel = this.mixinModelCache.getModel(mixin, currentProject, mavenSession, this.mavenXpp3reader, this.artifactFetcher);
                this.fillMixins(mixinList, mixinMap, mixinModel, currentProject, mavenSession);
            }
        }
    }

    private DefaultProfileActivationContext getProfileActivationContext(MavenProject currentProject) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(this.modelBuildingRequest.getActiveProfileIds());
        context.setInactiveProfileIds(this.modelBuildingRequest.getInactiveProfileIds());
        context.setSystemProperties(this.modelBuildingRequest.getSystemProperties());
        context.setUserProperties(this.modelBuildingRequest.getUserProperties());
        context.setProjectDirectory(currentProject.getBasedir());
        return context;
    }

    private void mergeMixins(List<Mixin> mixinList, Map<String, Mixin> mixinMap, MavenProject currentProject, MavenSession mavenSession) throws MavenExecutionException {
        this.fillMixins(mixinList, mixinMap, currentProject.getModel(), currentProject, mavenSession);
        MixinModelProblemCollector problems = new MixinModelProblemCollector();
        HashSet<String> mixinProfiles = new HashSet<String>();
        for (Mixin mixin : mixinList) {
            this.logger.debug(String.format("Merging mixin: %s into %s", mixin.getKey(), currentProject.getFile()));
            Model mixinModel = this.mixinModelCache.getModel(mixin, currentProject, mavenSession, this.mavenXpp3reader, this.artifactFetcher);
            if (mixin.isActivateProfiles().booleanValue()) {
                this.logger.debug(String.format("Activating profiles in mixin: %s into %s", mixin.getKey(), currentProject.getFile()));
                mixinModel = mixinModel.clone();
                List activePomProfiles = this.profileSelector.getActiveProfiles((Collection)mixinModel.getProfiles(), (ProfileActivationContext)this.getProfileActivationContext(currentProject), (ModelProblemCollector)problems);
                for (Profile profile : activePomProfiles) {
                    this.logger.debug(String.format("Activating profile %s in mixin: %s into %s", profile.getId(), mixin.getKey(), currentProject.getFile()));
                    this.profileInjector.injectProfile(mixinModel, profile, (ModelBuildingRequest)this.modelBuildingRequest, (ModelProblemCollector)problems);
                    mixinProfiles.add(profile.getId());
                }
            }
            mixin.merge(mixinModel, currentProject, mavenSession, this.mixinModelMerger);
        }
        if (mixinList.size() > 0) {
            this.mixinModelMerger.applyPluginManagementOnPlugins(currentProject.getModel());
            this.modelInterpolator.interpolateModel(currentProject.getModel(), currentProject.getBasedir(), (ModelBuildingRequest)this.modelBuildingRequest, (ModelProblemCollector)problems);
            this.pluginConfigurationExpander.expandPluginConfiguration(currentProject.getModel(), (ModelBuildingRequest)this.modelBuildingRequest, (ModelProblemCollector)problems);
            if (currentProject.getInjectedProfileIds().containsKey("pom")) {
                ((List)currentProject.getInjectedProfileIds().get("pom")).addAll(mixinProfiles);
            } else {
                currentProject.getInjectedProfileIds().put("pom", new ArrayList(mixinProfiles));
            }
            problems.checkErrors(currentProject.getFile());
        }
    }

    private Mixins loadConfiguration(Object configuration) throws MavenExecutionException {
        Mixins mixins = new Mixins();
        DefaultBeanConfigurationRequest request = new DefaultBeanConfigurationRequest();
        request.setBean((Object)mixins);
        request.setConfiguration(configuration, "mixins");
        try {
            this.beanConfigurator.configureBean((BeanConfigurationRequest)request);
            return mixins;
        }
        catch (BeanConfigurationException e) {
            throw new MavenExecutionException("Cannot load mixins configuration: " + e.getMessage(), (Throwable)e);
        }
    }
}

