/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public final class XmlHelper {
    private static final Logger LOG = LogManager.getLogger(XmlHelper.class);

    private XmlHelper() {
    }

    public static void validate(String xmlString, String xsdResource) throws SAXException, IOException {
        StringReader reader = new StringReader(xmlString);
        StreamSource source = new StreamSource(reader);
        LOG.debug("validating " + xmlString + "...");
        XmlHelper.validate(source, xsdResource);
    }

    public static void validate(Source source, String xsdResource) throws SAXException, IOException {
        Schema schema = XmlHelper.getSchema(xsdResource);
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static Schema getSchema(String resource) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL xsdURL = XmlHelper.class.getResource(resource);
        return factory.newSchema(xsdURL);
    }

    public static Properties parseSimpleElements(QName name, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Parsing simple elements of <{}>...<{}/>.", (Object)name, (Object)name);
        Properties props = new Properties();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                XmlHelper.addAsProperty(event.asStartElement(), reader, props);
                continue;
            }
            if (!XmlHelper.isEndElement(event, name)) continue;
            LOG.debug("{} elements of <{}>...{} were returned as properties.", (Object)props.size(), (Object)name, (Object)event);
            return props;
        }
        throw new XMLStreamException("end element of <" + name + "> not read");
    }

    private static void addAsProperty(StartElement element, XMLEventReader reader, Properties props) throws XMLStreamException {
        QName name = element.getName();
        block5: while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 4: {
                    String key = name.getLocalPart();
                    String value = props.getProperty(key, "") + "\n" + event.asCharacters().getData().trim();
                    props.setProperty(key, value.trim());
                    continue block5;
                }
                case 2: {
                    return;
                }
                case 1: {
                    XmlHelper.ignore(event, reader);
                    continue block5;
                }
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("end element of <" + name + "> not read");
    }

    public static boolean isStartElement(XMLEvent event, String name) {
        if (event.isStartElement()) {
            return event.asStartElement().getName().getLocalPart().equals(name);
        }
        return false;
    }

    public static boolean isEndElement(XMLEvent event, QName name) {
        return event.isEndElement() && event.asEndElement().getName().equals(name);
    }

    public static StartElement getNextStartElement(String name, XMLEventReader reader) throws XMLStreamException {
        StartElement startElement;
        while (!name.equals((startElement = XmlHelper.getNextStartElement(reader)).getName().getLocalPart())) {
        }
        return startElement;
    }

    public static StartElement getNextStartElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                return event.asStartElement();
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("no start element found");
    }

    public static void ignore(XMLEvent startEvent, XMLEventReader reader) throws XMLStreamException {
        if (startEvent.isEndElement()) {
            LOG.debug("Element <{}/> is ignored.", (Object)startEvent);
            return;
        }
        XmlHelper.ignore(startEvent.asStartElement().getName(), reader);
    }

    public static void ignore(QName name, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!XmlHelper.isEndElement(event, name)) continue;
            LOG.debug("<{}>...{} was ignored.", (Object)name, (Object)event);
            return;
        }
        throw new XMLStreamException("end of <" + name + "> not found");
    }
}

