/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.config.ConfigException;
import gdv.xport.feld.Feld;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.util.AbstractFormatter;
import gdv.xport.util.ShitHappenedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Formatter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlFormatter
extends AbstractFormatter {
    private static final Logger LOG = LogManager.getLogger(XmlFormatter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private XMLStreamWriter xmlStreamWriter;

    public XmlFormatter() {
        this(System.out);
    }

    public XmlFormatter(Writer writer) {
        super(writer);
        try {
            this.xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException ex) {
            throw new ShitHappenedException("you should never see this", ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new ConfigException("XML problems", ex);
        }
    }

    public XmlFormatter(XMLStreamWriter xmlStreamWriter) {
        this.xmlStreamWriter = xmlStreamWriter;
    }

    public XmlFormatter(OutputStream ostream) {
        super(new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING));
        try {
            this.xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(ostream, Config.DEFAULT_ENCODING.name());
        }
        catch (XMLStreamException ex) {
            throw new ShitHappenedException("you should never see this", ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new ConfigException("XML problems", ex);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        try {
            this.xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter((OutputStream)new WriterOutputStream(writer, Config.DEFAULT_ENCODING), Config.DEFAULT_ENCODING.name());
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("can't create XmlStreamWriter with " + writer, ex);
        }
    }

    @Override
    public void setWriter(OutputStream ostream) {
        super.setWriter(ostream);
        try {
            this.xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(ostream, Config.DEFAULT_ENCODING.name());
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("can't create XmlStreamWriter with " + ostream, ex);
        }
    }

    public void write(Feld feld) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("feld");
        this.write("bytes", "%3d-%3d", feld.getByteAdresse(), feld.getEndAdresse());
        this.write("bezeichnung", "%-30.30s", feld.getBezeichnung());
        this.xmlStreamWriter.writeCharacters(feld.getInhalt());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.flush();
    }

    private void write(String attribute, String format, Object ... args) throws XMLStreamException {
        try (Formatter formatter = new Formatter();){
            String s = formatter.format(format, args).toString();
            this.xmlStreamWriter.writeAttribute(attribute, s);
        }
    }

    public void write(Teildatensatz teildatensatz) throws XMLStreamException {
        this.write(teildatensatz, 0);
    }

    private void write(Teildatensatz teildatensatz, int level) throws XMLStreamException {
        this.writeIndent(level);
        this.xmlStreamWriter.writeStartElement("teildatensatz");
        this.xmlStreamWriter.writeAttribute("nr", teildatensatz.getNummer().getInhalt());
        this.xmlStreamWriter.writeCharacters("\n");
        for (Feld feld : teildatensatz.getFelder()) {
            this.writeIndent(level + 1);
            this.write(feld);
            this.xmlStreamWriter.writeCharacters("\n");
        }
        this.writeIndent(level);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.flush();
    }

    @Override
    public void write(Satz satz) throws IOException {
        try {
            if (satz.getSatzart() == 1) {
                this.writeHead();
            }
            this.write(satz, 1);
            if (satz.getSatzart() == 9999) {
                this.writeTail();
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException("cannot format " + satz, ex);
        }
    }

    private void write(Satz satz, int level) throws XMLStreamException {
        this.writeIndent(level);
        this.xmlStreamWriter.writeStartElement("satz");
        this.xmlStreamWriter.writeAttribute("satzart", satz.getSatzartFeld().getInhalt());
        if (satz instanceof Datensatz) {
            Datensatz datensatz = (Datensatz)satz;
            this.xmlStreamWriter.writeAttribute("sparte", datensatz.getSparteFeld().getInhalt());
        }
        this.xmlStreamWriter.writeCharacters("\n");
        for (Teildatensatz teildatensatz : satz.getTeildatensaetze()) {
            this.write(teildatensatz, level + 1);
            this.xmlStreamWriter.writeCharacters("\n");
        }
        this.writeIndent(level);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters("\n");
        this.xmlStreamWriter.flush();
    }

    private void writeHead() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(Config.DEFAULT_ENCODING.name(), "1.0");
        this.xmlStreamWriter.writeCharacters("\n");
        this.xmlStreamWriter.writeStartElement("datenpaket");
        this.xmlStreamWriter.writeDefaultNamespace("http://labs.agentes.de");
        this.xmlStreamWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xmlStreamWriter.writeNamespace("schemaLocation", "https://raw.githubusercontent.com/oboehm/gdv.xport/master/lib/src/main/resources/xsd/datenpaket.xsd");
        this.xmlStreamWriter.writeCharacters("\n");
    }

    private void writeTail() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters("\n");
        this.xmlStreamWriter.writeComment(" (c)reated by gdv-xport at " + new Date() + " ");
        this.xmlStreamWriter.writeCharacters("\n");
        this.xmlStreamWriter.writeEndDocument();
        this.xmlStreamWriter.flush();
    }

    public static String toString(Feld feld) {
        StringWriter swriter = new StringWriter();
        XmlFormatter formatter = new XmlFormatter(swriter);
        try {
            formatter.write(feld);
        }
        catch (XMLStreamException shouldnothappen) {
            throw new ShitHappenedException("can't convert " + feld + " to String", shouldnothappen);
        }
        IOUtils.closeQuietly((Writer)swriter);
        return swriter.toString();
    }

    public static String toString(Teildatensatz teildatensatz) {
        StringWriter swriter = new StringWriter();
        XmlFormatter formatter = new XmlFormatter(swriter);
        try {
            formatter.write(teildatensatz);
        }
        catch (XMLStreamException shouldnothappen) {
            throw new ShitHappenedException("can't convert " + teildatensatz + " to String", shouldnothappen);
        }
        swriter.flush();
        IOUtils.closeQuietly((Writer)swriter);
        return swriter.toString();
    }

    public static String toString(Satz satz) {
        StringWriter swriter = new StringWriter();
        XmlFormatter formatter = new XmlFormatter(swriter);
        try {
            formatter.write(satz, 0);
        }
        catch (XMLStreamException ex) {
            LOG.warn("cannot format " + satz, (Throwable)ex);
            swriter.write("<!-- " + satz + " -->");
        }
        IOUtils.closeQuietly((Writer)swriter);
        return swriter.toString();
    }

    public static String toString(Datenpaket datenpaket) {
        StringWriter swriter = new StringWriter();
        XmlFormatter formatter = new XmlFormatter(swriter);
        try {
            formatter.write(datenpaket);
        }
        catch (IOException shouldnothappen) {
            throw new ShitHappenedException("can't convert " + datenpaket + " to String", shouldnothappen);
        }
        IOUtils.closeQuietly((Writer)swriter);
        return swriter.toString();
    }

    protected void writeIndent(int level) {
        try {
            for (int i = 0; i < level; ++i) {
                this.xmlStreamWriter.writeCharacters("  ");
            }
        }
        catch (XMLStreamException e) {
            LOG.warn("can't indent " + this, (Throwable)e);
        }
    }
}

