/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.config.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class URLReader {
    private static final Logger LOG = LogManager.getLogger(URLReader.class);
    private final URI url;

    public URLReader(URL url) {
        this(URI.create(url.toString()));
    }

    public URLReader(URI uri) {
        this.url = uri;
    }

    public String read() throws IOException {
        if (this.url.getScheme().equals("file")) {
            return this.readFile();
        }
        try {
            HttpClient httpClient = new HttpClient();
            GetMethod get = new GetMethod(this.url.toString());
            httpClient.executeMethod((HttpMethod)get);
            String content = get.getResponseBodyAsString();
            get.releaseConnection();
            return content;
        }
        catch (IllegalStateException ise) {
            LOG.info(ise + " - fallback to URLConnection");
            URLConnection connection = this.url.toURL().openConnection();
            return URLReader.read(connection);
        }
    }

    private String readFile() throws IOException {
        File file = new File(this.url);
        return FileUtils.readFileToString((File)file, (Charset)Config.DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(URLConnection connection) throws IOException {
        connection.connect();
        InputStream istream = connection.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(istream));
        try {
            StringBuilder sbuf = new StringBuilder();
            while (in.ready()) {
                String line = in.readLine();
                LOG.debug(line);
                sbuf.append(line);
                sbuf.append("\n");
            }
            String string = sbuf.toString().trim();
            return string;
        }
        finally {
            in.close();
            istream.close();
        }
    }
}

