/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import java.text.DecimalFormat;

public class SatzTyp {
    private final int satzart;
    private final int sparte;
    private final int wagnisart;
    private final int krankenFolgeNr;
    private final int teildatensatzNummer;

    public SatzTyp(int satzart) {
        this(satzart, -1);
    }

    public SatzTyp(int satzart, int sparte) {
        this(satzart, sparte, -1);
    }

    public SatzTyp(int satzart, int sparte, int wagnisart) {
        this(satzart, sparte, wagnisart, -1);
    }

    public SatzTyp(int satzart, int sparte, int wagnisart, int lfdNummer) {
        this(satzart, sparte, wagnisart, -1, lfdNummer);
    }

    public SatzTyp(int satzart, int sparte, int wagnisart, int krankenFolgeNr, int lfdNummer) {
        assert (0 <= satzart && satzart <= 9999) : "Satzart " + satzart + " muss zwischen 0 und 9999 liegen";
        assert (sparte == -1 || 0 <= sparte && sparte <= 999) : "Sparte " + sparte + " muss zwischen 0 und 999 liegen";
        assert (wagnisart == -1 || 0 <= wagnisart && wagnisart <= 9) : "Wagnisart " + wagnisart + " muss zwischen 0 und 9 liegen";
        assert (krankenFolgeNr == -1 || 1 <= krankenFolgeNr && krankenFolgeNr <= 3) : "Kranken Folge-Nr. " + krankenFolgeNr + " muss zwischen 1 und 3 liegen";
        assert (lfdNummer == -1 || 0 <= lfdNummer && lfdNummer <= 9) : "teildatensatzNummer " + lfdNummer + " muss zwischen 0 und 9 liegen";
        this.satzart = satzart;
        this.sparte = sparte;
        this.wagnisart = wagnisart;
        this.krankenFolgeNr = krankenFolgeNr;
        this.teildatensatzNummer = lfdNummer;
    }

    public int getSatzart() {
        return this.satzart;
    }

    public int getSparte() {
        return this.sparte;
    }

    public int getWagnisart() {
        return this.wagnisart;
    }

    public int getKrankenFolgeNr() {
        return this.krankenFolgeNr;
    }

    public int getTeildatensatzNummer() {
        return this.teildatensatzNummer;
    }

    public boolean hasSparte() {
        return this.sparte >= 0;
    }

    public boolean hasWagnisart() {
        return this.wagnisart >= 0;
    }

    public boolean hasKrankenFolgeNr() {
        return this.krankenFolgeNr >= 0;
    }

    public boolean hasTeildatensatzNummer() {
        return this.teildatensatzNummer >= 0;
    }

    public int hashCode() {
        return this.satzart * 10000000 + this.sparte * 10000 + this.wagnisart * 1000 + this.krankenFolgeNr * 100 + this.teildatensatzNummer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SatzTyp)) {
            return false;
        }
        SatzTyp other = (SatzTyp)obj;
        return this.satzart == other.satzart && this.sparte == other.sparte && this.wagnisart == other.wagnisart && this.krankenFolgeNr == other.krankenFolgeNr && this.teildatensatzNummer == other.teildatensatzNummer;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(new DecimalFormat("0000").format(this.satzart));
        if (this.sparte >= 0) {
            buf.append("." + new DecimalFormat("000").format(this.sparte));
            if (this.wagnisart >= 0) {
                buf.append(".");
                buf.append(this.wagnisart);
                if (this.teildatensatzNummer >= 0) {
                    buf.append(".");
                    buf.append(this.teildatensatzNummer);
                }
            } else if (this.krankenFolgeNr >= 0) {
                buf.append(".");
                buf.append(this.krankenFolgeNr);
            }
        }
        return buf.toString();
    }
}

