/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Nachsatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.satz.feld.common.TeildatensatzNummer;
import gdv.xport.satz.feld.sparte10.Feld220Wagnis0;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld221Wagnis48;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld221Wagnis5;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld221Wagnis5ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld221Wagnis6;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld221Wagnis6ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld221Wagnis7;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld221Wagnis7ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld230;
import gdv.xport.satz.feld.sparte51.Feld221;
import gdv.xport.satz.model.Satz211;
import gdv.xport.satz.model.Satz220;
import gdv.xport.satz.model.Satz221;
import gdv.xport.satz.model.Satz230;
import gdv.xport.satz.model.Satz250;
import gdv.xport.satz.model.SatzX;
import gdv.xport.satz.xml.SatzXml;
import gdv.xport.satz.xml.XmlService;
import gdv.xport.util.NotRegisteredException;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.ShitHappenedException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SatzFactory {
    private static final Logger LOG = LogManager.getLogger(SatzFactory.class);
    private static final Map<SatzTyp, Class<? extends Satz>> REGISTERED_SATZ_CLASSES = new ConcurrentHashMap<SatzTyp, Class<? extends Satz>>();
    private static final Map<SatzTyp, Class<? extends Datensatz>> REGISTERED_DATENSATZ_CLASSES = new ConcurrentHashMap<SatzTyp, Class<? extends Datensatz>>();
    private static final Map<SatzTyp, Class<? extends Enum>> REGISTERED_ENUM_CLASSES = new ConcurrentHashMap<SatzTyp, Class<? extends Enum>>();
    private static final XmlService XML_SERVICE = XmlService.getInstance();

    private SatzFactory() {
    }

    public static void register(Class<? extends Satz> clazz, int satzart) {
        try {
            Constructor<? extends Satz> ctor = clazz.getConstructor(new Class[0]);
            LOG.debug("Default constructor {} found.", ctor);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("no default constructor found in " + clazz, ex);
        }
        REGISTERED_SATZ_CLASSES.put(new SatzTyp(satzart), clazz);
    }

    public static void registerEnum(Class<? extends Enum> enumClass, int satzart) {
        SatzFactory.registerEnum(enumClass, new SatzTyp(satzart));
    }

    public static void registerEnum(Class<? extends Enum> enumClass, int satzart, int sparte) {
        SatzFactory.registerEnum(enumClass, new SatzTyp(satzart, sparte));
    }

    public static void registerEnum(Class<? extends Enum> enumClass, SatzTyp satzNr) {
        if (REGISTERED_DATENSATZ_CLASSES.containsKey(satzNr)) {
            LOG.info("Registered " + REGISTERED_DATENSATZ_CLASSES.get(satzNr) + " for " + satzNr + " will be replaced by " + enumClass);
            REGISTERED_DATENSATZ_CLASSES.remove(satzNr);
        }
        REGISTERED_ENUM_CLASSES.put(satzNr, enumClass);
    }

    public static void unregister(int satzart) {
        SatzTyp key = new SatzTyp(satzart);
        REGISTERED_SATZ_CLASSES.remove(key);
        REGISTERED_ENUM_CLASSES.remove(key);
    }

    public static void register(Class<? extends Datensatz> clazz, int satzart, int sparte) {
        SatzFactory.register(clazz, new SatzTyp(satzart, sparte));
    }

    public static void register(Class<? extends Datensatz> clazz, SatzTyp satzNr) {
        REGISTERED_DATENSATZ_CLASSES.put(satzNr, clazz);
    }

    public static void unregister(int satzart, int sparte) {
        SatzFactory.unregister(satzart, sparte, -1);
    }

    public static void unregister(int satzart, int sparte, int wagnisart) {
        SatzTyp key = new SatzTyp(satzart, sparte, wagnisart, -1);
        REGISTERED_DATENSATZ_CLASSES.remove(key);
        REGISTERED_ENUM_CLASSES.remove(key);
    }

    public static Satz getSatz(int satzart) {
        return SatzFactory.getSatz(new SatzTyp(satzart));
    }

    public static Satz getSatz(SatzTyp satztyp) {
        Class<? extends Satz> clazz = REGISTERED_SATZ_CLASSES.get(new SatzTyp(satztyp.getSatzart()));
        if (clazz == null) {
            return SatzFactory.generateSatz(satztyp);
        }
        try {
            Satz satz = clazz.newInstance();
            if (satz.getSatzart() != satztyp.getSatzart()) {
                Constructor<? extends Satz> ctor = clazz.getConstructor(Integer.TYPE);
                satz = ctor.newInstance(satztyp.getSatzart());
            }
            return satz;
        }
        catch (Exception e) {
            LOG.info("default constructor does not work (" + e + "), trying another ctor...");
            Constructor<? extends Satz> ctor = null;
            try {
                ctor = clazz.getConstructor(Integer.TYPE);
                return ctor.newInstance(satztyp.getSatzart());
            }
            catch (InvocationTargetException ite) {
                throw new ShitHappenedException(ite.getTargetException() + " in " + ctor, ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedOperationException("registered " + clazz + " has not the required ctor", nsme);
            }
            catch (InstantiationException ie) {
                throw new ShitHappenedException("registered " + clazz + " can't be instantiated", ie);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("registered " + clazz + " can't be accessed", iae);
            }
        }
    }

    private static Satz generateSatz(SatzTyp satztyp) {
        Class<? extends Enum> enumClass = REGISTERED_ENUM_CLASSES.get(satztyp);
        if (enumClass == null) {
            SatzXml satz = XML_SERVICE.getSatzart(satztyp);
            if (satz == null) {
                throw new NotRegisteredException(satztyp);
            }
            try {
                return (Satz)satz.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("Cannot clone {} - will return object itself.", (Object)satz);
                return satz;
            }
        }
        return new SatzX(satztyp, enumClass);
    }

    private static Datensatz generateDatensatz(SatzTyp satzNr) {
        Class<? extends Enum> enumClass = REGISTERED_ENUM_CLASSES.get(satzNr);
        if (enumClass != null) {
            return new SatzX(satzNr, enumClass);
        }
        LOG.trace("Will use fallback for Satz {}:", (Object)satzNr);
        return SatzFactory.useFallback(satzNr);
    }

    public static Satz getSatz(String content) {
        Satz satz;
        int satzart = Integer.parseInt(content.substring(0, 4));
        try {
            satz = SatzFactory.getSatz(satzart);
        }
        catch (RuntimeException e) {
            LOG.debug("can't get Satz " + satzart + " (" + e + "), parsing Sparte...");
            int sparte = Integer.parseInt(content.substring(10, 13));
            satz = SatzFactory.getDatensatz(satzart, sparte);
        }
        try {
            satz.importFrom(content);
            return satz;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't parse " + content, ioe);
        }
    }

    public static Datensatz getDatensatz(int satzart) {
        return (Datensatz)SatzFactory.getSatz(satzart);
    }

    public static Datensatz getDatensatz(int satzart, int sparte) {
        return SatzFactory.getDatensatz(new SatzTyp(satzart, sparte));
    }

    public static Datensatz getDatensatz(int satzart, int sparte, int wagnisart) {
        return SatzFactory.getDatensatz(new SatzTyp(satzart, sparte, wagnisart));
    }

    public static Datensatz getDatensatz(SatzTyp satzNr) {
        Class<? extends Datensatz> clazz = REGISTERED_DATENSATZ_CLASSES.get(satzNr);
        if (clazz == null) {
            return SatzFactory.generateDatensatz(satzNr);
        }
        try {
            Constructor<? extends Datensatz> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            return ctor.newInstance(satzNr.getSatzart(), satzNr.getSparte());
        }
        catch (NoSuchMethodException exWithTwoParams) {
            LOG.info("constructor " + clazz + "(int, int) not found (" + exWithTwoParams + ")");
            return SatzFactory.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (InstantiationException exWithTwoParams) {
            LOG.info(clazz + "(int, int) can't be instantiated (" + exWithTwoParams + ")");
            return SatzFactory.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (IllegalAccessException exWithTwoParams) {
            LOG.info(clazz + "(int, int) can't be accessed (" + exWithTwoParams + ")");
            return SatzFactory.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (InvocationTargetException exWithTwoParams) {
            LOG.info("error in calling " + clazz + "(int, int): " + exWithTwoParams);
            return SatzFactory.getDatensatz(satzNr.getSparte(), clazz);
        }
    }

    private static Datensatz getDatensatz(int sparte, Class<? extends Datensatz> clazz) {
        try {
            Constructor<? extends Datensatz> ctor = clazz.getConstructor(Integer.TYPE);
            return ctor.newInstance(sparte);
        }
        catch (NoSuchMethodException nsme) {
            LOG.info(clazz + " found but no " + clazz.getSimpleName() + "(" + sparte + ") constructor (" + nsme + ")");
            return SatzFactory.getDatensatz(clazz);
        }
        catch (Exception exWithOneParam) {
            LOG.warn("constructor problem with " + clazz, (Throwable)exWithOneParam);
            return SatzFactory.getDatensatz(clazz);
        }
    }

    private static Datensatz getDatensatz(Class<? extends Datensatz> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("can't instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("can't access default constructor of " + clazz, e);
        }
    }

    private static Datensatz useFallback(SatzTyp satzNr) {
        try {
            Datensatz fallback = (Datensatz)SatzFactory.getSatz(satzNr);
            if (satzNr.hasSparte()) {
                fallback.setSparte(satzNr.getSparte());
            }
            if (fallback.hasFeld(Bezeichner.UNBEKANNT)) {
                try {
                    return (Datensatz)SatzFactory.generateSatz(satzNr);
                }
                catch (NotRegisteredException ex) {
                    LOG.warn("XML-Fallback has " + satzNr + " not registered: " + ex);
                }
            }
            return fallback;
        }
        catch (NotRegisteredException re) {
            LOG.warn("Reduced functionality for (unknown or unsupported) Satzart " + satzNr + ":", (Throwable)re);
            Datensatz satz = new Datensatz(satzNr.getSatzart(), satzNr.getSparte());
            satz.addFiller();
            return satz;
        }
    }

    public static Datenpaket getAllSupportedSaetze() {
        Datenpaket all = new Datenpaket();
        for (int i = 2; i < 9999; ++i) {
            try {
                all.add((Datensatz)SatzFactory.getSatz(i));
                continue;
            }
            catch (NotRegisteredException ex) {
                LOG.trace("Datensatz " + i + " is not a supported: ", (Throwable)ex);
            }
        }
        return all;
    }

    static {
        SatzFactory.register(Vorsatz.class, 1);
        SatzFactory.register(Satz211.class, 211);
        SatzFactory.register(Satz220.class, 220);
        SatzFactory.register(Satz221.class, 221);
        SatzFactory.register(Satz230.class, 230);
        SatzFactory.register(Satz250.class, 250);
        SatzFactory.register(Nachsatz.class, 9999);
        SatzFactory.registerEnum(Feld220Wagnis0.class, new SatzTyp(220, 10, 0));
        SatzFactory.registerEnum(Feld220Wagnis13.class, new SatzTyp(220, 10, 1));
        SatzFactory.registerEnum(Feld220Wagnis13.class, new SatzTyp(220, 10, 3));
        SatzFactory.registerEnum(Feld220Wagnis13Auszahlungen.class, new SatzTyp(220, 10, 1, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13Auszahlungen.class, new SatzTyp(220, 10, 3, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13Bezugsrechte.class, new SatzTyp(220, 10, 1, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13Bezugsrechte.class, new SatzTyp(220, 10, 3, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13ZukSummenaenderungen.class, new SatzTyp(220, 10, 1, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13ZukSummenaenderungen.class, new SatzTyp(220, 10, 3, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13Wertungssummen.class, new SatzTyp(220, 10, 1, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis13Wertungssummen.class, new SatzTyp(220, 10, 3, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis13.class, new SatzTyp(221, 10, 1));
        SatzFactory.registerEnum(Feld221Wagnis13.class, new SatzTyp(221, 10, 3));
        SatzFactory.registerEnum(Feld221Wagnis13Auszahlungen.class, new SatzTyp(221, 10, 1, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis13Auszahlungen.class, new SatzTyp(221, 10, 3, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis13ZukSummenaenderungen.class, new SatzTyp(221, 10, 1, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis13ZukSummenaenderungen.class, new SatzTyp(221, 10, 3, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis2.class, new SatzTyp(220, 10, 2));
        SatzFactory.registerEnum(Feld220Wagnis2Bezugsrechte.class, new SatzTyp(220, 10, 2, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis2Auszahlungen.class, new SatzTyp(220, 10, 2, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis2Wertungssummen.class, new SatzTyp(220, 10, 2, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis2ZukSummenaenderungen.class, new SatzTyp(220, 10, 2, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis2.class, new SatzTyp(221, 10, 2));
        SatzFactory.registerEnum(Feld221Wagnis2Auszahlungen.class, new SatzTyp(221, 10, 2, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis2ZukSummenaenderungen.class, new SatzTyp(221, 10, 2, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48.class, new SatzTyp(220, 10, 4));
        SatzFactory.registerEnum(Feld220Wagnis48.class, new SatzTyp(220, 10, 8));
        SatzFactory.registerEnum(Feld220Wagnis48Bezugsrechte.class, new SatzTyp(220, 10, 4, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48Bezugsrechte.class, new SatzTyp(220, 10, 8, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48Wertungssummen.class, new SatzTyp(220, 10, 4, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48Wertungssummen.class, new SatzTyp(220, 10, 8, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48ZukSummenaenderungen.class, new SatzTyp(220, 10, 4, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis48ZukSummenaenderungen.class, new SatzTyp(220, 10, 8, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis48.class, new SatzTyp(221, 10, 4));
        SatzFactory.registerEnum(Feld221Wagnis48.class, new SatzTyp(221, 10, 8));
        SatzFactory.registerEnum(Feld220Wagnis5.class, new SatzTyp(220, 10, 5));
        SatzFactory.registerEnum(Feld220Wagnis5Bezugsrechte.class, new SatzTyp(220, 10, 5, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis5Wertungssummen.class, new SatzTyp(220, 10, 5, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis5ZukSummenaenderungen.class, new SatzTyp(220, 10, 5, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis5.class, new SatzTyp(221, 10, 5));
        SatzFactory.registerEnum(Feld221Wagnis5ZukSummenaenderungen.class, new SatzTyp(221, 10, 5, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis6.class, new SatzTyp(220, 10, 6));
        SatzFactory.registerEnum(Feld220Wagnis6Bezugsrechte.class, new SatzTyp(220, 10, 6, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis6Wertungssummen.class, new SatzTyp(220, 10, 6, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis6ZukSummenaenderungen.class, new SatzTyp(220, 10, 6, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis6.class, new SatzTyp(221, 10, 6));
        SatzFactory.registerEnum(Feld221Wagnis6ZukSummenaenderungen.class, new SatzTyp(221, 10, 6, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis7.class, new SatzTyp(220, 10, 7));
        SatzFactory.registerEnum(Feld220Wagnis7Bezugsrechte.class, new SatzTyp(220, 10, 7, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis7Wertungssummen.class, new SatzTyp(220, 10, 7, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis7ZukSummenaenderungen.class, new SatzTyp(220, 10, 7, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221Wagnis7.class, new SatzTyp(221, 10, 7));
        SatzFactory.registerEnum(Feld221Wagnis7ZukSummenaenderungen.class, new SatzTyp(221, 10, 7, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld230.class, new SatzTyp(230, 10, 7));
        SatzFactory.registerEnum(Feld220Wagnis9.class, new SatzTyp(220, 10, 9));
        SatzFactory.registerEnum(Feld220Wagnis9Bezugsrechte.class, new SatzTyp(220, 10, 9, TeildatensatzNummer.BEZUGSRECHTE.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis9Auszahlungen.class, new SatzTyp(220, 10, 9, TeildatensatzNummer.AUSZAHLUNGEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis9Wertungssummen.class, new SatzTyp(220, 10, 9, TeildatensatzNummer.WERTUNGSSUMMEN.getCode()));
        SatzFactory.registerEnum(Feld220Wagnis9ZukSummenaenderungen.class, new SatzTyp(220, 10, 9, TeildatensatzNummer.ZUKUENFTIGE_SUMMENAENDERUNG.getCode()));
        SatzFactory.registerEnum(Feld221.class, new SatzTyp(221, 51));
    }
}

