/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.SatzXml;
import gdv.xport.util.NotRegisteredException;
import gdv.xport.util.NotUniqueException;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.XmlHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.log.LogWatch;

public class XmlService {
    private static final Logger LOG = LogManager.getLogger(XmlService.class);
    private static final Map<String, XmlService> INSTANCES = new WeakHashMap<String, XmlService>();
    private final List<SatzXml> saetze = new ArrayList<SatzXml>();
    private final Map<SatzTyp, SatzXml> satzarten = new HashMap<SatzTyp, SatzXml>();
    private final Map<String, FeldXml> felder = new HashMap<String, FeldXml>();

    public static XmlService getInstance() {
        try {
            return XmlService.getInstance("VUVM2018.xml");
        }
        catch (XMLStreamException ex) {
            LOG.error("Cannot parse XML from resource 'VUVM2018.xml':", (Throwable)ex);
            return new XmlService();
        }
    }

    public static XmlService getInstance(String resource) throws XMLStreamException {
        XmlService service = INSTANCES.get(resource);
        if (service == null) {
            try (XMLEventReader parser = XmlService.createXMLEventReader(resource);){
                service = new XmlService(parser);
                INSTANCES.put(resource, service);
            }
        }
        return service;
    }

    private static XMLEventReader createXMLEventReader(String resourceName) throws XMLStreamException {
        InputStream istream = XmlService.class.getResourceAsStream(resourceName);
        if (istream == null) {
            throw new XMLStreamException("resource '" + resourceName + "' not found");
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory.createXMLEventReader(istream);
    }

    private XmlService() {
        LOG.debug("Default XmlService created.");
    }

    public XmlService(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement(parser));
    }

    public XmlService(XMLEventReader parser, StartElement startElement) throws XMLStreamException {
        this.parse(startElement, parser);
    }

    private void parse(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LogWatch watch = new LogWatch();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.parseElement(event.asStartElement(), reader);
            } else if (XmlHelper.isEndElement(event, element.getName())) {
                LOG.info("{} Satzarten successful parsed from {}...{} in {}.", (Object)this.saetze.size(), (Object)element, (Object)event, (Object)watch);
                return;
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseElement(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Parsing element {}.", (Object)element);
        QName name = element.getName();
        if ("satzarten".equals(name.getLocalPart())) {
            this.parseSatzarten(element, reader);
        } else if ("felder".equals(name.getLocalPart())) {
            this.felder.putAll(XmlService.parseFelder(element, reader));
            this.setFelder(this.felder);
        } else {
            XmlHelper.ignore(name, reader);
        }
    }

    private void parseSatzarten(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "satzart")) {
                SatzXml satz = new SatzXml(reader, event.asStartElement());
                this.saetze.add(satz);
                LOG.debug("Satz {} added .", (Object)satz);
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.debug("{} satzarten successful parsed.", (Object)this.satzarten.size());
            return;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    public static Map<String, FeldXml> parseFelder(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "felder")) {
                return XmlService.parseFelder(event.asStartElement(), reader);
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("<felder>...</felder> not found");
    }

    private static Map<String, FeldXml> parseFelder(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Element {} will be parsed.", (Object)element);
        HashMap<String, FeldXml> felder = new HashMap<String, FeldXml>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                FeldXml feld = new FeldXml(reader, event.asStartElement());
                felder.put(feld.getId(), feld);
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.debug("{} felder between {}...{} successful parsed.", (Object)felder.size(), (Object)element, (Object)event);
            return felder;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    public Map<String, FeldXml> getFelder() {
        return this.felder;
    }

    private void setFelder(Map<String, FeldXml> felder) {
        LOG.debug("Missing felder for {} saetze will be set.", (Object)this.satzarten.size());
        for (SatzXml satz : this.saetze) {
            satz.setFelder(felder);
            this.registerSatzart(satz);
        }
    }

    private void registerSatzart(SatzXml satz) {
        List<SatzTyp> supportedSatzTypen = satz.getSupportedSatzTypen();
        if (supportedSatzTypen.isEmpty()) {
            this.satzarten.put(new SatzTyp(satz.getSatzart()), satz);
        } else {
            for (SatzTyp type : supportedSatzTypen) {
                this.satzarten.put(type, satz);
                LOG.trace("Satz {} registered as {}.", (Object)satz, (Object)type);
            }
        }
    }

    public SatzXml getSatzart(int satzart) {
        SatzXml satz = this.satzarten.get(new SatzTyp(satzart));
        if (satz != null) {
            return new SatzXml(satz);
        }
        ArrayList<SatzTyp> satzTypen = new ArrayList<SatzTyp>();
        for (SatzTyp satzNr : this.satzarten.keySet()) {
            if (satzNr.getSatzart() != satzart) continue;
            satzTypen.add(satzNr);
        }
        if (satzTypen.isEmpty()) {
            throw new NotRegisteredException(satzart);
        }
        if (satzTypen.size() > 1) {
            XmlService.checkSatzarten(satzTypen);
        }
        return new SatzXml(this.satzarten.get(satzTypen.get(0)));
    }

    private static void checkSatzarten(List<SatzTyp> satzTypen) {
        SatzTyp first = satzTypen.get(0);
        for (int i = 1; i < satzTypen.size(); ++i) {
            if (first.getSparte() == satzTypen.get(i).getSparte()) continue;
            throw new NotUniqueException("Sparte for Satzart " + first.getSatzart() + " is missing: " + satzTypen);
        }
    }

    public SatzXml getSatzart(SatzTyp satzNr) {
        SatzXml satz = this.satzarten.get(satzNr);
        if (satz == null) {
            satz = this.getSatzart(satzNr.getSatzart());
        }
        if (satz == null) {
            throw new NotRegisteredException(satzNr);
        }
        return satz;
    }

    public Map<SatzTyp, SatzXml> getSatzarten() {
        return this.satzarten;
    }
}

