/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.xml.FeldReferenz;
import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.Satzende;
import gdv.xport.satz.xml.XmlService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TeildatensatzXml
extends Teildatensatz {
    private static final Logger LOG = LogManager.getLogger(TeildatensatzXml.class);
    private static final Map<String, FeldXml> MISSING_FELDER = new HashMap<String, FeldXml>();
    private final List<FeldReferenz> feldReferenzen = new ArrayList<FeldReferenz>();
    private Satzende satzende;

    public TeildatensatzXml(int satzart, int nr) {
        super(satzart, nr);
    }

    public void add(FeldReferenz referenz) {
        this.feldReferenzen.add(referenz);
    }

    public void setSatzende(Satzende satzende) {
        this.satzende = satzende;
    }

    public void updateWith(Map<String, FeldXml> felder) {
        int byteAddress = 1;
        for (FeldReferenz referenz : this.feldReferenzen) {
            FeldXml feldXml = this.getFeld(felder, referenz.getId());
            this.addFeld(feldXml, byteAddress, referenz.getBezeichner());
            byteAddress += feldXml.getAnzahlBytes();
        }
        this.updateSatzendeWith(byteAddress, felder);
        LOG.trace("{} felder set.", (Object)this.feldReferenzen.size());
    }

    private FeldXml getFeld(Map<String, FeldXml> felder, String id) {
        FeldXml feldXml = felder.get(id);
        if (feldXml == null) {
            LOG.info("Will try fallback for reference '{}'.", (Object)id);
            feldXml = MISSING_FELDER.get(id);
        }
        if (feldXml == null) {
            throw new IllegalArgumentException("reference '" + id + "' not found in " + felder);
        }
        return feldXml;
    }

    private void updateSatzendeWith(int startAddress, Map<String, FeldXml> felder) {
        List<FeldReferenz> referenzen = this.satzende.getFeldReferenzen();
        int endAddress = 256;
        for (int i = referenzen.size() - 1; i >= 0; --i) {
            FeldReferenz referenz = referenzen.get(i);
            FeldXml feldXml = felder.get(referenz.getId());
            this.addFeld(feldXml, (endAddress -= feldXml.getAnzahlBytes()) + 1, referenz.getBezeichner());
        }
        int length = endAddress + 1 - startAddress;
        if (length > 0) {
            AlphaNumFeld leerstelle = new AlphaNumFeld(Bezeichner.LEERSTELLEN, endAddress + 1 - startAddress, startAddress);
            this.add(leerstelle);
        }
    }

    private void addFeld(FeldXml feldXml, int byteAddress, Bezeichner bezeichner) {
        Feld feld = feldXml.toFeld(byteAddress, bezeichner);
        if (!this.hasFeld(feld)) {
            super.add(feld);
        } else {
            LOG.trace("{} not added again.", (Object)feld);
        }
    }

    public FeldReferenz getFeldRefenz(Bezeichner bezeichner) {
        for (FeldReferenz ref : this.feldReferenzen) {
            if (!bezeichner.equals(ref.getBezeichner())) continue;
            return ref;
        }
        throw new IllegalArgumentException(bezeichner + " not part of " + this);
    }

    static {
        try {
            MISSING_FELDER.putAll(XmlService.getInstance("fehlendeFelder.xml").getFelder());
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("cannot get missing felder from resource 'fehlendeFelder.xml'", ex);
        }
    }
}

