/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.xml.FeldReferenz;
import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.Satzende;
import gdv.xport.satz.xml.TeildatensatzXml;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SatzXml
extends Datensatz {
    private static final Logger LOG = LogManager.getLogger(SatzXml.class);

    public SatzXml(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement("satzart", parser));
    }

    public SatzXml(XMLEventReader parser, StartElement element) throws XMLStreamException {
        super(0);
        this.parse(element, parser);
    }

    public SatzXml(Datensatz orig) {
        super(orig);
    }

    @Override
    protected void setUpTeildatensaetze() {
        this.removeAllTeildatensaetze();
    }

    private void parse(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.parseElement(event.asStartElement(), reader);
            } else if (XmlHelper.isEndElement(event, element.getName())) {
                LOG.debug("{}...{} successful parsed.", (Object)element, (Object)event);
                return;
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseElement(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Parsing element {}.", (Object)element);
        QName name = element.getName();
        if ("satzanfang".equals(name.getLocalPart())) {
            this.parseTeildatensatz(element, reader);
        } else if ("feldreferenz".equals(name.getLocalPart())) {
            this.parseFeldreferenz(element, reader);
        }
    }

    private void parseTeildatensatz(StartElement element, XMLEventReader reader) throws XMLStreamException {
        TeildatensatzXml tds = this.parseSatzanfang(element, reader);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "feldreferenz")) {
                tds.add(new FeldReferenz(reader, event.asStartElement()));
                continue;
            }
            if (!XmlHelper.isStartElement(event, "satzende")) continue;
            LOG.trace("<{}> is reached.", (Object)element);
            tds.setSatzende(new Satzende(reader, event.asStartElement()));
            this.add(tds);
            return;
        }
        throw new XMLStreamException("<satzende> for " + element + " not found");
    }

    private TeildatensatzXml parseSatzanfang(StartElement element, XMLEventReader reader) throws XMLStreamException {
        Attribute teilsatz = element.getAttributeByName(new QName("teilsatz"));
        int nr = Integer.parseInt(teilsatz.getValue());
        TeildatensatzXml tds = new TeildatensatzXml(this.getSatzart(), nr);
        LOG.debug("Teildatensatz {} added to {}.", (Object)nr, (Object)this);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "feldreferenz")) {
                tds.add(new FeldReferenz(reader, event.asStartElement()));
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.trace("End of <{}> is reached.", (Object)element);
            return tds;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseFeldreferenz(StartElement element, XMLEventReader reader) throws XMLStreamException {
        FeldReferenz referenz = new FeldReferenz(reader, element);
        if (referenz.hasAuspraegung()) {
            if ("Satzart".equals(referenz.getName())) {
                this.getSatzartFeld().setInhalt(referenz.getAuspraegung());
            } else if ("Sparte".equals(referenz.getName())) {
                this.setSparte(referenz.getAuspraegung());
            }
        }
    }

    public void setFelder(Map<String, FeldXml> felder) {
        LOG.trace("Setting missing felder infos to {}.", (Object)this);
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            TeildatensatzXml tdsXml = (TeildatensatzXml)tds;
            tdsXml.updateWith(felder);
        }
    }

    public List<SatzTyp> getSupportedSatzTypen() {
        ArrayList<SatzTyp> satzTypen = new ArrayList<SatzTyp>();
        if (this.hasWagnisart()) {
            TeildatensatzXml tdsXml = (TeildatensatzXml)this.getTeildatensatz(1);
            FeldReferenz feldReferenz = tdsXml.getFeldRefenz(Bezeichner.WAGNISART);
            for (String value : feldReferenz.getDefaultWerte()) {
                satzTypen.add(new SatzTyp(this.getSatzart(), this.getSparte(), Integer.parseInt(value)));
            }
        } else if (this.hasKrankenFolgeNr()) {
            FeldReferenz feldReferenz;
            TeildatensatzXml tdsXml = (TeildatensatzXml)this.getTeildatensatz(1);
            FeldReferenz feldReferenz2 = feldReferenz = this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF) ? tdsXml.getFeldRefenz(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF) : tdsXml.getFeldRefenz(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF);
            if (feldReferenz.getBemerkung().contains("mit \"1\" belegt")) {
                satzTypen.add(new SatzTyp(this.getSatzart(), this.getSparte(), -1, 1, -1));
            } else if (feldReferenz.getBemerkung().contains("mit \"2\" belegt")) {
                satzTypen.add(new SatzTyp(this.getSatzart(), this.getSparte(), -1, 2, -1));
            } else if (feldReferenz.getBemerkung().contains("mit \"3\" belegt")) {
                satzTypen.add(new SatzTyp(this.getSatzart(), this.getSparte(), -1, 3, -1));
            } else {
                LOG.error("Expected Folge-Nr. Bemerkung containing 'mit \"X\"X belegt' for Satzart 220, Sparte 20, Feld 10 with X being 1, 2 or 3, but got " + feldReferenz.getBemerkung());
                satzTypen.add(this.getSatzTyp());
            }
        } else {
            satzTypen.add(this.getSatzTyp());
        }
        return satzTypen;
    }
}

