/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datentyp;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.util.XmlHelper;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FeldXml
extends Feld {
    private static final Logger LOG = LogManager.getLogger(FeldXml.class);
    private final String id;
    private final Datentyp datentyp;
    private final int nachkommastellen;

    public FeldXml(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement(parser));
    }

    public FeldXml(XMLEventReader parser, StartElement element) throws XMLStreamException {
        this(FeldXml.parse(parser, element));
    }

    private FeldXml(Properties props) {
        super(new Bezeichner(props), Integer.parseInt(props.getProperty("bytes", "1")), 0, Align.UNKNOWN);
        this.id = props.getProperty("ID");
        this.datentyp = Datentyp.asValue(props.getProperty("datentyp"));
        this.nachkommastellen = Integer.parseInt(props.getProperty("nachkommastellen", "0"));
        LOG.debug("{} created.", (Object)this);
    }

    private static Properties parse(XMLEventReader parser, StartElement element) throws XMLStreamException {
        String xid = element.getAttributeByName(new QName("referenz")).getValue();
        LOG.trace("Parsing <feld referenz=\"{}\"...", (Object)xid);
        Properties props = XmlHelper.parseSimpleElements(element.getName(), parser);
        props.put("ID", xid);
        return props;
    }

    public String getId() {
        return this.id;
    }

    public final Datentyp getDatentyp() {
        return this.datentyp;
    }

    public final int getNachkommastellen() {
        return this.nachkommastellen;
    }

    public Feld toFeld(int byteAddress) {
        return this.toFeld(byteAddress, this.getBezeichner());
    }

    public Feld toFeld(int byteAddress, Bezeichner neuerBezeichner) {
        Bezeichner merged = this.getBezeichner().mergeWith(neuerBezeichner);
        switch (this.datentyp) {
            case NUMERISCH: 
            case FLIESSKOMMA: {
                return new NumFeld(merged, this.getAnzahlBytes(), byteAddress).mitNachkommastellen(this.nachkommastellen);
            }
        }
        return this.datentyp.asFeld(merged, this.getAnzahlBytes(), byteAddress);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " \"" + this.id + "\" (" + this.getBezeichner() + ")";
    }
}

