/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.model;

import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.feld.FeldX;
import gdv.xport.satz.feld.common.TeildatensatzNummer;
import gdv.xport.satz.feld.common.WagnisartLeben;
import gdv.xport.util.SatzTyp;
import java.io.IOException;
import java.util.List;

public class SatzX
extends Datensatz {
    public SatzX(int satzart, Enum[] felder) {
        super(satzart, SatzX.getTeildatensaetzeFor(satzart, felder));
    }

    public SatzX(int satzart, Class<? extends Enum> enumClass) {
        super(satzart, SatzX.getTeildatensaetzeFor(satzart, enumClass));
    }

    public SatzX(int satzart, int sparte, Enum[] felder) {
        super(satzart, sparte, SatzX.getTeildatensaetzeFor(satzart, felder));
    }

    public SatzX(int satzart, int sparte, Class<? extends Enum> enumClass) {
        super(satzart, sparte, SatzX.getTeildatensaetzeFor(satzart, enumClass));
    }

    public SatzX(int satzart, int sparte) {
        this(satzart, sparte, FeldX.values());
    }

    public SatzX(SatzTyp satzNr, Class<? extends Enum> enumClass) {
        super(satzNr, SatzX.getTeildatensaetzeFor(satzNr.getSatzart(), enumClass));
    }

    private static List<Teildatensatz> getTeildatensaetzeFor(int satzart, Class<? extends Enum> enumClass) {
        Enum[] constants = enumClass.getEnumConstants();
        return SatzX.getTeildatensaetzeFor(satzart, constants);
    }

    protected void setUpTeildatensaetze(Enum[] felder) {
        super.createTeildatensaetze(SatzX.getTeildatensaetzeFor(this.getSatzart(), felder));
        super.completeTeildatensaetze();
    }

    @Override
    protected boolean matchesNextTeildatensatz(PushbackLineNumberReader reader, char[] lastFeld1To7, Character satznummer) throws IOException {
        if (super.matchesNextTeildatensatz(reader, lastFeld1To7, satznummer)) {
            boolean currentLineTeildatensatzNummerIsSet;
            WagnisartLeben nextLineWagnisEnum = SatzX.readWagnisart(reader);
            TeildatensatzNummer nextLineTeildatensatzNummerEnum = SatzX.readTeildatensatzNummer(reader);
            boolean nextLineWagnisartIsSet = nextLineWagnisEnum != WagnisartLeben.NULL;
            boolean nextLineTeildatensatzNummerIsSet = nextLineTeildatensatzNummerEnum != TeildatensatzNummer.NULL;
            boolean currentLineWagnisartIsSet = this.hasWagnisart() && this.getWagnisart().trim().length() > 0;
            boolean bl = currentLineTeildatensatzNummerIsSet = this.getTeildatensatzNummer().trim().length() > 0;
            if (!currentLineWagnisartIsSet) {
                return true;
            }
            TeildatensatzNummer currentLineTeildatensatzEnum = TeildatensatzNummer.NULL;
            if (currentLineTeildatensatzNummerIsSet) {
                currentLineTeildatensatzEnum = TeildatensatzNummer.isIn(Integer.parseInt(this.getTeildatensatzNummer()));
            }
            if (nextLineWagnisartIsSet && nextLineWagnisEnum == WagnisartLeben.isIn(Integer.parseInt(this.getWagnisart()))) {
                if (currentLineTeildatensatzNummerIsSet || nextLineTeildatensatzNummerIsSet) {
                    return nextLineTeildatensatzNummerEnum == currentLineTeildatensatzEnum;
                }
                return true;
            }
        }
        return false;
    }
}

