/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.model;

import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld221Wagnis13ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld221Wagnis2ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld221Wagnis48;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld221Wagnis5;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld221Wagnis5ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld221Wagnis6;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld221Wagnis6ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld221Wagnis7;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld221Wagnis7ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte30.Feld221;
import gdv.xport.satz.model.Satz220;
import gdv.xport.satz.model.SatzX;
import gdv.xport.satz.model.SpartensatzX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Satz221
extends SpartensatzX {
    private static final Logger LOG = LogManager.getLogger(Satz221.class);
    private static final Map<Integer, Enum[]> MAPPING = new HashMap<Integer, Enum[]>();
    private static final List<Enum[]>[] MAPPING_SPARTE10 = new List[10];

    private static void initMappingSparte10() {
        Satz221.MAPPING_SPARTE10[0] = new ArrayList<Enum[]>();
        Satz221.MAPPING_SPARTE10[1] = Arrays.asList(new Enum[][]{Feld221Wagnis13.values(), Feld221Wagnis13Auszahlungen.values(), Feld221Wagnis13ZukSummenaenderungen.values()});
        Satz221.MAPPING_SPARTE10[2] = Arrays.asList(new Enum[][]{Feld221Wagnis2.values(), Feld221Wagnis2Auszahlungen.values(), Feld221Wagnis2ZukSummenaenderungen.values()});
        Satz221.MAPPING_SPARTE10[3] = MAPPING_SPARTE10[1];
        Satz221.MAPPING_SPARTE10[4] = Collections.singletonList(Feld221Wagnis48.values());
        Satz221.MAPPING_SPARTE10[5] = Arrays.asList(new Enum[][]{Feld221Wagnis5.values(), Feld221Wagnis5ZukSummenaenderungen.values()});
        Satz221.MAPPING_SPARTE10[6] = Arrays.asList(new Enum[][]{Feld221Wagnis6.values(), Feld221Wagnis6ZukSummenaenderungen.values()});
        Satz221.MAPPING_SPARTE10[7] = Arrays.asList(new Enum[][]{Feld221Wagnis7.values(), Feld221Wagnis7ZukSummenaenderungen.values()});
        Satz221.MAPPING_SPARTE10[8] = MAPPING_SPARTE10[4];
        Satz221.MAPPING_SPARTE10[9] = new ArrayList<Enum[]>();
    }

    private static void initMapping() {
        MAPPING.put(30, Feld221.values());
        MAPPING.put(40, gdv.xport.satz.feld.sparte40.Feld221.values());
        MAPPING.put(51, gdv.xport.satz.feld.sparte51.Feld221.values());
        MAPPING.put(52, gdv.xport.satz.feld.sparte52.Feld221.values());
        MAPPING.put(53, gdv.xport.satz.feld.sparte53.Feld221.values());
        MAPPING.put(55, gdv.xport.satz.feld.sparte55.Feld221.values());
        MAPPING.put(59, gdv.xport.satz.feld.sparte59.Feld221.values());
        MAPPING.put(70, gdv.xport.satz.feld.sparte70.Feld221.values());
    }

    public Satz221() {
        this(0);
    }

    public Satz221(int sparte) {
        super(221, sparte);
        if (sparte == 10) {
            LOG.warn("Wagnisart fehlt - fuer Sparte 10 bitte anderen Konstruktor verwenden.");
        }
    }

    public Satz221(int sparte, int wagnisart) {
        this(MAPPING_SPARTE10[wagnisart].get(0));
        if (sparte != 10) {
            throw new IllegalArgumentException("falsche Sparte " + sparte + ": Wagnisart " + wagnisart + " gibt es nur bei Sparte 10");
        }
        this.getFeld(Bezeichner.WAGNISART).setInhalt(wagnisart);
    }

    public Satz221(Enum[] felder) {
        super(220, 10, felder);
        this.getFeld(Bezeichner.WAGNISART).setInhalt(Satz220.getWagnisartFrom(MAPPING_SPARTE10, felder));
    }

    @Override
    public void set(Bezeichner name, String value) {
        if (this.getSparte() == 10 && !this.hasFeld(name)) {
            Satz220.setUpTeildatensatzeOf((SatzX)this, name, MAPPING_SPARTE10);
        }
        super.set(name, value);
    }

    @Override
    protected Map<Integer, Enum[]> getMapping() {
        return MAPPING;
    }

    static {
        Satz221.initMappingSparte10();
        Satz221.initMapping();
    }
}

