/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.model;

import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.feld.sparte10.Feld220Wagnis0;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart13.Feld220Wagnis13ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart2.Feld220Wagnis2ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart48.Feld220Wagnis48ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart5.Feld220Wagnis5ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart6.Feld220Wagnis6ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart7.Feld220Wagnis7ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Auszahlungen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Bezugsrechte;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9Wertungssummen;
import gdv.xport.satz.feld.sparte10.wagnisart9.Feld220Wagnis9ZukSummenaenderungen;
import gdv.xport.satz.feld.sparte30.Feld220;
import gdv.xport.satz.model.SatzX;
import gdv.xport.satz.model.SpartensatzX;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Satz220
extends SpartensatzX {
    private static final Logger LOG = LogManager.getLogger(Satz220.class);
    private static final Map<Integer, Enum[]> MAPPING = new HashMap<Integer, Enum[]>();
    private static final List<Enum[]>[] MAPPING_SPARTE10 = new List[10];

    private static void initMappingSparte10() {
        Satz220.MAPPING_SPARTE10[0] = Collections.singletonList(Feld220Wagnis0.values());
        Satz220.MAPPING_SPARTE10[1] = Arrays.asList(new Enum[][]{Feld220Wagnis13.values(), Feld220Wagnis13Bezugsrechte.values(), Feld220Wagnis13Auszahlungen.values(), Feld220Wagnis13ZukSummenaenderungen.values(), Feld220Wagnis13Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[2] = Arrays.asList(new Enum[][]{Feld220Wagnis2.values(), Feld220Wagnis2Bezugsrechte.values(), Feld220Wagnis2Auszahlungen.values(), Feld220Wagnis2ZukSummenaenderungen.values(), Feld220Wagnis2Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[3] = MAPPING_SPARTE10[1];
        Satz220.MAPPING_SPARTE10[4] = Arrays.asList(new Enum[][]{Feld220Wagnis48.values(), Feld220Wagnis48Bezugsrechte.values(), Feld220Wagnis48ZukSummenaenderungen.values(), Feld220Wagnis48Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[5] = Arrays.asList(new Enum[][]{Feld220Wagnis5.values(), Feld220Wagnis5Bezugsrechte.values(), Feld220Wagnis5ZukSummenaenderungen.values(), Feld220Wagnis5Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[6] = Arrays.asList(new Enum[][]{Feld220Wagnis6.values(), Feld220Wagnis6Bezugsrechte.values(), Feld220Wagnis6ZukSummenaenderungen.values(), Feld220Wagnis6Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[7] = Arrays.asList(new Enum[][]{Feld220Wagnis7.values(), Feld220Wagnis7Bezugsrechte.values(), Feld220Wagnis7ZukSummenaenderungen.values(), Feld220Wagnis7Wertungssummen.values()});
        Satz220.MAPPING_SPARTE10[8] = MAPPING_SPARTE10[4];
        Satz220.MAPPING_SPARTE10[9] = Arrays.asList(new Enum[][]{Feld220Wagnis9.values(), Feld220Wagnis9Bezugsrechte.values(), Feld220Wagnis9Auszahlungen.values(), Feld220Wagnis9ZukSummenaenderungen.values(), Feld220Wagnis9Wertungssummen.values()});
    }

    private static void initMapping() {
        MAPPING.put(30, Feld220.values());
        MAPPING.put(40, gdv.xport.satz.feld.sparte40.Feld220.values());
        MAPPING.put(51, gdv.xport.satz.feld.sparte51.Feld220.values());
        MAPPING.put(52, gdv.xport.satz.feld.sparte52.Feld220.values());
        MAPPING.put(53, gdv.xport.satz.feld.sparte53.Feld220.values());
        MAPPING.put(55, gdv.xport.satz.feld.sparte55.Feld220.values());
        MAPPING.put(59, gdv.xport.satz.feld.sparte59.Feld220.values());
        MAPPING.put(70, gdv.xport.satz.feld.sparte70.Feld220.values());
        MAPPING.put(110, gdv.xport.satz.feld.sparte110.Feld220.values());
        MAPPING.put(140, gdv.xport.satz.feld.sparte140.Feld220.values());
        MAPPING.put(510, gdv.xport.satz.feld.sparte510.Feld220.values());
    }

    public Satz220() {
        this(0);
    }

    public Satz220(int sparte) {
        super(220, sparte);
        if (sparte == 10) {
            LOG.warn("Wagnisart fehlt - fuer Sparte 10 bitte anderen Konstruktor verwenden.");
        }
    }

    public Satz220(int sparte, int wagnisart) {
        this(MAPPING_SPARTE10[wagnisart].get(0));
        if (sparte != 10) {
            throw new IllegalArgumentException("falsche Sparte " + sparte + ": Wagnisart " + wagnisart + " gibt es nur bei Sparte 10");
        }
        this.getFeld(Bezeichner.WAGNISART).setInhalt(wagnisart);
    }

    public Satz220(Enum[] felder) {
        super(220, 10, felder);
        this.getFeld(Bezeichner.WAGNISART).setInhalt(Satz220.getWagnisartFrom(MAPPING_SPARTE10, felder));
    }

    protected static int getWagnisartFrom(List<Enum[]>[] mapping10, Enum[] felder) {
        for (int art = 0; art < mapping10.length; ++art) {
            for (Object[] objectArray : mapping10[art]) {
                if (!Arrays.equals(felder, objectArray)) continue;
                return art;
            }
        }
        return 0;
    }

    @Override
    public void set(Bezeichner name, String value) {
        if (this.getSparte() == 10 && !this.hasFeld(name)) {
            Satz220.setUpTeildatensatzeOf((SatzX)this, name, MAPPING_SPARTE10);
        }
        super.set(name, value);
    }

    protected static void setUpTeildatensatzeOf(SatzX satz, Bezeichner name, List<Enum[]>[] mappings) {
        for (int art = 0; art < mappings.length; ++art) {
            if (!Satz220.hasIn(mappings[art], name)) continue;
            LOG.info("{} wird fuer Wagnisart {} aufgesetzt.", (Object)satz.toShortString(), (Object)art);
            Satz220.setUpTeildatensatzeOf(satz, name, mappings[art]);
            break;
        }
    }

    private static void setUpTeildatensatzeOf(SatzX satz, Bezeichner name, List<Enum[]> valuesList) {
        for (Enum[] sparte10Values : valuesList) {
            if (!Satz220.hasInSparte10(name, sparte10Values)) continue;
            satz.setUpTeildatensaetze(sparte10Values);
            return;
        }
        LOG.warn("{} mit {} konnte nicht aufgesetzt werden.", (Object)satz.toShortString(), (Object)name);
    }

    private static boolean hasIn(List<Enum[]> mappingList, Bezeichner name) {
        for (Enum[] sparte10Values : mappingList) {
            if (!Satz220.hasInSparte10(name, sparte10Values)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInSparte10(Bezeichner name, Enum[] sparte10Values) {
        for (Enum e : sparte10Values) {
            if (!name.equals(Bezeichner.of(e))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Map<Integer, Enum[]> getMapping() {
        return MAPPING;
    }

    static {
        Satz220.initMappingSparte10();
        Satz220.initMapping();
    }
}

