/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.feld;

import gdv.xport.annotation.FeldInfo;
import gdv.xport.annotation.FelderInfo;

public final class MetaFeldInfo {
    private final Enum feldEnum;
    private final FelderInfo felderInfo;

    public MetaFeldInfo(Enum enumX) {
        this(enumX, null);
    }

    public MetaFeldInfo(Enum enumX, FelderInfo info) {
        this.feldEnum = enumX;
        this.felderInfo = info;
    }

    public Enum getFeldEnum() {
        return this.feldEnum;
    }

    public String getName() {
        return this.feldEnum.name();
    }

    public static FeldInfo getFeldInfo(Enum feldX) {
        String name = feldX.name();
        try {
            FeldInfo info = feldX.getClass().getField(name).getAnnotation(FeldInfo.class);
            if (info == null) {
                throw new IllegalArgumentException("@FeldInfo missing for " + name);
            }
            return info;
        }
        catch (NoSuchFieldException nsfe) {
            throw new InternalError("no field " + name + " (" + nsfe + ")");
        }
    }

    public FeldInfo getFeldInfo() {
        return MetaFeldInfo.getFeldInfo(this.feldEnum);
    }

    public int getNr() {
        return this.getFeldInfo().nr();
    }

    public int getTeildatensatzNr() {
        if (this.felderInfo != null && this.felderInfo.teildatensatz() > 0) {
            return this.felderInfo.teildatensatz();
        }
        return this.getFeldInfo().teildatensatz();
    }

    public boolean hasSparte() {
        return this.felderInfo != null && this.felderInfo.sparte() > 0;
    }

    public int getSparte() {
        return this.felderInfo.sparte();
    }

    public String toString() {
        return this.getTeildatensatzNr() + "." + this.getNr() + " " + this.getName();
    }
}

