/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.config.Config;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Version;
import gdv.xport.feld.Zeichen;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Vorsatz
extends Satz {
    private static final Logger LOG = LogManager.getLogger(Vorsatz.class);
    private final AlphaNumFeld vuNummer = Config.getVUNummer();
    private final AlphaNumFeld absender = new AlphaNumFeld(Bezeichner.ABSENDER, 30, 10);
    private final AlphaNumFeld adressat = new AlphaNumFeld(Bezeichner.ADRESSAT, 30, 40);
    private final Datum von = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_VOM, 70);
    private final Datum bis = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_BIS, 78);
    private final AlphaNumFeld vermittler = new AlphaNumFeld(Bezeichner.VERMITTLER, 10, 86);
    private final Map<Integer, Version> versions = new HashMap<Integer, Version>();

    public Vorsatz() {
        super("0001", 3);
        this.setUpTeildatensaetze();
        this.setUpVersions();
    }

    public Vorsatz(String content) {
        this();
        try {
            this.importFrom(content);
            LOG.debug(this + " created from \"" + content + '\"');
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("argument too short", ioe);
        }
    }

    private void setUpTeildatensaetze() {
        int nr = 1;
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            this.setUpTeildatensatz(nr, tds);
            ++nr;
        }
    }

    private void setUpTeildatensatz(int n, Teildatensatz tds) {
        tds.add(this.vuNummer);
        tds.add(this.absender);
        tds.add(this.adressat);
        tds.add(this.von);
        tds.add(this.bis);
        tds.add(this.vermittler);
        switch (n) {
            case 1: {
                tds.add(new Zeichen(Bezeichner.ART_DES_ABSENDERS, 237));
                tds.add(new Zeichen(Bezeichner.ART_DES_ADRESSATEN, 238));
                tds.add(new AlphaNumFeld(Bezeichner.VU_ABRECHNUNGSSTELLE, 2, 239));
                tds.add(new AlphaNumFeld(Bezeichner.BESTANDSFUEHRENDE_GESCHAEFTSSTELLE, 2, 241));
                tds.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 10, 246));
                break;
            }
            case 2: {
                tds.add(new AlphaNumFeld(Bezeichner.PRODUKTSPEZIFISCHE_ANTRAGSDATEN, 3, 240));
                tds.add(new AlphaNumFeld(Bezeichner.PRODUKTSPEZIFISCHE_STAMMDATEN, 3, 243));
                tds.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 10, 246));
                break;
            }
            case 3: {
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0211_050, 3, 96));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_051, 3, 99));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_052, 3, 102));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_053, 3, 105));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_054, 3, 108));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_059, 3, 111));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0221_055, 3, 114));
                tds.add(new AlphaNumFeld(Bezeichner.VERSION_SATZART_0211_040, 3, 117));
                tds.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 118, 138));
                break;
            }
            default: {
                LOG.debug("no special setup for Teildatensatz " + n);
            }
        }
    }

    private void setUpVersions() {
        this.setUpVersionTds1();
        this.setUpVersionTds2();
    }

    private void setUpVersionTds1() {
        this.addVersion(1, new Version(Bezeichner.VERSION_SATZART_0001, 96, "2.1"));
        this.addVersion(100, 99, "2.1");
        this.addVersion(200, 102, "2.2");
        this.addVersion(210, 50, 105, "   ");
        this.addVersion(220, 51, 108, "   ");
        this.addVersion(220, 52, 111, "   ");
        this.addVersion(220, 53, 114, "   ");
        this.addVersion(220, 54, 117, "   ");
        this.addVersion(220, 59, 120, "   ");
        this.addVersion(210, 40, 123, "   ");
        this.addVersion(220, 40, 126, "   ");
        this.addVersion(210, 30, 129, "   ");
        this.addVersion(220, 30, 132, "   ");
        this.addVersion(210, 10, 135, "   ");
        this.addVersion(220, 10, 138, "   ");
        this.addVersion(210, 130, 141, "   ");
        this.addVersion(220, 130, 144, "   ");
        this.addVersion(210, 110, 147, "   ");
        this.addVersion(220, 110, 150, "   ");
        this.addVersion(210, 140, 153, "   ");
        this.addVersion(220, 140, 156, "   ");
        this.addVersion(210, 20, 159, "   ");
        this.addVersion(220, 20, 162, "   ");
        this.addVersion(210, 70, 165, "1.4");
        this.addVersion(220, 70, 168, "1.4");
        this.addVersion(210, 171, "   ");
        this.addVersion(220, 174, "   ");
        this.addVersion(210, 510, 177, "   ");
        this.addVersion(220, 510, 180, "   ");
        this.addVersion(210, 183, "   ");
        this.addVersion(220, 186, "   ");
        this.addVersion(210, 189, "   ");
        this.addVersion(220, 192, "   ");
        this.addVersion(250, 195, "   ");
        this.addVersion(260, 198, "   ");
        this.addVersion(210, 201, "   ");
        this.addVersion(220, 204, "   ");
        this.addVersion(220, 55, 207, "   ");
        this.addVersion(300, 210, "   ");
        this.addVersion(400, 213, "   ");
        this.addVersion(410, 216, "   ");
        this.addVersion(430, 219, "   ");
        this.addVersion(500, 222, "   ");
        this.addVersion(9999, new Version(Bezeichner.VERSION_SATZART_9999, 225, "1.1"));
        this.addVersion(420, 228, "   ");
        this.addVersion(450, 231, "   ");
        this.addVersion(550, 234, "   ");
        this.addVersion(350, 243, "   ");
    }

    private void setUpVersionTds2() {
        Teildatensatz tds = this.getTeildatensatz(2);
        this.addVersion(tds, 211, 50, 96, "   ");
        this.addVersion(tds, 221, 51, 99, "   ");
        this.addVersion(tds, 221, 52, 102, "   ");
        this.addVersion(tds, 221, 53, 105, "   ");
        this.addVersion(tds, 221, 54, 108, "   ");
        this.addVersion(tds, 221, 59, 111, "   ");
        this.addVersion(tds, 221, 55, 114, "   ");
        this.addVersion(tds, 211, 40, 117, "   ");
        this.addVersion(tds, 221, 40, 120, "   ");
        this.addVersion(tds, 221, 30, 123, "1.2");
        this.addVersion(tds, 211, 10, 126, "   ");
        this.addVersion(tds, 221, 10, 129, "   ");
        this.addVersion(tds, 211, 130, 132, "   ");
        this.addVersion(tds, 221, 130, 135, "   ");
        this.addVersion(tds, 211, 110, 138, "   ");
        this.addVersion(tds, 221, 110, 141, "   ");
        this.addVersion(tds, 211, 140, 144, "   ");
        this.addVersion(tds, 221, 140, 147, "   ");
        this.addVersion(tds, 221, 70, 150, "1.2");
        this.addVersion(tds, 211, 153, "   ");
        this.addVersion(tds, 221, 156, "1.2");
        this.addVersion(tds, 221, 510, 159, "   ");
        this.addVersion(tds, 211, 162, "   ");
        this.addVersion(tds, 221, 165, "1.2");
        this.addVersion(tds, 211, 168, "   ");
        this.addVersion(tds, 221, 171, "1.2");
        this.addVersion(tds, 251, 174, "   ");
        this.addVersion(tds, 211, 177, "   ");
        this.addVersion(tds, 221, 180, "1.2");
        this.addVersion(tds, 210, 550, 183, "   ");
        this.addVersion(tds, 220, 550, 186, "   ");
        this.addVersion(tds, 270, 550, 189, "   ");
        this.addVersion(tds, 280, 550, 192, "   ");
        this.addVersion(tds, 291, 550, 195, "   ");
        this.addVersion(tds, 292, 550, 198, "   ");
        this.addVersion(tds, 293, 550, 201, "   ");
        this.addVersion(tds, 294, 550, 204, "   ");
        this.addVersion(tds, 295, 550, 207, "   ");
        this.addVersion(tds, 52, 210, "   ");
        this.addVersion(tds, 102, 213, "   ");
        this.addVersion(tds, 212, 216, "   ");
        this.addVersion(tds, 352, 219, "   ");
        this.addVersion(tds, 362, 222, "   ");
        this.addVersion(tds, 382, 225, "   ");
        this.addVersion(tds, 9950, 228, "   ");
        this.addVersion(tds, 9952, 231, "   ");
        this.addVersion(tds, 210, 580, 234, "   ");
        this.addVersion(tds, 220, 580, 237, "   ");
    }

    private void addVersion(Integer art, Version version) {
        this.addVersion(this.getTeildatensatz(1), art, version);
    }

    private void addVersion(Teildatensatz tds, Integer art, Version version) {
        this.versions.put(art, version);
        tds.add(version);
    }

    private void addVersion(int art, int byteadresse, String version) {
        this.addVersion(this.getTeildatensatz(1), art, byteadresse, version);
    }

    private void addVersion(Teildatensatz tds, int art, int byteadresse, String version) {
        String s = Vorsatz.getVersionBezeichnung(art);
        this.addVersion(tds, (Integer)art, new Version(s, byteadresse, version));
    }

    private void addVersion(int art, int sparte, int byteadresse, String version) {
        this.addVersion(this.getTeildatensatz(1), art, sparte, byteadresse, version);
    }

    private void addVersion(Teildatensatz tds, int art, int sparte, int byteadresse, String version) {
        assert (sparte < 1000) : "unbekannte Sparte " + sparte;
        String s = Vorsatz.getVersionBezeichnung(art, sparte);
        this.addVersion(tds, (Integer)(art * 1000 + sparte), new Version(s, byteadresse, version));
    }

    private static String getVersionBezeichnung(int art) {
        try (Formatter formatter = new Formatter();){
            String string = formatter.format("Version Satzart %04d", art).toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionBezeichnung(int art, int sparte) {
        try (Formatter formatter = new Formatter();){
            String string = formatter.format("Version Satzart %04d %03d", art, sparte).toString();
            return string;
        }
    }

    public void setVuNummer(String s) {
        assert (s.length() <= 5) : s + " darf nur max. 5 Zeichen lang sein";
        this.vuNummer.setInhalt(s);
    }

    public String getVuNummer() {
        return this.vuNummer.getInhalt().trim();
    }

    public void setAbsender(String name) {
        this.absender.setInhalt(name);
    }

    public String getAbsender() {
        return this.absender.getInhalt().trim();
    }

    public void setAdressat(String name) {
        this.adressat.setInhalt(name);
    }

    public String getAdressat() {
        return this.adressat.getInhalt().trim();
    }

    public void setErstellungsZeitraum(String startDatum, String endDatum) {
        this.von.setInhalt(startDatum);
        this.bis.setInhalt(endDatum);
    }

    public void setVermittler(String s) {
        this.vermittler.setInhalt(s);
    }

    public String getVermittler() {
        return this.vermittler.getInhalt().trim();
    }

    public String getVersion(Bezeichner bezeichner) {
        return this.getFeld(bezeichner).getInhalt();
    }

    public String getVersion(String bezeichner) {
        return this.getFeld(bezeichner).getInhalt();
    }

    public String getVersion(int art) {
        return this.getVersion(Vorsatz.getVersionBezeichnung(art));
    }

    public String getVersion(int art, int sparte) {
        return this.getVersion(Vorsatz.getVersionBezeichnung(art, sparte));
    }
}

