/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.ImportException;
import gdv.xport.satz.Satz;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Teildatensatz
extends Satz {
    private static final Logger LOG = LogManager.getLogger(Teildatensatz.class);
    private final Map<Bezeichner, Feld> datenfelder = new HashMap<Bezeichner, Feld>();
    private final SortedSet<Feld> sortedFelder = new TreeSet<Feld>();
    private Zeichen satznummer = new Zeichen(Bezeichner.SATZNUMMER, 256);

    public Teildatensatz(NumFeld satzart) {
        super(satzart, 0);
        this.satznummer.setInhalt(' ');
        this.initDatenfelder();
    }

    public Teildatensatz(NumFeld satzart, int nr) {
        super(satzart, 0);
        this.initSatznummer(nr);
    }

    public Teildatensatz(int satzart, int nr) {
        super(satzart, 0);
        this.initSatznummer(nr);
    }

    public Teildatensatz(Teildatensatz other) {
        this(other.getSatzart(), other.getNummer());
        for (Map.Entry<Bezeichner, Feld> entry : other.datenfelder.entrySet()) {
            Feld copy = (Feld)entry.getValue().clone();
            this.datenfelder.put(entry.getKey(), copy);
            this.sortedFelder.add(copy);
        }
    }

    private Teildatensatz(int satzart, Zeichen satznummer) {
        super(satzart, 0);
        this.satznummer = satznummer;
    }

    private void initSatznummer(int nr) {
        if (nr < 1 || nr > 9) {
            throw new IllegalArgumentException("Satznummer (" + nr + ") muss zwischen 1 und 9 liegen");
        }
        this.satznummer.setInhalt(Character.forDigit(nr, 10));
        this.initDatenfelder();
    }

    @Override
    protected void createTeildatensaetze(int n) {
        assert (n == 0) : "ein Teildatensatz hat keine weiteren Teildatensaetze";
    }

    private void initDatenfelder() {
        this.add(this.getSatzartFeld());
        this.add(this.satznummer);
    }

    public Zeichen getNummer() {
        return this.satznummer;
    }

    public void setSatznummer(Zeichen satznummer) {
        String nr = this.satznummer.getInhalt();
        this.remove(Bezeichner.SATZNUMMER);
        this.satznummer = new Zeichen(satznummer);
        this.satznummer.setInhalt(nr);
        this.add(this.satznummer);
    }

    @Override
    public void add(Feld feld) {
        for (Feld f : this.datenfelder.values()) {
            if (feld.equals(f) || !feld.overlapsWith(f)) continue;
            if (Teildatensatz.isSatznummer(f)) {
                this.remove(f);
                LOG.debug(f + " is removed from " + this);
                break;
            }
            throw new IllegalArgumentException("conflict: " + feld + " overlaps with " + f);
        }
        this.datenfelder.put(feld.getBezeichner(), feld);
        this.sortedFelder.add(feld);
    }

    private static boolean isSatznummer(Feld feld) {
        if (feld.getByteAdresse() == 256 && feld.getAnzahlBytes() == 1) {
            String bezeichnung = feld.getBezeichnung();
            return bezeichnung.length() <= 11 && bezeichnung.startsWith("Satznummer");
        }
        return false;
    }

    public void remove(Feld feld) {
        this.remove(feld.getBezeichnung());
    }

    @Override
    public void remove(Bezeichner bezeichner) {
        Feld feld = this.datenfelder.get(bezeichner);
        if (feld != null) {
            this.datenfelder.remove(bezeichner);
            this.sortedFelder.remove(feld);
            LOG.debug("{} was removed from {}.", (Object)bezeichner, (Object)this);
        }
    }

    @Override
    public void set(Bezeichner name, String value) {
        Feld x = this.getFeld(name);
        if (x == Feld.NULL_FELD) {
            throw new IllegalArgumentException("Feld \"" + name + "\" not found");
        }
        x.setInhalt(value);
    }

    @Override
    public Feld getFeld(Enum feldX) throws IllegalArgumentException {
        return this.getFeld(Bezeichner.of(feldX));
    }

    @Override
    public Feld getFeld(Bezeichner bezeichner) {
        Feld found = this.datenfelder.get(bezeichner);
        if (found == null) {
            throw new IllegalArgumentException("Feld \"" + bezeichner + "\" nicht in " + this.toShortString() + " vorhanden!");
        }
        return found;
    }

    public Feld getFeld(int nr) {
        return (Feld)this.sortedFelder.toArray()[nr - 1];
    }

    public boolean hasFeld(Enum feldX) {
        return this.hasFeld(new Bezeichner(Feld.toBezeichnung(feldX)));
    }

    @Override
    public boolean hasFeld(Bezeichner bezeichner) {
        return this.datenfelder.containsKey(bezeichner);
    }

    public boolean hasFeld(Feld feld) {
        return this.datenfelder.containsKey(feld.getBezeichner());
    }

    @Override
    public Collection<Feld> getFelder() {
        return new TreeSet<Feld>(this.datenfelder.values());
    }

    @Override
    public void export(Writer writer) throws IOException {
        String eod = Config.hasEOD() ? Config.getEOD() : "";
        this.export(writer, eod);
    }

    @Override
    public void export(Writer writer, String eod) throws IOException {
        StringBuilder data = new StringBuilder(256);
        for (int i = 0; i < 256; ++i) {
            data.append(' ');
        }
        for (Map.Entry<Bezeichner, Feld> entry : this.datenfelder.entrySet()) {
            Feld feld = this.datenfelder.get(entry.getKey());
            int start = (feld.getByteAdresse() - 1) % 256;
            int end = start + feld.getAnzahlBytes();
            data.replace(start, end, feld.getInhalt());
        }
        assert (data.length() == 256) : "Teildatensatz ist nicht 256 Bytes lang";
        writer.write(data.toString());
        writer.write(eod);
    }

    @Override
    public void importFrom(String content) throws IOException {
        for (Feld feld : this.datenfelder.values()) {
            int begin = (feld.getByteAdresse() - 1) % 256;
            int end = begin + feld.getAnzahlBytes();
            if (end > content.length()) {
                throw new ImportException("input string is too short (" + (end - content.length()) + " bytes missing): " + content);
            }
            String s = content.substring(begin, end);
            feld.setInhalt(s);
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (Feld feld : this.datenfelder.values()) {
            if (feld.isValid()) continue;
            LOG.info(feld + " is not valid");
            return false;
        }
        return true;
    }

    @Override
    public List<ConstraintViolation> validate() {
        Validator validator = new Validator();
        List violations = validator.validate((Object)this);
        for (Feld feld : this.datenfelder.values()) {
            violations.addAll(feld.validate());
        }
        return violations;
    }

    @Override
    public Object clone() {
        return new Teildatensatz(this);
    }
}

