/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.annotation.FeldInfo;
import gdv.xport.annotation.FelderInfo;
import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.io.ImportException;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.feld.MetaFeldInfo;
import gdv.xport.satz.feld.common.Feld1bis7;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Satz
implements Cloneable {
    private static final Logger LOG = LogManager.getLogger(Satz.class);
    private final NumFeld satzart = new NumFeld(Bezeichner.SATZART, 4, 1);
    private Teildatensatz[] teildatensatz = new Teildatensatz[0];

    protected Satz(int art) {
        this(art, 1);
    }

    protected Satz(String art) {
        this(art, (art.length() + 255) / 256);
    }

    protected Satz(NumFeld art) {
        this(art.getInhalt());
    }

    public Satz(NumFeld art, int n) {
        this.satzart.setInhalt(art.getInhalt());
        this.createTeildatensaetze(n);
    }

    public Satz(String content, int n) {
        this.satzart.setInhalt(content);
        this.createTeildatensaetze(n);
        if (content.length() > 4) {
            try {
                this.importFrom(content);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("1st argument too short", ioe);
            }
        }
    }

    public Satz(int art, int n) {
        this.satzart.setInhalt(art);
        this.createTeildatensaetze(n);
    }

    public Satz(int art, List<? extends Teildatensatz> tdsList) {
        this.satzart.setInhalt(art);
        this.createTeildatensaetze(tdsList);
    }

    protected void createTeildatensaetze(int n) {
        this.teildatensatz = new Teildatensatz[n];
        for (int i = 0; i < n; ++i) {
            this.teildatensatz[i] = new Teildatensatz(this.satzart, i + 1);
        }
    }

    protected void createTeildatensaetze(List<? extends Teildatensatz> tdsList) {
        this.teildatensatz = new Teildatensatz[tdsList.size()];
        for (int i = 0; i < tdsList.size(); ++i) {
            this.teildatensatz[i] = tdsList.get(i);
            this.teildatensatz[i].add(this.satzart);
        }
    }

    public final List<Teildatensatz> getTeildatensaetze() {
        return Arrays.asList(this.teildatensatz);
    }

    protected final List<Teildatensatz> cloneTeildatensaetze() {
        ArrayList<Teildatensatz> cloned = new ArrayList<Teildatensatz>(this.teildatensatz.length);
        for (Teildatensatz tds : this.teildatensatz) {
            cloned.add(new Teildatensatz(tds));
        }
        return cloned;
    }

    public final int getNumberOfTeildatensaetze() {
        return this.teildatensatz.length;
    }

    public final Teildatensatz getTeildatensatz(int n) {
        return this.teildatensatz[n - 1];
    }

    public final void removeAllTeildatensaetze() {
        this.teildatensatz = new Teildatensatz[0];
    }

    public final void removeTeildatensatz(int n) {
        if (n < 1 || n > this.teildatensatz.length) {
            throw new IllegalArgumentException(n + " liegt nicht zwischen 1 und " + this.teildatensatz.length);
        }
        this.teildatensatz = (Teildatensatz[])ArrayUtils.remove((Object[])this.teildatensatz, (int)(n - 1));
    }

    public final void add(Teildatensatz tds) {
        this.teildatensatz = (Teildatensatz[])ArrayUtils.add((Object[])this.teildatensatz, (Object)tds);
    }

    public void add(Feld feld) {
        this.add(feld, 1);
    }

    public void add(Feld feld, int teildatensatzNr) {
        if (feld.getByteAdresse() > 256) {
            throw new IllegalArgumentException(feld + " ueberschreitet Teildatensatz-Grenze");
        }
        if (teildatensatzNr < 1 || teildatensatzNr > this.teildatensatz.length) {
            throw new IllegalArgumentException("Teildatensatz-Nr. " + teildatensatzNr + " fuer " + feld + " liegt nicht zwischen 1 und " + this.teildatensatz.length);
        }
        this.teildatensatz[teildatensatzNr - 1].add(feld);
    }

    public void addFiller() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void remove(String name) {
        this.remove(new Bezeichner(name));
    }

    public void remove(Bezeichner bezeichner) {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.remove(bezeichner);
        }
    }

    public void set(String name, String value) {
        this.set(new Bezeichner(name), value);
    }

    public void set(Bezeichner name, String value) {
        boolean found = false;
        for (Teildatensatz tds : this.teildatensatz) {
            Feld x = tds.getFeldSafe(name);
            if (x == Feld.NULL_FELD) continue;
            x.setInhalt(value);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Feld \"" + name + "\" not found");
        }
    }

    public final void set(Enum feldX, String value) {
        Bezeichner name = Feld.getAsBezeichner(feldX);
        this.set(name, value);
    }

    public final void set(Enum feldX, Integer value) {
        this.set(feldX, Integer.toString(value));
    }

    public final void set(Enum feldX, Character value) {
        this.set(feldX, Character.toString(value.charValue()));
    }

    public final String get(String name) {
        return this.get(new Bezeichner(name));
    }

    public final String get(Bezeichner bezeichner) {
        Feld f = this.getFeld(bezeichner);
        if (f == Feld.NULL_FELD) {
            return "";
        }
        return f.getInhalt();
    }

    public final String get(Enum feldX) {
        Bezeichner name = Feld.getAsBezeichner(feldX);
        return this.get(name);
    }

    public Feld getFeld(Enum feld) throws IllegalArgumentException {
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            try {
                Feld x = this.teildatensatz[i].getFeldSafe(feld);
                if (x == Feld.NULL_FELD) continue;
                return x;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Feld '{}\u2018 not found in teildatensatz {}:", (Object)feld, (Object)i, (Object)e);
            }
        }
        throw new IllegalArgumentException("Feld \"" + feld + "\" nicht in " + this.toShortString() + " vorhanden!");
    }

    public Feld getFeldSafe(Enum feld) {
        try {
            return this.getFeld(feld);
        }
        catch (IllegalArgumentException ex) {
            return Feld.NULL_FELD;
        }
    }

    public Feld containsFeld(String name) {
        for (Teildatensatz tds : this.teildatensatz) {
            Feld x = tds.getFeldSafe(name);
            if (x == Feld.NULL_FELD) continue;
            return x;
        }
        LOG.debug("Feld \"{}\" not found in {}.", (Object)name, (Object)this);
        return null;
    }

    public Feld getFeld(String name) throws IllegalArgumentException {
        return this.getFeld(new Bezeichner(name));
    }

    public Feld getFeldSafe(String name) {
        return this.getFeldSafe(new Bezeichner(name));
    }

    public boolean hasFeld(Bezeichner bezeichner) {
        for (Teildatensatz tds : this.teildatensatz) {
            if (!tds.hasFeld(bezeichner)) continue;
            return true;
        }
        return false;
    }

    public Feld getFeld(Bezeichner bezeichner) throws IllegalArgumentException {
        for (Teildatensatz tds : this.teildatensatz) {
            Feld x = tds.getFeldSafe(bezeichner);
            if (x == Feld.NULL_FELD) continue;
            return x;
        }
        throw new IllegalArgumentException("Feld \"" + bezeichner + "\" nicht in " + this.toShortString() + " vorhanden!");
    }

    public Feld getFeldSafe(Bezeichner bezeichner) {
        try {
            return this.getFeld(bezeichner);
        }
        catch (IllegalArgumentException ex) {
            return Feld.NULL_FELD;
        }
    }

    public final String getFeldInhalt(Bezeichner bezeichner) throws IllegalArgumentException {
        return this.getFeld(bezeichner).getInhalt().trim();
    }

    public final Feld getFeld(Bezeichner bezeichner, int nr) throws IllegalArgumentException {
        return this.getFeld(bezeichner.getName(), nr);
    }

    public final Feld getFeld(String name, int nr) throws IllegalArgumentException {
        assert (0 < nr && nr <= this.teildatensatz.length) : nr + " liegt ausserhalb des Bereichs";
        return this.teildatensatz[nr - 1].getFeld(name);
    }

    public final String getFeldInhalt(String name, int nr) throws IllegalArgumentException {
        return this.getFeld(name, nr).getInhalt().trim();
    }

    public final NumFeld getSatzartFeld() {
        return this.satzart;
    }

    public final int getSatzart() {
        return this.satzart.toInt();
    }

    @JsonIgnore
    public final SatzTyp getSatzTyp() {
        if (this.hasSparte() && this.getSparte() == 10 && this.hasWagnisart()) {
            String wagnisart = this.getWagnisart();
            if (StringUtils.isBlank((String)wagnisart)) {
                return new SatzTyp(this.getSatzart(), this.getSparte());
            }
            return new SatzTyp(this.getSatzart(), this.getSparte(), Integer.parseInt(wagnisart));
        }
        if (this.hasSparte() && this.getSparte() == 20 && this.getSatzart() == 220) {
            String krankenFolgeNr = null;
            if (this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF)) {
                krankenFolgeNr = this.getFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF).getInhalt();
            } else if (this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF)) {
                krankenFolgeNr = this.getFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF).getInhalt();
            }
            if (StringUtils.isBlank((String)krankenFolgeNr) || !StringUtils.isNumeric((String)krankenFolgeNr)) {
                return new SatzTyp(this.getSatzart(), this.getSparte());
            }
            return new SatzTyp(this.getSatzart(), this.getSparte(), -1, Integer.parseInt(krankenFolgeNr), -1);
        }
        if (this.hasSparte()) {
            return new SatzTyp(this.getSatzart(), this.getSparte());
        }
        return new SatzTyp(this.getSatzart());
    }

    public boolean hasSparte() {
        Feld sparte = this.getFeldSafe(Feld1bis7.SPARTE);
        return sparte != Feld.NULL_FELD && !sparte.isEmpty();
    }

    public boolean hasWagnisart() {
        return this.hasFeld(Bezeichner.WAGNISART);
    }

    public boolean hasKrankenFolgeNr() {
        return this.getSatzart() == 220 && this.getSparte() == 20 && (this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF) || this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF));
    }

    @JsonIgnore
    public int getSparte() {
        NumFeld sparte = (NumFeld)this.getFeld(Feld1bis7.SPARTE);
        return sparte.toInt();
    }

    @JsonIgnore
    public final String getWagnisart() {
        Feld wagnisart = this.getFeld(Bezeichner.WAGNISART);
        return wagnisart.getInhalt();
    }

    public void export(Writer writer) throws IOException {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.export(writer);
        }
    }

    public void export(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.export(writer);
        }
    }

    public void export(Writer writer, String eod) throws IOException {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.export(writer, eod);
        }
    }

    public void export(OutputStream ostream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(ostream);
        this.export(writer);
        ((Writer)writer).flush();
        ostream.flush();
    }

    public void importFrom(String s) throws IOException {
        int satzlength = this.getSatzlength(s);
        TreeSet<Integer> importedTeilsatzIndexes = new TreeSet<Integer>();
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            String input = s.substring(i * satzlength);
            if (input.trim().isEmpty()) {
                LOG.info("mehr Daten fuer Satz " + this.getSatzart() + " erwartet, aber nur " + i + " Teildatensaetze vorgefunden");
                this.removeUnusedTeildatensaetze(importedTeilsatzIndexes);
                break;
            }
            int satznummer = Satz.readSatznummer(input.toCharArray()) - 48;
            int teildatensatzIndex = this.getTeildatensatzIndex(i, satznummer);
            this.teildatensatz[teildatensatzIndex].importFrom(input);
            importedTeilsatzIndexes.add(teildatensatzIndex);
        }
    }

    private int getTeildatensatzIndex(int index, int satznummer) {
        if (satznummer < 1) {
            return index;
        }
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            if (this.teildatensatz[i].getNummer().toInt() != satznummer) continue;
            return i;
        }
        return index;
    }

    private void removeUnusedTeildatensaetze(SortedSet<Integer> usedIndexes) {
        Teildatensatz[] usedTeildatensaetze = new Teildatensatz[usedIndexes.size()];
        int i = 0;
        Iterator iterator = usedIndexes.iterator();
        while (iterator.hasNext()) {
            int teilsatzIndex = (Integer)iterator.next();
            usedTeildatensaetze[i] = this.teildatensatz[teilsatzIndex];
            ++i;
        }
        this.teildatensatz = usedTeildatensaetze;
    }

    public void importFrom(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            this.importFrom(reader);
        }
    }

    protected final int getSatzlength(String s) {
        int satzlength = 256;
        try {
            char c257;
            char c256 = s.charAt(256);
            if (c256 == '\n' || c256 == '\r') {
                satzlength = 257;
            }
            if (s.length() > satzlength && ((c257 = s.charAt(257)) == '\n' || c257 == '\r')) {
                satzlength = 258;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.trace("end of string \"" + s + "\" reached", (Throwable)e);
        }
        return satzlength;
    }

    public final void importFrom(InputStream istream) throws IOException {
        this.importFrom(new InputStreamReader(istream, Config.DEFAULT_ENCODING));
    }

    public final void importFrom(Reader reader) throws IOException {
        PushbackLineNumberReader lnr = new PushbackLineNumberReader(reader, 256);
        try {
            this.importFrom(lnr);
        }
        catch (IOException ioe) {
            throw new ImportException(lnr, "read error", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException(lnr, "number expected", nfe);
        }
    }

    public void importFrom(PushbackLineNumberReader reader) throws IOException {
        char[] cbuf = new char[257 * this.teildatensatz.length];
        char[] feld1to7 = null;
        Character satznummer = null;
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            reader.skipNewline();
            if (!this.matchesNextTeildatensatz(reader, feld1to7, satznummer)) {
                LOG.info(this.teildatensatz.length - i + " more Teildatensaetze expected for " + this + ", but Satzart or Sparte or Wagnisart or TeildatensatzNummer has changed");
                break;
            }
            satznummer = Satz.readSatznummer(reader);
            Satz.importFrom(reader, cbuf, i * 257);
            cbuf[i * 257 + 256] = 10;
            feld1to7 = Arrays.copyOfRange(cbuf, i * 257, i * 257 + 42);
        }
        this.importFrom(new String(cbuf));
    }

    protected boolean matchesNextTeildatensatz(PushbackLineNumberReader reader, char[] lastFeld1To7, Character satznummer) throws IOException {
        try {
            int art = Satz.readSatzart(reader);
            return art == this.getSatzart();
        }
        catch (EOFException ex) {
            LOG.info("No next teildatensatz found ({}).", (Object)ex.getLocalizedMessage());
            LOG.debug("Details:", (Throwable)ex);
            return false;
        }
    }

    private static void importFrom(Reader reader, char[] cbuf, int i) throws IOException {
        if (reader.read(cbuf, i, 256) == -1) {
            throw new EOFException("can't read 256 bytes from " + reader);
        }
    }

    public static int readSatzart(PushbackLineNumberReader reader) throws IOException {
        reader.skipWhitespace();
        char[] cbuf = new char[4];
        Satz.importFrom(reader, cbuf);
        reader.unread(cbuf);
        return Integer.parseInt(new String(cbuf).trim());
    }

    private static void importFrom(Reader reader, char[] cbuf) throws IOException {
        if (reader.read(cbuf) == -1) {
            String s = new String(cbuf).trim();
            throw new EOFException("can't read " + cbuf.length + " bytes from " + reader + ", only \"" + s + "\" (" + s.length() + " bytes)");
        }
    }

    public boolean isValid() {
        if (!this.satzart.isValid()) {
            return false;
        }
        if (this.teildatensatz != null) {
            for (int i = 0; i < this.teildatensatz.length; ++i) {
                if (this.teildatensatz[i].isValid()) continue;
                LOG.info("Teildatensatz " + (i + 1) + " is invalid");
                return false;
            }
        }
        return true;
    }

    public List<ConstraintViolation> validate() {
        Validator validator = new Validator();
        List violations = validator.validate((Object)this);
        if (!this.satzart.isValid()) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("invalid Satzart " + this.satzart.getInhalt(), this, this.satzart);
            violations.add(cv);
        }
        if (this.teildatensatz != null) {
            for (Teildatensatz tds : this.teildatensatz) {
                violations.addAll(tds.validate());
            }
        }
        return violations;
    }

    public final String toString() {
        try {
            return this.toShortString() + " (" + StringUtils.abbreviate((String)this.toLongString(), (int)47) + ")";
        }
        catch (RuntimeException shouldNeverHappen) {
            LOG.error("shit happens in toString()", (Throwable)shouldNeverHappen);
            return super.toString();
        }
    }

    public String toShortString() {
        return "Satzart " + this.satzart.getInhalt();
    }

    public String toLongString() {
        StringWriter swriter = new StringWriter();
        try {
            this.export(swriter);
        }
        catch (IOException canthappen) {
            LOG.warn(canthappen + " ignored", (Throwable)canthappen);
            swriter.write(canthappen.getLocalizedMessage());
        }
        return swriter.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Satz)) {
            return false;
        }
        Satz other = (Satz)obj;
        return this.toLongString().equals(other.toLongString());
    }

    public int hashCode() {
        return this.getSatzart();
    }

    protected static List<Teildatensatz> getTeildatensaetzeFor(int satzart, Enum[] felder) {
        TreeMap<Integer, Teildatensatz> tdsMap = new TreeMap<Integer, Teildatensatz>();
        List<MetaFeldInfo> metaFeldInfos = Satz.getMetaFeldInfos(felder);
        for (MetaFeldInfo metaFeldInfo : metaFeldInfos) {
            int n = metaFeldInfo.getTeildatensatzNr();
            Teildatensatz tds = (Teildatensatz)tdsMap.get(n);
            if (tds == null) {
                tds = new Teildatensatz(satzart, n);
                tdsMap.put(n, tds);
            }
            Satz.add(metaFeldInfo.getFeldEnum(), tds);
        }
        ArrayList<Teildatensatz> teildatensaetze = new ArrayList<Teildatensatz>(tdsMap.values());
        Satz.setSparteFor(teildatensaetze, metaFeldInfos);
        return teildatensaetze;
    }

    private static void setSparteFor(List<Teildatensatz> teildatensaetze, List<MetaFeldInfo> metaFeldInfos) {
        int sparte = Satz.getSparte(metaFeldInfos);
        if (sparte > 0) {
            Satz.setSparteFor(teildatensaetze, sparte);
        }
    }

    private static int getSparte(List<MetaFeldInfo> metaFeldInfos) {
        for (MetaFeldInfo info : metaFeldInfos) {
            if (!info.hasSparte()) continue;
            return info.getSparte();
        }
        return -1;
    }

    private static void setSparteFor(List<Teildatensatz> teildatensaetze, int sparte) {
        for (Teildatensatz teildatensatz : teildatensaetze) {
            Satz.setSparteFor(teildatensatz, sparte);
        }
    }

    private static void setSparteFor(Teildatensatz tds, int sparte) {
        Feld spartenFeld = tds.getFeldSafe(Feld1bis7.SPARTE);
        if (spartenFeld == Feld.NULL_FELD) {
            spartenFeld = new NumFeld(Bezeichner.SPARTE, 3, 11);
            tds.add(spartenFeld);
        }
        spartenFeld.setInhalt(sparte);
    }

    protected static List<MetaFeldInfo> getMetaFeldInfos(Enum[] felder) {
        ArrayList<MetaFeldInfo> metaFeldInfos = new ArrayList<MetaFeldInfo>(felder.length);
        for (Enum f : felder) {
            String name = f.name();
            try {
                Field field = f.getClass().getField(name);
                FelderInfo info = field.getAnnotation(FelderInfo.class);
                if (info == null) {
                    metaFeldInfos.add(new MetaFeldInfo(f));
                    continue;
                }
                metaFeldInfos.addAll(Satz.getMetaFeldInfos(info));
            }
            catch (NoSuchFieldException nsfe) {
                throw new InternalError("no field " + name + " (" + nsfe + ")");
            }
        }
        return metaFeldInfos;
    }

    private static List<MetaFeldInfo> getMetaFeldInfos(FelderInfo info) {
        Collection<? extends Enum> enums = Satz.getAsList(info);
        ArrayList<MetaFeldInfo> metaFeldInfos = new ArrayList<MetaFeldInfo>(enums.size());
        for (Enum enum_ : enums) {
            metaFeldInfos.add(new MetaFeldInfo(enum_, info));
        }
        return metaFeldInfos;
    }

    private static Collection<? extends Enum> getAsList(FelderInfo info) {
        Class<? extends Enum> enumClass = info.type();
        return Satz.getAsList(enumClass.getEnumConstants());
    }

    private static List<Enum> getAsList(Enum[] felder) {
        ArrayList<Enum> feldList = new ArrayList<Enum>(felder.length);
        for (Enum f : felder) {
            String name = f.name();
            try {
                Field field = f.getClass().getField(name);
                FelderInfo info = field.getAnnotation(FelderInfo.class);
                if (info == null) {
                    feldList.add(f);
                    continue;
                }
                feldList.addAll(Satz.getAsList(info));
            }
            catch (NoSuchFieldException nsfe) {
                throw new InternalError("no field " + name + " (" + nsfe + ")");
            }
        }
        return feldList;
    }

    protected static void add(Enum feldX, Teildatensatz tds) {
        FeldInfo info = MetaFeldInfo.getFeldInfo(feldX);
        Feld feld = Feld.createFeld(feldX, info);
        if (info.nr() < 7) {
            LOG.debug("using default settings for " + feld);
        } else {
            tds.add(feld);
            if (Satz.isSatznummer(feldX)) {
                feld.setInhalt(info.teildatensatz());
            }
        }
    }

    private static boolean isSatznummer(Enum feldX) {
        return feldX.name().length() <= 11 && feldX.name().startsWith("SATZNUMMER");
    }

    public Collection<Feld> getFelder() {
        ArrayList<Feld> felder = new ArrayList<Feld>();
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            for (Feld feld : tds.getFelder()) {
                if (Satz.contains(feld.getBezeichner(), felder)) continue;
                felder.add(feld);
            }
        }
        return felder;
    }

    private static boolean contains(Bezeichner bezeichner, List<Feld> felder) {
        for (Feld feld : felder) {
            if (!bezeichner.equals(feld.getBezeichner())) continue;
            return true;
        }
        return false;
    }

    public static Character readSatznummer(PushbackReader reader) throws IOException {
        char[] cbuf = new char[256];
        if (reader.read(cbuf) == -1) {
            throw new EOFException("can't read 1 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        return Character.valueOf(Satz.readSatznummer(cbuf));
    }

    public static char readSatznummer(char[] cbuf) {
        if (cbuf.length < 256) {
            return '\u0000';
        }
        String satz = new String(cbuf);
        String satzartString = satz.substring(0, 4).trim();
        int satzart = Satz.isNumber(satzartString) ? Integer.parseInt(satzartString) : -1;
        String sparteString = satz.substring(10, 13).trim();
        int sparte = Satz.isNumber(sparteString) ? Integer.parseInt(sparteString) : -1;
        int satznummerIndex = 255;
        block0 : switch (satzart) {
            case 210: {
                satznummerIndex = Satz.getSatznummerIndexOfSatz210(sparte);
                break;
            }
            case 211: {
                switch (sparte) {
                    case 0: 
                    case 80: 
                    case 170: 
                    case 190: {
                        satznummerIndex = 42;
                        break block0;
                    }
                }
                break;
            }
            case 220: 
            case 221: {
                satznummerIndex = Satz.getSatznummerIndexOf(satz, sparte);
                break;
            }
            case 250: 
            case 251: {
                switch (sparte) {
                    case 190: {
                        satznummerIndex = 50;
                        break block0;
                    }
                }
                break;
            }
        }
        return satz.charAt(satznummerIndex);
    }

    private static int getSatznummerIndexOfSatz210(int sparte) {
        switch (sparte) {
            case 0: 
            case 80: 
            case 170: 
            case 190: 
            case 550: 
            case 560: 
            case 570: 
            case 580: {
                return 42;
            }
            case 130: {
                return 250;
            }
        }
        return 255;
    }

    private static int getSatznummerIndexOf(String satz, int sparte) {
        switch (sparte) {
            case 0: {
                return 46;
            }
            case 30: {
                if (satz.charAt(48) == '2' && satz.charAt(255) == 'X' || satz.charAt(48) == '1' || satz.charAt(48) == '4') {
                    return 48;
                }
                if (Character.isDigit(satz.charAt(255)) && satz.charAt(255) != '0' && satz.charAt(255) != '2') {
                    return 249;
                }
                if (satz.charAt(42) == '3') {
                    return 42;
                }
                return 59;
            }
            case 40: 
            case 140: {
                return 50;
            }
            case 70: {
                return 52;
            }
            case 80: 
            case 190: {
                return 48;
            }
            case 170: {
                return 49;
            }
            case 550: 
            case 560: 
            case 570: 
            case 580: {
                return 42;
            }
        }
        return 255;
    }

    public static boolean isNumber(String string) {
        return string.matches("-?\\d+");
    }

    public Object clone() throws CloneNotSupportedException {
        Satz cloned = (Satz)super.clone();
        cloned.teildatensatz = new Teildatensatz[this.teildatensatz.length];
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            cloned.teildatensatz[i] = new Teildatensatz(this.teildatensatz[i]);
        }
        return cloned;
    }
}

