/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.BetragMitVorzeichen;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Zeichen;
import gdv.xport.satz.Satz;
import gdv.xport.satz.feld.Feld9999;

public final class Nachsatz
extends Satz {
    private final NumFeld anzahlSaetze = new NumFeld(Bezeichner.ANZAHL_SAETZE, 10, 5);
    private final AlphaNumFeld vermittler = new AlphaNumFeld(Bezeichner.VERMITTLER, 10, 15);
    private final Betrag gesamtBeitrag = new Betrag(Bezeichner.GESAMTBEITRAG, 15, 25);
    private final BetragMitVorzeichen gesamtBeitragBrutto = new BetragMitVorzeichen(Bezeichner.GESAMTBEITRAG_BRUTTO, 15, 40);
    private final BetragMitVorzeichen gesamtProvisionsBetrag = new BetragMitVorzeichen(Bezeichner.GESAMTPROVISIONSBETRAG, 15, 55);
    private final BetragMitVorzeichen versicherungsLeistungen = new BetragMitVorzeichen(Bezeichner.VERSICHERUNGSLEISTUNGEN, 15, 70);
    private final BetragMitVorzeichen schadenbearbeitungsKosten = new BetragMitVorzeichen(Bezeichner.SCHADENBEARBEITUNGSKOSTEN, 15, 85);

    public Nachsatz() {
        super("9999", 1);
        this.remove(Bezeichner.SATZNUMMER);
        this.setUpTeildatensatz();
        this.setAnzahlSaetze(0);
    }

    private void setUpTeildatensatz() {
        this.add(this.anzahlSaetze);
        this.add(this.vermittler);
        this.add(this.gesamtBeitrag);
        this.add(this.gesamtBeitragBrutto);
        this.add(this.gesamtProvisionsBetrag);
        this.add(this.versicherungsLeistungen);
        this.add(this.schadenbearbeitungsKosten);
        this.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 157, 100));
    }

    public void setAnzahlSaetze(int n) {
        this.anzahlSaetze.setInhalt(n);
        this.getTeildatensatz(1).add(this.anzahlSaetze);
    }

    public int getAnzahlSaetze() {
        return this.anzahlSaetze.toInt();
    }

    public void increaseAnzahlSaetze() {
        int n = this.getAnzahlSaetze();
        this.setAnzahlSaetze(n + 1);
    }

    public void setVermittler(String s) {
        this.vermittler.setInhalt(s);
    }

    public String getVermittler() {
        return this.vermittler.getInhalt().trim();
    }

    public void setGesamtBeitrag(double beitrag) {
        this.gesamtBeitrag.setInhalt(beitrag);
    }

    public Betrag getGesamtBeitrag() {
        return this.gesamtBeitrag;
    }

    public void setGesamtBeitragBrutto(double beitrag) {
        this.gesamtBeitragBrutto.setInhalt(beitrag);
    }

    public BetragMitVorzeichen getGesamtBeitragBrutto() {
        return this.gesamtBeitragBrutto;
    }

    public void setVersicherungsLeistungen(Double betrag) {
        this.versicherungsLeistungen.setInhalt(betrag);
    }

    public BetragMitVorzeichen getVersicherungsLeistungen() {
        return this.versicherungsLeistungen;
    }

    public void setSchadenbearbeitungsKosten(double kosten) {
        this.schadenbearbeitungsKosten.setInhalt(kosten);
    }

    public BetragMitVorzeichen getSchadenbearbeitungsKosten() {
        return this.schadenbearbeitungsKosten;
    }

    @Override
    public Feld getFeld(Enum feld) throws IllegalArgumentException {
        if (feld instanceof Feld9999) {
            return this.getFeld((Feld9999)feld);
        }
        return super.getFeld(feld);
    }

    private Feld getFeld(Feld9999 feld) {
        switch (feld) {
            case VORZEICHEN: {
                return this.getVorzeichenOf(this.gesamtBeitragBrutto);
            }
            case VORZEICHEN2: {
                return this.getVorzeichenOf(this.gesamtProvisionsBetrag);
            }
            case VORZEICHEN3: {
                return this.getVorzeichenOf(this.versicherungsLeistungen);
            }
            case VORZEICHEN4: {
                return this.getVorzeichenOf(this.schadenbearbeitungsKosten);
            }
        }
        return super.getFeld(feld);
    }

    private Zeichen getVorzeichenOf(BetragMitVorzeichen beitrag) {
        return new Zeichen(beitrag.getEndAdresse(), beitrag.getVorzeichen());
    }
}

