/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.config.Config;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.ImportException;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.feld.common.Feld1bis7;
import gdv.xport.satz.feld.common.TeildatensatzNummer;
import gdv.xport.satz.feld.common.WagnisartLeben;
import gdv.xport.util.SatzTyp;
import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Datensatz
extends Satz {
    private static final Logger LOG = LogManager.getLogger(Datensatz.class);
    private final NumFeld sparte = new NumFeld(Feld1bis7.SPARTE);
    private final AlphaNumFeld wagnisart = new AlphaNumFeld(Bezeichner.WAGNISART, 1, 59);
    private final AlphaNumFeld teildatensatzNummer = new AlphaNumFeld(Bezeichner.TEILDATENSATZNUMMER, 1, 256);
    private int art;

    public Datensatz() {
        this(0, Datensatz.getTeildatensaetzeFor(0, Feld1bis7.values()));
    }

    public Datensatz(String satzart) {
        super(satzart);
        this.setUpTeildatensaetze();
    }

    public Datensatz(int satzart) {
        super(satzart, 1);
        this.setUpTeildatensaetze();
    }

    public Datensatz(String satzart, int n) {
        super(satzart, n);
        this.setUpTeildatensaetze();
    }

    public Datensatz(int satzart, List<? extends Teildatensatz> tdsList) {
        super(satzart, tdsList);
        if (tdsList.get(0).hasSparte()) {
            this.sparte.setInhalt(tdsList.get(0).getSparte());
        }
        this.completeTeildatensaetze();
    }

    public Datensatz(int satzart, int sparte) {
        this(satzart, sparte, 1);
    }

    public Datensatz(int satzart, int sparte, int n) {
        super(satzart, n);
        this.setSparte(sparte);
        this.setUpTeildatensaetze();
    }

    public Datensatz(int satzart, int sparte, List<Teildatensatz> tdsList) {
        this(satzart, Datensatz.complete(tdsList, sparte));
    }

    public Datensatz(SatzTyp satzNr, List<Teildatensatz> tdsList) {
        this(satzNr.getSatzart(), tdsList);
        if (satzNr.hasSparte()) {
            this.setSparte(satzNr.getSparte());
        }
        if (satzNr.hasWagnisart()) {
            this.set(Bezeichner.WAGNISART, Integer.toString(satzNr.getWagnisart()));
        }
        if (satzNr.hasTeildatensatzNummer()) {
            this.setTeildatensatzNummer("" + satzNr.getTeildatensatzNummer());
        }
        this.completeTeildatensaetze();
    }

    public Datensatz(Datensatz other) {
        this(other.getSatzart(), other.getSparte(), other.cloneTeildatensaetze());
        this.art = other.art;
        this.teildatensatzNummer.setInhalt(other.teildatensatzNummer.getInhalt());
        this.wagnisart.setInhalt(other.wagnisart.getInhalt());
    }

    protected void setUpTeildatensaetze() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            this.setUpTeildatensatz(tds);
        }
    }

    protected void setUpTeildatensatz(Teildatensatz tds) {
        Datensatz.setUpTeildatensatz(tds, this.sparte);
    }

    protected static void setUpTeildatensatz(Teildatensatz tds, NumFeld sparte) {
        if (!tds.hasFeld(Feld1bis7.VU_NUMMER)) {
            Datensatz.setUp(tds, Feld1bis7.VU_NUMMER, Config.getVUNummer());
            Datensatz.setUp(tds, Feld1bis7.BUENDELUNGSKENNZEICHEN, new AlphaNumFeld(Feld1bis7.BUENDELUNGSKENNZEICHEN));
            Datensatz.setUp(tds, Feld1bis7.SPARTE, sparte);
            Datensatz.setUp(tds, Feld1bis7.VERSICHERUNGSSCHEINNUMMER, new AlphaNumFeld(Feld1bis7.VERSICHERUNGSSCHEINNUMMER));
            Datensatz.setUp(tds, Feld1bis7.FOLGENUMMER, new NumFeld(Feld1bis7.FOLGENUMMER));
            Datensatz.setUp(tds, Feld1bis7.VERMITTLER, new AlphaNumFeld(Feld1bis7.VERMITTLER));
            LOG.trace(tds + " is set up.");
        }
    }

    private static void setUp(Teildatensatz tds, Enum feldX, Feld value) {
        if (!tds.hasFeld(feldX)) {
            LOG.trace("{} initialized with value {}.", (Object)tds, (Object)value);
            tds.add(value);
        }
    }

    protected final void completeTeildatensaetze() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            this.setUpTeildatensatz(tds);
        }
    }

    protected static List<Teildatensatz> complete(List<Teildatensatz> teildatensaetze, int sparte) {
        NumFeld sparteFeld = new NumFeld(Feld1bis7.SPARTE);
        sparteFeld.setInhalt(sparte);
        for (Teildatensatz tds : teildatensaetze) {
            Datensatz.setUpTeildatensatz(tds, sparteFeld);
        }
        return teildatensaetze;
    }

    protected final void setUpTeildatensatz(int n) {
        this.setUpTeildatensatz(this.getTeildatensatz(n));
    }

    @Override
    public void addFiller() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            tds.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 213, 43));
        }
    }

    public void setSparte(int x) {
        this.sparte.setInhalt(x);
    }

    public void setSparte(String x) {
        String[] parts = x.split("\\.");
        this.setSparte(Integer.parseInt(parts[0]));
        if (parts.length > 1) {
            this.art = Integer.parseInt(parts[1]);
        }
    }

    @Override
    public int getSparte() {
        return this.sparte.toInt();
    }

    public int getArt() {
        return this.art;
    }

    public boolean hasArt() {
        return this.art > 0;
    }

    @Override
    public boolean hasSparte() {
        return !this.sparte.isEmpty() && this.getSparte() > 0;
    }

    public NumFeld getSparteFeld() {
        return this.sparte;
    }

    public void setVuNummer(String s) {
        this.getFeld(Feld1bis7.VU_NUMMER).setInhalt(s);
    }

    public String getVuNummer() {
        return this.getFeld(Feld1bis7.VU_NUMMER).getInhalt().trim();
    }

    public void setVersicherungsscheinNummer(String nr) {
        this.getFeld(Feld1bis7.VERSICHERUNGSSCHEINNUMMER).setInhalt(nr);
    }

    public String getVersicherungsscheinNummer() {
        return this.getFeld(Feld1bis7.VERSICHERUNGSSCHEINNUMMER).getInhalt().trim();
    }

    public String getTeildatensatzNummer() {
        return this.teildatensatzNummer.getInhalt().trim();
    }

    public void setSatznummer(Zeichen satznummer) {
        this.remove(Bezeichner.SATZNUMMER);
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            tds.setSatznummer(satznummer);
        }
    }

    public void setTeildatensatzNummer(String teildatensatzNummer) {
        this.teildatensatzNummer.setInhalt(teildatensatzNummer);
    }

    public void setFolgenummer(int nr) {
        this.getFeld(Feld1bis7.FOLGENUMMER).setInhalt(nr);
    }

    public int getFolgenummer() {
        NumFeld folgenummer = (NumFeld)this.getFeld(Feld1bis7.FOLGENUMMER);
        return folgenummer.toInt();
    }

    public String getVermittler() {
        return this.getFeldInhalt(Bezeichner.VERMITTLER);
    }

    public static int readSparte(PushbackReader reader) throws IOException {
        char[] cbuf = new char[14];
        if (reader.read(cbuf) == -1) {
            throw new IOException("can't read 14 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        String intro = new String(cbuf);
        try {
            return Integer.parseInt(intro.substring(10, 13));
        }
        catch (NumberFormatException ex) {
            throw new ImportException("cannot read sparte from first 14 bytes (\"" + intro + "\")");
        }
    }

    public static int readKrankenFolgeNr(PushbackLineNumberReader reader) throws IOException {
        int satzart = Datensatz.readSatzart(reader);
        if (satzart != 220) {
            throw new IllegalArgumentException("can't read Kranken Folge-Nr., wrong satzart " + satzart + ", must be 220");
        }
        int sparte = Datensatz.readSparte(reader);
        if (sparte != 20) {
            throw new IllegalArgumentException("can't read Kranken Folge-Nr., wrong sparte " + sparte + ", must be 20");
        }
        char[] cbuf = new char[49];
        if (reader.read(cbuf) == -1) {
            throw new IOException("can't read 49 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        String first10Fields = new String(cbuf);
        try {
            return Integer.parseInt(first10Fields.substring(47, 48));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static WagnisartLeben readWagnisart(PushbackReader reader) throws IOException {
        char[] cbuf = new char[60];
        if (reader.read(cbuf) == -1) {
            throw new IOException("can't read 1 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        String wagnisart = new String(cbuf).substring(59, 60);
        if (wagnisart.trim().length() == 0) {
            return WagnisartLeben.NULL;
        }
        try {
            return WagnisartLeben.isIn(Integer.parseInt(wagnisart));
        }
        catch (NumberFormatException e) {
            LOG.warn("Not allowed value for wagnisart found. Type Number is required but was \"" + wagnisart + "\".");
            return WagnisartLeben.NULL;
        }
    }

    @Override
    protected boolean matchesNextTeildatensatz(PushbackLineNumberReader reader, char[] lastFeld1To7, Character satznummer) throws IOException {
        if (super.matchesNextTeildatensatz(reader, lastFeld1To7, satznummer)) {
            if (lastFeld1To7 == null) {
                return this.matchesFirstTeildatensatz(reader);
            }
            char[] newLine = new char[256];
            int res = reader.read(newLine);
            if (res == -1 || res < 256) {
                return false;
            }
            reader.unread(newLine);
            for (int i = 0; i < 42; ++i) {
                if (lastFeld1To7[i] == newLine[i]) continue;
                return false;
            }
            return Datensatz.matchesLastFeld(satznummer, newLine);
        }
        return false;
    }

    private boolean matchesFirstTeildatensatz(PushbackLineNumberReader reader) throws IOException {
        if (this.hasSparte()) {
            return this.getSparte() == Datensatz.readSparte(reader);
        }
        return true;
    }

    private static boolean matchesLastFeld(Character satznummer, char[] newLine) {
        char newSatznummer = Datensatz.readSatznummer(newLine);
        return !Character.isDigit(newSatznummer) || !Character.isDigit(satznummer.charValue()) || newSatznummer > satznummer.charValue();
    }

    @Override
    public String toShortString() {
        StringBuilder buf = new StringBuilder(super.toShortString());
        if (this.hasSparte()) {
            buf.append(".");
            buf.append(this.sparte.getInhalt());
            if (this.hasArt()) {
                buf.append(".");
                buf.append(this.getArt());
            }
        }
        return buf.toString();
    }

    public static TeildatensatzNummer readTeildatensatzNummer(PushbackReader reader) throws IOException {
        char[] cbuf = new char[256];
        if (reader.read(cbuf) == -1) {
            throw new EOFException("can't read 1 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        String teildatenSatz = new String(cbuf).substring(cbuf.length - 1, cbuf.length);
        if (teildatenSatz.trim().length() == 0) {
            return TeildatensatzNummer.NULL;
        }
        try {
            return TeildatensatzNummer.isIn(Integer.parseInt(teildatenSatz));
        }
        catch (NumberFormatException e) {
            LOG.warn("Value \"" + teildatenSatz + "\" for TeildatensatzNummer found, but Number expected.");
            return TeildatensatzNummer.NULL;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Datensatz other = (Datensatz)obj;
        return this.art == other.art;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.art;
    }
}

