/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordReader
extends Reader {
    private static final Logger LOG = LogManager.getLogger(RecordReader.class);
    private final Reader reader;
    private int pos = 257;
    private final int[] buffer = new int[257];
    private int recordNo = 0;

    public RecordReader(Reader in) {
        this.reader = in;
    }

    @Override
    public int read() throws IOException {
        if (this.isBufferEmpty()) {
            this.fillBuffer();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int nrOfChars = 0;
        if (len == 0) {
            return 0;
        }
        for (int i = off; i < off + len && (c = this.read()) != -1; ++i) {
            cbuf[i] = (char)c;
            ++nrOfChars;
        }
        return nrOfChars > 0 ? nrOfChars : -1;
    }

    private void fillBuffer() throws IOException {
        this.buffer[256] = 0;
        this.pos = 0;
        ++this.recordNo;
        for (int i = 0; i < 256; ++i) {
            int ch = this.reader.read();
            if (ch == 10 || ch == 13 || ch == -1) {
                this.buffer[256] = ch;
                if (i == 0) {
                    this.pos = 256;
                    break;
                }
                LOG.info("Record " + this.recordNo + " has only " + i + " characters and is filled with " + (256 - i) + " spaces.");
                this.fillBufferWithSpaces(i);
                break;
            }
            this.buffer[i] = ch;
        }
    }

    private void fillBufferWithSpaces(int start) {
        for (int i = start; i < 256; ++i) {
            this.buffer[i] = 32;
        }
    }

    private boolean isBufferEmpty() {
        return this.pos >= this.buffer.length || this.buffer[this.pos] == 0;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

