/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;

public class PushbackLineNumberReader
extends PushbackReader {
    private int lineNumber = 0;

    public PushbackLineNumberReader(Reader in) {
        super(in);
    }

    public PushbackLineNumberReader(Reader in, int size) {
        super(in, size);
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == 10) {
            ++this.lineNumber;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int ret = super.read(target);
        this.countLineNumber(target.array());
        return ret;
    }

    private void countLineNumber(char[] cbuf) {
        for (int i = 0; i < cbuf.length; ++i) {
            if (cbuf[i] != '\n') continue;
            ++this.lineNumber;
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret = super.read(cbuf, off, len);
        for (int i = 0; i < ret; ++i) {
            if (cbuf[off + i] != '\n') continue;
            ++this.lineNumber;
        }
        return ret;
    }

    public String readLine() throws IOException {
        char[] buf = new char[257];
        int len = 257;
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1 || ch == 10 || ch == 13 || ch == 0) {
                len = i;
                break;
            }
            buf[i] = (char)ch;
        }
        return new String(buf).substring(0, len);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lineNumber = 0;
    }

    @Override
    public void unread(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            if (cbuf[i] != '\n') continue;
            --this.lineNumber;
        }
        super.unread(cbuf, off, len);
    }

    @Override
    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    @Override
    public void unread(int c) throws IOException {
        if (c == 10) {
            --this.lineNumber;
        }
        super.unread(c);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void skipNewline() throws IOException {
        this.skip('\n', '\r');
    }

    public void skipWhitespace() throws IOException {
        this.skip(' ', '\n', '\r', '\t');
    }

    public void skip(char ... chars) throws IOException {
        char[] cbuf = new char[1];
        while (this.read(cbuf) != -1) {
            if (this.isInArray(cbuf[0], chars)) continue;
            this.unread(cbuf);
            break;
        }
    }

    private boolean isInArray(char ch, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (ch != chars[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "line " + this.lineNumber;
    }
}

