/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.annotation.FeldInfo;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.util.SimpleConstraintViolation;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NumFeld
extends Feld {
    private static final Logger LOG = LogManager.getLogger(NumFeld.class);
    private final int nachkommastellen;

    public NumFeld(Enum feldX) {
        this(feldX, Feld.getFeldInfo(feldX));
    }

    public NumFeld(Enum feldX, FeldInfo info) {
        super(feldX, info);
        this.nachkommastellen = info.nachkommaStellen();
        this.setInhalt(0);
    }

    public NumFeld(String name, String s) {
        super(name, s, Align.RIGHT);
        this.nachkommastellen = 0;
    }

    public NumFeld(Bezeichner bezeichner, int length, int start) {
        super(bezeichner, length, start, Align.RIGHT);
        this.nachkommastellen = 0;
        this.setInhalt(0);
    }

    public NumFeld(Bezeichner bezeichner, int length, int start, int value) {
        super(bezeichner, length, start, Align.RIGHT);
        this.nachkommastellen = 0;
        this.setInhalt(value);
    }

    public NumFeld(String name, int start, String value) {
        super(new Bezeichner(name), start, value, Align.RIGHT);
        this.nachkommastellen = 0;
        this.setInhalt(value);
    }

    public NumFeld(String name, String s, int nachkommastellen) {
        super(name, s, Align.RIGHT);
        this.nachkommastellen = nachkommastellen;
    }

    public NumFeld(Bezeichner name, FeldInfo info) {
        super(name, info.anzahlBytes(), info.byteAdresse(), info.align() == Align.UNKNOWN ? Align.RIGHT : info.align());
        this.nachkommastellen = info.nachkommaStellen();
    }

    @Deprecated
    public NumFeld(String name, int start, String value, int nachkommastellen) {
        this(new Bezeichner(name), start, value, nachkommastellen);
    }

    public NumFeld(Bezeichner name, int start, String value, int nachkommastellen) {
        super(name, start, value, Align.RIGHT);
        this.nachkommastellen = nachkommastellen;
        this.setInhalt(value);
    }

    public NumFeld(Bezeichner name, int length, int start, int value, int nachkommastellen) {
        super(name, length, start, Align.RIGHT);
        this.nachkommastellen = nachkommastellen;
        this.setInhalt(value);
    }

    public NumFeld(NumFeld other) {
        super(other);
        this.nachkommastellen = other.nachkommastellen;
    }

    @Override
    protected Align getDefaultAlignment() {
        return Align.RIGHT;
    }

    public NumFeld mitNachkommastellen(int n) {
        if (n > this.getAnzahlBytes()) {
            throw new IllegalArgumentException(n + " Nachkommastellen sind zuviel (max. " + this.getAnzahlBytes() + " moeglich)");
        }
        return new NumFeld(this.getBezeichner(), this.getByteAdresse(), this.getInhalt(), n);
    }

    public int getNachkommastellen() {
        return this.nachkommastellen;
    }

    @Override
    public void setInhalt(int n) {
        this.setInhalt((long)n);
    }

    public void setInhalt(long n) {
        String pattern = StringUtils.repeat((String)"0", (int)this.getAnzahlBytes());
        DecimalFormat format = new DecimalFormat(pattern);
        String formatted = format.format(n);
        this.setInhalt(formatted);
    }

    @Override
    public void resetInhalt() {
        int anzahlBytes = this.getAnzahlBytes();
        for (int i = 0; i < anzahlBytes; ++i) {
            this.setInhalt('0', i);
        }
    }

    public int toInt() {
        String s = this.getInhalt().trim();
        if (s.startsWith("+")) {
            return Integer.parseInt(s.substring(1));
        }
        return Integer.parseInt(s);
    }

    public long toLong() {
        String s = this.getInhalt().trim();
        if (s.startsWith("+")) {
            return Long.parseLong(s.substring(1));
        }
        return Long.parseLong(s);
    }

    public double toDouble() {
        double n = this.toLong();
        long d = 1L;
        for (int i = 0; i < this.nachkommastellen; ++i) {
            d *= 10L;
        }
        return n / (double)d;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        try {
            this.toLong();
        }
        catch (NumberFormatException nfe) {
            LOG.info(this + " is invalid: not a number (" + nfe + ")");
            return false;
        }
        return true;
    }

    @Override
    public List<ConstraintViolation> validate() {
        List<ConstraintViolation> violations = super.validate();
        if (this.hasValue()) {
            try {
                this.toLong();
            }
            catch (NumberFormatException nfe) {
                SimpleConstraintViolation cv = new SimpleConstraintViolation(this, nfe);
                violations.add(cv);
            }
        }
        return violations;
    }

    @Override
    public String format() {
        NumberFormat nf = NumberFormat.getInstance();
        if (this.nachkommastellen == 0) {
            return nf.format(this.toLong());
        }
        nf.setMinimumFractionDigits(this.nachkommastellen);
        nf.setMaximumFractionDigits(this.nachkommastellen);
        return nf.format(this.toDouble());
    }

    @Override
    public Object clone() {
        return new NumFeld(this);
    }
}

