/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.annotation.FeldInfo;
import gdv.xport.config.Config;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.feld.FeldX;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.constraint.Min;
import net.sf.oval.constraint.NotEqual;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Feld
implements Comparable<Feld>,
Cloneable {
    private static final Logger LOG = LogManager.getLogger(Feld.class);
    public static final Feld NULL_FELD = new Feld();
    private final Bezeichner bezeichner;
    private final StringBuilder inhalt;
    @Min(value=1.0)
    private final int byteAdresse;
    @NotEqual(value="UNKNOWN")
    private final Align ausrichtung;

    public Feld() {
        this(FeldX.UNBEKANNT);
    }

    public Feld(Enum feldX) {
        this(feldX, Feld.getFeldInfo(feldX));
    }

    public Feld(Enum feldX, FeldInfo info) {
        this.bezeichner = Feld.getAsBezeichner(feldX);
        this.byteAdresse = info.byteAdresse();
        this.ausrichtung = this.getAlignmentFrom(info);
        this.inhalt = new StringBuilder(info.anzahlBytes());
        for (int i = 0; i < info.anzahlBytes(); ++i) {
            this.inhalt.append(' ');
        }
        this.setInhalt(info.value());
    }

    public Feld(String name, String s, Align alignment) {
        this(new Bezeichner(name), 1, s, alignment);
    }

    public Feld(Bezeichner name, int start, String s, Align alignment) {
        this.bezeichner = name;
        this.inhalt = new StringBuilder(s);
        this.byteAdresse = start;
        this.ausrichtung = alignment;
    }

    public Feld(Bezeichner bezeichner, int length, int start, Align alignment) {
        this.bezeichner = bezeichner;
        this.inhalt = Feld.getEmptyStringBuilder(length);
        this.byteAdresse = start;
        this.ausrichtung = alignment;
    }

    public Feld(String name, int length, int start, char c, Align alignment) {
        this(new Bezeichner(name), length, start, alignment);
        this.setInhalt(c);
    }

    public Feld(String name, int length, int start, String s, Align alignment) {
        this(new Bezeichner(name), length, start, alignment);
        this.setInhalt(s);
    }

    public Feld(String name, int start, char c) {
        this(name, 1, start, c, Align.LEFT);
    }

    public Feld(int start, String s, Align alignment) {
        this.inhalt = new StringBuilder(s);
        this.byteAdresse = start;
        this.ausrichtung = alignment;
        this.bezeichner = this.createBezeichner();
    }

    public Feld(int length, Align alignment) {
        this(length, 1, alignment);
    }

    public Feld(int length, int start, Align alignment) {
        this.inhalt = Feld.getEmptyStringBuilder(length);
        this.byteAdresse = start;
        this.ausrichtung = alignment;
        this.bezeichner = this.createBezeichner();
    }

    public Feld(Feld other) {
        this(other.getBezeichner(), other.getAnzahlBytes(), other.getByteAdresse(), other.ausrichtung);
        this.setInhalt(other.getInhalt());
    }

    private static StringBuilder getEmptyStringBuilder(int length) {
        StringBuilder sbuf = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sbuf.append(' ');
        }
        return sbuf;
    }

    protected Align getDefaultAlignment() {
        return Align.LEFT;
    }

    private Align getAlignmentFrom(FeldInfo info) {
        if (info.align() == Align.UNKNOWN) {
            return this.getDefaultAlignment();
        }
        return info.align();
    }

    private Bezeichner createBezeichner() {
        return new Bezeichner(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
    }

    public static Feld createFeld(Enum feldX, FeldInfo info) {
        try {
            Constructor<? extends Feld> ctor = info.type().getConstructor(Enum.class, FeldInfo.class);
            return ctor.newInstance(feldX, info);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("no constructor " + info.type().getSimpleName() + "(String, FeldInfo) found", ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("can't instantiate " + info.type(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("can't access ctor for " + info.type(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("error invoking ctor for " + info.type() + " (" + ex.getTargetException() + ")", ex);
        }
    }

    public String getBezeichnung() {
        return this.bezeichner.getName();
    }

    public Bezeichner getBezeichner() {
        return this.bezeichner;
    }

    public final void setInhalt(String s) {
        int anzahlBytes = this.getAnzahlBytes();
        if (s.length() > anzahlBytes) {
            throw new IllegalArgumentException("Feld " + this.getBezeichner() + ": Parameter \"" + s + "\" ist laenger als " + anzahlBytes + " Zeichen!");
        }
        this.resetInhalt();
        switch (this.ausrichtung) {
            case LEFT: {
                this.inhalt.replace(0, s.length(), s);
                break;
            }
            case RIGHT: {
                int l = s.length();
                int start = anzahlBytes - l;
                this.inhalt.replace(start, start + l, s);
                break;
            }
            default: {
                throw new IllegalStateException("object was not properly initialized");
            }
        }
    }

    public void setInhalt(int n) {
        this.setInhalt(Integer.toString(n));
    }

    public void setInhalt(char c) {
        this.resetInhalt();
        this.setInhalt(c, 0);
    }

    public void setInhalt(char c, int i) {
        this.inhalt.setCharAt(i, c);
    }

    public String getInhalt() {
        return this.inhalt.toString();
    }

    public void resetInhalt() {
        int anzahlBytes = this.getAnzahlBytes();
        for (int i = 0; i < anzahlBytes; ++i) {
            this.inhalt.setCharAt(i, ' ');
        }
    }

    public void setAnzahlBytes(int n) {
        assert (this.inhalt.length() <= n) : "drohender Datenverlust";
        for (int i = this.inhalt.length(); i < n; ++i) {
            this.inhalt.append(' ');
        }
    }

    public final int getAnzahlBytes() {
        return this.inhalt.length();
    }

    public final int getByteAdresse() {
        return this.byteAdresse;
    }

    public final int getEndAdresse() {
        return this.byteAdresse + this.getAnzahlBytes() - 1;
    }

    public final boolean overlapsWith(Feld other) {
        if (this.byteAdresse == other.byteAdresse) {
            return false;
        }
        if (this.byteAdresse < other.byteAdresse) {
            return this.getEndAdresse() >= other.byteAdresse;
        }
        return other.getEndAdresse() >= this.byteAdresse;
    }

    public final void write(Writer writer) throws IOException {
        writer.write(this.inhalt.toString());
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.getInhalt());
    }

    public boolean hasValue() {
        String value = StringUtils.trimToEmpty((String)this.getInhalt());
        return !value.isEmpty() && !value.equals("0");
    }

    public boolean isValid() {
        if (this.getByteAdresse() < 1) {
            return false;
        }
        if (this.getEndAdresse() > 256) {
            return false;
        }
        if (this.ausrichtung == Align.UNKNOWN) {
            return false;
        }
        return this.validate().isEmpty();
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public List<ConstraintViolation> validate() {
        Validator validator = new Validator();
        List violations = validator.validate((Object)this);
        if (this.getEndAdresse() > 256) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation(this + ": boundary exceeded", this, this.getEndAdresse());
            violations.add(cv);
        }
        return violations;
    }

    public String format() {
        return this.getInhalt();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getBezeichner() + "(" + this.byteAdresse + "-" + this.getEndAdresse() + "): \"" + this.getInhalt().trim() + "\"";
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Feld)) {
            return false;
        }
        Feld other = (Feld)obj;
        return this.bezeichner.equals(other.bezeichner) && this.getInhalt().equals(other.getInhalt()) && this.byteAdresse == other.byteAdresse && this.ausrichtung == other.ausrichtung;
    }

    public final int hashCode() {
        return this.byteAdresse + this.getInhalt().hashCode();
    }

    @Override
    public final int compareTo(Feld other) {
        return this.byteAdresse - other.byteAdresse;
    }

    public static Bezeichner getAsBezeichner(Enum feldX) {
        Object object = Feld.getAsObject(feldX);
        if (object instanceof Bezeichner) {
            return (Bezeichner)object;
        }
        return new Bezeichner((String)object);
    }

    public static String getAsBezeichnung(Enum feldX) {
        return Feld.getAsObject(feldX).toString();
    }

    private static Object getAsObject(Enum feldX) {
        try {
            Field field = Bezeichner.class.getField(feldX.name());
            return field.get(null);
        }
        catch (NoSuchFieldException ex) {
            LOG.info("Bezeichner.{} not found:", (Object)feldX.name());
            LOG.debug("Details:", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Can't get {} as object.", (Object)feldX, (Object)ex);
        }
        catch (IllegalAccessException ex) {
            LOG.warn("Can't access Bezeichner.{}:", (Object)feldX.name(), (Object)ex);
        }
        return Feld.toBezeichnung(feldX);
    }

    public static String toBezeichnung(Enum name) {
        FeldInfo feldInfo = Feld.getFeldInfo(name);
        if (feldInfo == null || StringUtils.isEmpty((String)feldInfo.bezeichnung())) {
            return Feld.toBezeichnung(name.name());
        }
        return feldInfo.bezeichnung();
    }

    private static String toBezeichnung(String name) {
        String converted = name.replaceAll("_", " ");
        ByteBuffer outputBuffer = Config.DEFAULT_ENCODING.encode(converted);
        String convertedISO = new String(outputBuffer.array(), Config.DEFAULT_ENCODING);
        return WordUtils.capitalize((String)convertedISO.toLowerCase());
    }

    protected static FeldInfo getFeldInfo(Enum feldX) {
        try {
            Field field = feldX.getClass().getField(feldX.name());
            return field.getAnnotation(FeldInfo.class);
        }
        catch (NoSuchFieldException nsfe) {
            throw new InternalError("no field " + feldX + " (" + nsfe + ")");
        }
    }

    public Object clone() {
        return new Feld(this);
    }
}

