/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.annotation.FeldInfo;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.util.SimpleConstraintViolation;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Datum
extends Feld {
    private static final Logger LOG = LogManager.getLogger(Feld.class);
    private final DateFormat dateFormat;

    public Datum(Enum feldX) {
        this(feldX, Feld.getFeldInfo(feldX));
    }

    public Datum(Enum feldX, FeldInfo info) {
        super(feldX, info);
        this.dateFormat = Datum.getDateFormat(info.anzahlBytes());
    }

    public Datum(Bezeichner bezeichner, int start) {
        this(bezeichner, 8, start);
    }

    public Datum(String name, int start) {
        this(new Bezeichner(name), 8, start);
    }

    public Datum(String name, String inhalt) {
        this(name, inhalt.length(), 1, inhalt);
    }

    public Datum(Bezeichner bezeichner, int length, int start) {
        super(bezeichner, length, start, Align.RIGHT);
        this.dateFormat = Datum.getDateFormat(length);
    }

    public Datum(Bezeichner bezeichner, FeldInfo info) {
        super(bezeichner, info.anzahlBytes(), info.byteAdresse(), info.align() == Align.UNKNOWN ? Align.RIGHT : info.align());
        this.dateFormat = Datum.getDateFormat(info.anzahlBytes());
    }

    public Datum(String name, int length, int start, String inhalt) {
        this(new Bezeichner(name), length, start);
        this.setInhalt(inhalt);
    }

    public Datum() {
        this(1);
    }

    public Datum(int start) {
        this(8, start);
    }

    public Datum(int length, int start) {
        super(length, start, Align.RIGHT);
        this.dateFormat = Datum.getDateFormat(length);
    }

    public Datum(Datum other) {
        super(other);
        this.dateFormat = other.dateFormat;
    }

    private static DateFormat getDateFormat(int length) {
        return Datum.getDateFormat(length, "");
    }

    private static DateFormat getDateFormat(int length, String separator) {
        switch (length) {
            case 2: {
                return new SimpleDateFormat("dd");
            }
            case 4: {
                return new SimpleDateFormat("MM" + separator + "yy");
            }
            case 6: {
                return new SimpleDateFormat("MM" + separator + "yyyy");
            }
            case 8: {
                return new SimpleDateFormat("dd" + separator + "MM" + separator + "yyyy");
            }
        }
        throw new IllegalArgumentException("length=" + length + " not allowed - only 2, 4, 6 or 8");
    }

    public void setInhalt(Datum d) {
        this.setInhalt(d.getInhalt());
    }

    public void setInhalt(Date d) {
        this.setInhalt(this.dateFormat.format(d));
    }

    public Date toDate() {
        try {
            return this.dateFormat.parse(this.getInhalt());
        }
        catch (ParseException e) {
            throw new IllegalStateException(this + " has an invalid date (\"" + this.getInhalt() + "\")");
        }
    }

    public static Datum heute() {
        Datum d = new Datum();
        d.setInhalt(new Date());
        return d;
    }

    @Override
    public boolean isEmpty() {
        if (super.isEmpty()) {
            return true;
        }
        try {
            int n = Integer.parseInt(this.getInhalt());
            return n == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isValid() {
        if (this.isEmpty()) {
            return true;
        }
        if (!super.isValid()) {
            return false;
        }
        return this.hasValidDate();
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    private boolean hasValidDate() {
        String orig = this.getInhalt();
        if (orig.startsWith("00")) {
            return true;
        }
        try {
            Date date = this.toDate();
            String conv = this.dateFormat.format(date);
            return conv.equals(orig);
        }
        catch (RuntimeException e) {
            LOG.info(e + " -> mapped to false");
            return false;
        }
    }

    @Override
    public List<ConstraintViolation> validate() {
        List<ConstraintViolation> violations = super.validate();
        if (!this.isEmpty() && !this.hasValidDate()) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("'" + this.getInhalt() + "' is not a valid date", this);
            violations.add(cv);
        }
        return violations;
    }

    @Override
    public String format() {
        DateFormat df = Datum.getDateFormat(this.getAnzahlBytes(), ".");
        return df.format(this.toDate());
    }

    @Override
    public Object clone() {
        return new Datum(this);
    }
}

