/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.util.ShitHappenedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public enum Datentyp {
    ALPHANUMERISCH(AlphaNumFeld.class),
    DATUM(Datum.class),
    FLIESSKOMMA(NumFeld.class),
    NUMERISCH(NumFeld.class),
    UHRZEIT(NumFeld.class),
    UNBEKANNT(Feld.class);

    private final Class<? extends Feld> feldClass;

    private Datentyp(Class<? extends Feld> clazz) {
        this.feldClass = clazz;
    }

    public Class<? extends Feld> asClass() {
        return this.feldClass;
    }

    public Feld asFeld(Bezeichner bezeichner, int anzahlBytes, int byteAddress) {
        Class<? extends Feld> clazz = this.asClass();
        try {
            Constructor<? extends Feld> ctor = clazz.getConstructor(Bezeichner.class, Integer.TYPE, Integer.TYPE);
            return ctor.newInstance(bezeichner, anzahlBytes, byteAddress);
        }
        catch (SecurityException ex) {
            throw new ShitHappenedException("cannot instantiate " + clazz, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ShitHappenedException("cannot find needed constructor of " + clazz, ex);
        }
        catch (InstantiationException ex) {
            throw new ShitHappenedException("cannot instantiate " + clazz, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ShitHappenedException("cannot access constructor of " + clazz, ex);
        }
        catch (InvocationTargetException ex) {
            throw new ShitHappenedException("cannot invoke " + clazz, ex);
        }
    }

    public static Datentyp asValue(String name) {
        return Datentyp.valueOf(name.toUpperCase());
    }
}

