/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.annotation.FeldInfo;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;

public final class BetragMitVorzeichen
extends Betrag {
    public BetragMitVorzeichen(Enum feldX) {
        this(feldX, Feld.getFeldInfo(feldX));
    }

    public BetragMitVorzeichen(Enum feldX, FeldInfo info) {
        super(feldX, info);
        this.setVorzeichen('+');
    }

    public BetragMitVorzeichen(Bezeichner name, int length, int start) {
        super(name, length, start);
        this.setVorzeichen('+');
    }

    public BetragMitVorzeichen(Bezeichner name, FeldInfo info) {
        super(name, info);
        this.setVorzeichen('+');
    }

    public BetragMitVorzeichen(BetragMitVorzeichen other) {
        super(other);
    }

    public void setVorzeichen(char c) {
        this.setInhalt(c, this.getAnzahlBytes() - 1);
    }

    public char getVorzeichen() {
        String s = this.getInhalt();
        return s.charAt(s.length() - 1);
    }

    @Override
    public void setInhalt(double x) {
        if (x >= 0.0) {
            super.setInhalt(x * 10.0);
            this.setVorzeichen('+');
        } else {
            super.setInhalt(-x * 10.0);
            this.setVorzeichen('-');
        }
    }

    @Override
    public void setInhalt(int n) {
        this.setInhalt((long)n);
    }

    @Override
    public void setInhalt(long n) {
        if (n >= 0L) {
            super.setInhalt(n * 10L);
            this.setVorzeichen('+');
        } else {
            super.setInhalt(-n * 10L);
            this.setVorzeichen('-');
        }
    }

    @Override
    public double toDouble() {
        String s = this.getInhalt();
        double x = (double)Integer.parseInt(s.substring(0, s.length() - 1)) / 100.0;
        return this.getVorzeichen() == '-' ? -x : x;
    }

    @Override
    public int toInt() {
        String s = this.getInhalt();
        int x = Integer.parseInt(s.substring(0, s.length() - 1)) / 100;
        return this.getVorzeichen() == '-' ? -x : x;
    }

    @Override
    public long toLong() {
        String s = this.getInhalt();
        long x = Long.parseLong(s.substring(0, s.length() - 1)) / 100L;
        return this.getVorzeichen() == '-' ? -x : x;
    }

    @Override
    public void resetInhalt() {
        super.resetInhalt();
        this.setVorzeichen('+');
    }

    @Override
    public Object clone() {
        return new BetragMitVorzeichen(this);
    }
}

