/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.demo;

import gdv.xport.Datenpaket;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.feld.Feld100;
import gdv.xport.util.SatzFactory;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ImportExport {
    private static final Logger LOG = LogManager.getLogger(ImportExport.class);

    public static void exportSatz100(File file) throws IOException {
        Datensatz satz100 = SatzFactory.getDatensatz(100);
        satz100.set((Enum)Feld100.ANREDESCHLUESSEL, 1);
        satz100.set((Enum)Feld100.NAME1, "Duck");
        satz100.set((Enum)Feld100.NAME3, "Dagobert");
        satz100.set((Enum)Feld100.GESCHLECHT, Character.valueOf('1'));
        satz100.export(file);
    }

    public static Datensatz importSatz100(File file) throws IOException {
        Datensatz satz100 = SatzFactory.getDatensatz(100);
        satz100.importFrom(file);
        LOG.info("Datensatz " + satz100.getSatzart() + " von " + satz100.getFeld(Feld100.NAME3) + " " + satz100.getFeld(Feld100.NAME1) + " importiert.");
        return satz100;
    }

    public static List<Datenpaket> importDatenpakete(InputStream inputStream) throws IOException {
        ArrayList<Datenpaket> datenpakete = new ArrayList<Datenpaket>();
        while (inputStream.available() >= 0) {
            Datenpaket paket = new Datenpaket();
            try {
                paket.importFrom(inputStream);
                datenpakete.add(paket);
            }
            catch (EOFException ex) {
                LOG.info("EOF nach " + datenpakete.size() + " Datenpaketen erreicht.", (Throwable)ex);
                break;
            }
        }
        return datenpakete;
    }

    private ImportExport() {
    }
}

