/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.config;

import gdv.xport.config.ConfigException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LogConfig {
    private static final Logger LOG = LogManager.getLogger(LogConfig.class);
    private static LogConfig instance = new LogConfig();
    private final URI dbURI;

    public LogConfig() {
        this(LogConfig.readDatabaseURL());
    }

    public LogConfig(URI uri) {
        this.dbURI = uri;
        LogConfig.createLogTable(uri);
        instance = this;
        LOG.trace("LogConfig is created with '{}'.", (Object)uri);
    }

    public LogConfig(URI uri, String username, String password) {
        this(URI.create(uri + "?user=" + LogConfig.encode(username) + "&password=" + LogConfig.encode(password)));
    }

    private static String encode(String parameter) {
        try {
            return URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn("Cannot encode '{}' in UTF-8:", (Object)parameter, (Object)ex);
            return parameter;
        }
    }

    private static URI readDatabaseURL() {
        String dbURL = System.getenv("DATABASE_URL");
        if (dbURL != null) {
            LOG.info("Read DATABASE_URL='{}' from environment.", (Object)dbURL);
            return URI.create(dbURL);
        }
        return URI.create(System.getProperty("DATABASE_URL", "jdbc:hsqldb:mem:logdb"));
    }

    public static LogConfig getLastInstance() {
        return instance;
    }

    public URI getDbURI() {
        return this.dbURI;
    }

    public static Connection getConnection() throws SQLException {
        return instance.getDbConnection();
    }

    public Connection getDbConnection() throws SQLException {
        Connection connection = LogConfig.getConnection(this.dbURI);
        connection.setAutoCommit(true);
        return connection;
    }

    private static Connection getConnection(URI uri) throws SQLException {
        String scheme = uri.getScheme();
        if (uri.getScheme().startsWith("jdbc")) {
            return DriverManager.getConnection(uri.toString());
        }
        String[] userinfos = uri.getUserInfo().split(":");
        String path = uri.getPath();
        if (scheme.startsWith("postgres")) {
            scheme = "postgresql";
            path = path + "?sslmode=require";
        }
        String dbUrl = "jdbc:" + scheme + "://" + uri.getHost() + ':' + uri.getPort() + path;
        LOG.debug("Connect to '{}'.", (Object)dbUrl);
        return DriverManager.getConnection(dbUrl, userinfos[0], userinfos[1]);
    }

    private static void createLogTable(URI jdbcURL) {
        try (Connection connection = LogConfig.getConnection(jdbcURL);
             Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS logbook (event_date TIMESTAMP, level CHAR(5), logger VARCHAR (255), message VARCHAR (65535), throwable VARCHAR (65535))");
            LOG.debug("Table 'logbook' is created (update count = {}).", (Object)stmt.getUpdateCount());
        }
        catch (SQLException sex) {
            throw new ConfigException("cannot create logbook", sex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.dbURI + ")";
    }
}

