/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.config;

import gdv.xport.feld.VUNummer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Config {
    public static final Charset DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    public static final String DEFAULT_ENCODING_NAME = DEFAULT_ENCODING.toString();
    public static final String DUMMY_VU_NUMMER = "DUMMY";
    public static final String GDV_VU_NUMMER = "gdv.VU-Nummer";
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private static VUNummer vunummer;
    private static String eod;

    private Config() {
    }

    public static synchronized void reset() {
        vunummer = null;
    }

    public static synchronized void setVUNummer(String nr) {
        Config.setVUNummer(new VUNummer(nr));
    }

    public static synchronized void setVUNummer(VUNummer nr) {
        vunummer = nr;
        LOG.info("konfigurierte VU-Nummer: " + vunummer);
    }

    public static synchronized VUNummer getVUNummer() {
        if (vunummer == null) {
            vunummer = new VUNummer(System.getProperty(GDV_VU_NUMMER, DUMMY_VU_NUMMER));
        }
        return vunummer;
    }

    public static synchronized void setEOD(String linefeed) {
        eod = linefeed;
    }

    public static synchronized String getEOD() {
        return eod;
    }

    public static synchronized boolean hasEOD() {
        return StringUtils.isNotEmpty((String)eod);
    }

    static {
        eod = "\n";
    }
}

