/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport;

import gdv.xport.Datenpaket;
import gdv.xport.util.AbstractFormatter;
import gdv.xport.util.HtmlFormatter;
import gdv.xport.util.NullFormatter;
import gdv.xport.util.XmlFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.oval.ConstraintViolation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullWriter;

public final class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws IOException {
        Options options = Main.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("help")) {
                Main.printHelp(options);
                System.exit(0);
            }
            Datenpaket datenpaket = Main.importDatenpaket(cmd);
            Main.formatDatenpaket(cmd, datenpaket);
            if (cmd.hasOption("validate")) {
                Main.printViolations(datenpaket.validate());
            }
        }
        catch (ParseException ex) {
            LOG.log(Level.SEVERE, "Cannot parse " + Arrays.toString(args), ex);
            System.err.println("Fehler beim Aufruf von " + Main.class);
            Main.printHelp(options);
            System.exit(1);
        }
    }

    private static Datenpaket importDatenpaket(CommandLine cmd) throws IOException {
        Datenpaket datenpaket = new Datenpaket();
        if (cmd.hasOption("import")) {
            String filename = cmd.getOptionValue("import");
            Main.importFrom(filename, datenpaket);
        } else {
            System.out.println("Warte auf Eingabe von STDIN...");
            datenpaket.importFrom(System.in);
        }
        return datenpaket;
    }

    private static void formatDatenpaket(CommandLine cmd, Datenpaket datenpaket) throws IOException {
        AbstractFormatter formatter = new NullFormatter((Writer)new NullWriter());
        if (cmd.hasOption("xml")) {
            formatter = new XmlFormatter();
        } else if (cmd.hasOption("html")) {
            formatter = new HtmlFormatter();
        }
        if (cmd.hasOption("export")) {
            File file = new File(cmd.getOptionValue("export"));
            if (formatter instanceof NullFormatter) {
                String suffix = FilenameUtils.getExtension((String)file.getName());
                if ("xml".equalsIgnoreCase(suffix)) {
                    formatter = new XmlFormatter();
                } else if ("html".equalsIgnoreCase(suffix)) {
                    formatter = new HtmlFormatter();
                }
            }
            try (FileOutputStream ostream = new FileOutputStream(file);){
                formatter.setWriter(ostream);
                formatter.write(datenpaket);
            }
        } else {
            formatter.write(datenpaket);
        }
    }

    private static void importFrom(String filename, Datenpaket datenpaket) throws IOException {
        try {
            URL url = new URL(filename);
            datenpaket.importFrom(url);
        }
        catch (MalformedURLException e) {
            LOG.fine("Will use '" + filename + "' as filename:" + e);
            datenpaket.importFrom(new File(filename));
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("import", true, "Import-Datei");
        options.addOption("validate", false, "Validierung der eingelesenen Datensaetze");
        options.addOption("xml", false, "Ausgabe als XML");
        options.addOption("html", false, "Ausgabe als HTML");
        options.addOption("export", true, "Export-Datei (bei .xml/.html als Endung ist das Format XML/HTML, ansonsten GDV)");
        options.addOption("help", false, "Kurz-Hilfe");
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getName(), options);
    }

    private static void printViolations(List<ConstraintViolation> violations) {
        if (violations.isEmpty()) {
            System.out.println("keine Datensatz-Verletzung gefunden");
        } else {
            for (ConstraintViolation violation : violations) {
                System.err.println(violation.getValidatedObject() + ": " + violation.getMessage());
            }
        }
    }

    private Main() {
    }
}

