/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.event.ImportListener;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.io.RecordReader;
import gdv.xport.io.RecyclingInputStreamReader;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class DatenpaketStreamer {
    private final PushbackLineNumberReader reader;
    private final List<ImportListener> importListener = new ArrayList<ImportListener>();

    public DatenpaketStreamer(InputStream istream) {
        this(new RecyclingInputStreamReader(istream, Config.DEFAULT_ENCODING));
    }

    public DatenpaketStreamer(Reader reader) {
        this.reader = new PushbackLineNumberReader(new RecordReader(reader), 256);
    }

    public void register(ImportListener listener) {
        this.importListener.add(listener);
    }

    public void readDatenpaket() throws IOException {
        Satz satz;
        this.readVorsatz();
        do {
            satz = Datenpaket.importSatz(this.reader);
            this.notice(satz);
        } while (satz.getSatzart() != 9999);
    }

    public boolean canReadDatenpaket() {
        try {
            return Vorsatz.readSatzart(this.reader) == 1;
        }
        catch (IOException ex) {
            return false;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private void readVorsatz() throws IOException {
        Vorsatz vorsatz = new Vorsatz();
        vorsatz.importFrom(this.reader);
        this.notice(vorsatz);
    }

    private void notice(Satz satz) {
        for (ImportListener listener : this.importListener) {
            listener.notice(satz);
        }
    }
}

