/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport;

import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.io.ExtendedEOFException;
import gdv.xport.io.ImportException;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.io.RecordReader;
import gdv.xport.io.RecyclingInputStreamReader;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Nachsatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.satz.feld.FeldX;
import gdv.xport.satz.feld.common.TeildatensatzNummer;
import gdv.xport.satz.feld.common.WagnisartLeben;
import gdv.xport.satz.model.SatzX;
import gdv.xport.util.SatzFactory;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.SimpleConstraintViolation;
import gdv.xport.util.URLReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Datenpaket {
    private static final Logger LOG = LogManager.getLogger(Datenpaket.class);
    private final Vorsatz vorsatz = new Vorsatz();
    private final List<Datensatz> datensaetze = new ArrayList<Datensatz>();
    private Nachsatz nachsatz = new Nachsatz();

    public Datenpaket() {
        this(Config.getVUNummer().getInhalt());
    }

    public Datenpaket(String vuNummer) {
        Datum heute = Datum.heute();
        this.setErstellungsDatumVon(heute);
        this.setErstellungsDatumBis(heute);
        this.setVuNummer(vuNummer);
        this.setAbsender(vuNummer);
        LOG.debug(this + " created.");
    }

    public void setVuNummer(String vuNummer) {
        this.vorsatz.setVuNummer(vuNummer);
        for (Datensatz datensatz : this.datensaetze) {
            datensatz.setVuNummer(vuNummer);
        }
    }

    public String getVuNummer() {
        return this.vorsatz.getVuNummer();
    }

    public List<Datensatz> getDatensaetze() {
        return Collections.unmodifiableList(this.datensaetze);
    }

    public void setDatensaetze(List<Datensatz> datensaetze) {
        this.datensaetze.clear();
        this.datensaetze.addAll(datensaetze);
    }

    public Vorsatz getVorsatz() {
        return this.vorsatz;
    }

    public Nachsatz getNachsatz() {
        return this.nachsatz;
    }

    public void add(Datensatz datensatz) {
        this.datensaetze.add(datensatz);
        this.nachsatz.increaseAnzahlSaetze();
    }

    public void export(File file) throws IOException {
        this.export(file, Charset.defaultCharset());
    }

    public void export(File file, String encoding) throws IOException {
        this.export(file, Charset.forName(encoding));
    }

    public void export(File file, Charset encoding) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            this.export(writer);
        }
    }

    public void export(OutputStream ostream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING);
        this.export(writer);
        ((Writer)writer).flush();
        ostream.flush();
    }

    public void export(Writer writer) throws IOException {
        this.vorsatz.export(writer);
        for (Datensatz datensatz : this.datensaetze) {
            datensatz.export(writer);
        }
        this.nachsatz.export(writer);
        LOG.info(this.datensaetze.size() + " Datensaetze exported.");
    }

    public void importFrom(URI uri) throws IOException {
        this.importFrom(uri.toURL());
    }

    public void importFrom(URL url) throws IOException {
        URLReader urlReader = new URLReader(url);
        String content = urlReader.read();
        this.importFrom(content);
    }

    public void importFrom(String content) throws IOException {
        StringReader reader = new StringReader(content);
        this.importFrom(reader);
        ((Reader)reader).close();
    }

    public void importFrom(InputStream istream) throws IOException {
        RecyclingInputStreamReader reader = new RecyclingInputStreamReader(istream, Config.DEFAULT_ENCODING);
        this.importFrom(reader);
    }

    public void importFrom(Reader reader) throws IOException {
        PushbackLineNumberReader lnr = new PushbackLineNumberReader(new RecordReader(reader), 256);
        try {
            this.importFrom(lnr);
        }
        catch (EOFException eofe) {
            throw new ExtendedEOFException("line " + lnr.getLineNumber() + ": " + eofe.getMessage(), eofe);
        }
        catch (IOException ioe) {
            throw new ImportException(lnr, "read error", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException(lnr, "number expected, but found: \"" + lnr.readLine() + '\"', nfe);
        }
    }

    public void importFrom(PushbackLineNumberReader reader) throws IOException {
        Satz satz;
        this.vorsatz.importFrom(reader);
        while (true) {
            if ((satz = Datenpaket.importSatz(reader)).getSatzart() == 9999) break;
            this.add((Datensatz)satz);
        }
        this.nachsatz = (Nachsatz)satz;
    }

    public static Satz importSatz(PushbackLineNumberReader reader) throws IOException {
        int satzart = Satz.readSatzart(reader);
        LOG.debug("reading Satzart " + satzart + "...");
        if (satzart == 9999) {
            Nachsatz nachsatz = new Nachsatz();
            nachsatz.importFrom(reader);
            return nachsatz;
        }
        return Datenpaket.importDatensatz(reader, satzart);
    }

    private static Datensatz importDatensatz(PushbackLineNumberReader reader, int satzart) throws IOException {
        int sparte = Datensatz.readSparte(reader);
        WagnisartLeben wagnisart = WagnisartLeben.NULL;
        TeildatensatzNummer teildatensatzNummer = TeildatensatzNummer.NULL;
        if (sparte == 10 && satzart > 210 && (wagnisart = Datensatz.readWagnisart(reader)) != WagnisartLeben.NULL) {
            teildatensatzNummer = Datensatz.readTeildatensatzNummer(reader);
        }
        int krankenFolgeNr = -1;
        if (sparte == 20 && satzart == 220 && (krankenFolgeNr = Datensatz.readKrankenFolgeNr(reader)) == -1) {
            SatzX satz = new SatzX(220, 20, FeldX.class);
            satz.importFrom(reader);
            return satz;
        }
        Datensatz satz = SatzFactory.getDatensatz(new SatzTyp(satzart, sparte, wagnisart.getCode(), krankenFolgeNr, teildatensatzNummer.getCode()));
        satz.importFrom(reader);
        return satz;
    }

    public void importFrom(File file) throws IOException {
        this.importFrom(file, Config.DEFAULT_ENCODING);
    }

    public void importFrom(File file, String encoding) throws IOException {
        this.importFrom(file, Charset.forName(encoding));
    }

    public void importFrom(File file, Charset encoding) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
            this.importFrom(reader);
        }
    }

    public void setErstellungsDatumVon(Datum d) {
        Datum von = this.getErstellungsDatumVon();
        von.setInhalt(d);
    }

    public Datum getErstellungsDatumVon() {
        return (Datum)this.vorsatz.getFeld(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_VOM);
    }

    public void setErstellungsDatumBis(Datum d) {
        Datum bis = this.getErstellungsDatumBis();
        bis.setInhalt(d);
    }

    public Datum getErstellungsDatumBis() {
        return (Datum)this.vorsatz.getFeld(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_BIS);
    }

    public void setAbsender(String s) {
        Feld absender = this.getAbsenderFeld();
        absender.setInhalt(s);
    }

    public String getAbsender() {
        return this.getAbsenderFeld().getInhalt().trim();
    }

    private Feld getAbsenderFeld() {
        return this.vorsatz.getFeld(Bezeichner.ABSENDER);
    }

    public void setAdressat(String s) {
        Feld adressat = this.getAdressatFeld();
        adressat.setInhalt(s);
    }

    public String getAdressat() {
        return this.getAdressatFeld().getInhalt().trim();
    }

    private Feld getAdressatFeld() {
        return this.vorsatz.getFeld(Bezeichner.ADRESSAT);
    }

    public void setVermittler(String s) {
        this.vorsatz.setVermittler(s);
        this.nachsatz.setVermittler(s);
    }

    public String getVermittler() {
        String vermittler = this.vorsatz.getVermittler();
        assert (vermittler.equals(this.nachsatz.getVermittler())) : this.vorsatz + " or " + this.nachsatz + " is corrupt";
        return vermittler;
    }

    public boolean isValid() {
        if (!this.vorsatz.isValid()) {
            LOG.info(this.vorsatz + " is not valid");
            return false;
        }
        if (!this.nachsatz.isValid()) {
            LOG.info(this.nachsatz + " is not valid");
            return false;
        }
        for (Satz satz : this.datensaetze) {
            if (satz.isValid()) continue;
            LOG.info(satz + " is not valid");
            return false;
        }
        if (!this.validateFolgenummern().isEmpty()) {
            LOG.info("Folgenummern stimmen nicht");
            return false;
        }
        if (!this.validateVUNummer().isEmpty()) {
            LOG.info("VU-Nummer is not set / not valid");
            return false;
        }
        return true;
    }

    public List<ConstraintViolation> validate() {
        Validator validator = new Validator();
        List violations = validator.validate((Object)this);
        violations.addAll(this.validateVUNummer());
        violations.addAll(this.vorsatz.validate());
        for (Satz satz : this.datensaetze) {
            violations.addAll(satz.validate());
        }
        violations.addAll(this.validateFolgenummern());
        violations.addAll(this.nachsatz.validate());
        return violations;
    }

    private List<ConstraintViolation> validateVUNummer() {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        if ("DUMMY".equals(this.getVuNummer())) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("VU-Nummer is not set", this, "DUMMY");
            violations.add(cv);
        }
        return violations;
    }

    private List<ConstraintViolation> validateFolgenummern() {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        HashMap<String, Integer> folgenummern = new HashMap<String, Integer>();
        for (Datensatz datensatz : this.datensaetze) {
            String nr = datensatz.getVersicherungsscheinNummer().trim();
            String key = nr + datensatz.getSatzartFeld().getInhalt() + datensatz.getSparteFeld().getInhalt();
            Integer expected = folgenummern.computeIfAbsent(key, k -> 1);
            int folgenr = datensatz.getFolgenummer();
            if (folgenr == expected) continue;
            Integer n = expected;
            Integer n2 = expected = Integer.valueOf(expected + 1);
            folgenummern.put(key, expected);
            if (folgenr == expected) continue;
            SimpleConstraintViolation cv = new SimpleConstraintViolation("falsche Folgenummer (erwartet: " + expected + ")", datensatz, folgenr);
            violations.add(cv);
        }
        return violations;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.getVuNummer() + " with " + this.datensaetze.size() + "+2 (Daten-)Saetze";
    }
}

